/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.applicationIndexer.control;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public abstract class AbstractIndexer {
    final AdminController admin = new AdminController(null);
    static final String silvertraceModule = "applicationIndexer";

    void setSilverTraceLevel() {
        SilverTrace.setTraceLevel((String)silvertraceModule, (int)2);
    }

    public void indexAllSpaces() throws Exception {
        this.index(null, null);
    }

    public void index(String currentSpaceId, String componentId) throws Exception {
        this.setSilverTraceLevel();
        SilverTrace.info((String)silvertraceModule, (String)"AbstractIndexer.index()", (String)"root.MSG_GEN_ENTER_METHOD");
        if (currentSpaceId == null) {
            String[] spaceIds = OrganisationControllerFactory.getOrganisationController().getAllSpaceIds();
            SilverTrace.info((String)silvertraceModule, (String)"AbstractIndexer.index()", (String)"applicationIndexer.MSG_INDEXING_ALL_SPACES");
            for (String spaceId : spaceIds) {
                this.indexSpace(spaceId);
            }
        } else if (!StringUtil.isDefined((String)componentId)) {
            this.indexSpace(currentSpaceId);
        } else {
            this.indexComponent(currentSpaceId, componentId);
        }
        SilverTrace.info((String)silvertraceModule, (String)"AbstractIndexer.index()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    public void indexSpace(String spaceId) throws Exception {
        String[] subSpaceIds;
        String[] componentIds;
        String currentSpaceId = spaceId;
        SilverTrace.info((String)silvertraceModule, (String)"AbstractIndexer.indexSpace()", (String)"applicationIndexer.MSG_START_INDEXING_SPACE", (String)("spaceId = " + currentSpaceId));
        if (currentSpaceId.startsWith("WA")) {
            currentSpaceId = currentSpaceId.substring(2);
        }
        this.admin.indexSpace(Integer.parseInt(currentSpaceId));
        for (String componentId : componentIds = OrganisationControllerFactory.getOrganisationController().getAllComponentIds(currentSpaceId)) {
            this.indexComponent(currentSpaceId, componentId);
        }
        for (String subSpaceId : subSpaceIds = OrganisationControllerFactory.getOrganisationController().getAllSubSpaceIds(currentSpaceId)) {
            this.indexSpace(subSpaceId);
        }
        SilverTrace.info((String)silvertraceModule, (String)"AbstractIndexer.indexSpace()", (String)"applicationIndexer.MSG_END_INDEXING_SPACE", (String)("spaceId = " + currentSpaceId));
    }

    public void indexPersonalComponents() {
        this.indexPersonalComponent("Agenda");
        this.indexPersonalComponent("Todo");
    }

    public abstract void indexComponent(String var1, String var2) throws Exception;

    public abstract void indexPersonalComponent(String var1);
}

