/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.applicationIndexer.control;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.applicationIndexer.control.AbstractIndexer;
import com.stratelia.webactiv.applicationIndexer.control.FileFilterAgenda;
import com.stratelia.webactiv.applicationIndexer.control.FileFilterTodo;
import java.io.File;
import java.io.FilenameFilter;
import org.silverpeas.search.indexEngine.IndexFileManager;
import org.silverpeas.search.indexEngine.model.DidYouMeanIndexer;

public class ApplicationDYMIndexer
extends AbstractIndexer {
    public ApplicationDYMIndexer() {
        this.setSilverTraceLevel();
    }

    public void indexAll() throws Exception {
        this.indexAllSpaces();
        this.indexPersonalComponents();
        this.indexPdc();
    }

    @Override
    public void indexComponent(String spaceId, String componentId) throws Exception {
        SilverTrace.info((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexComponent()", (String)"applicationIndexer.MSG_START_INDEXING_COMPONENT", (String)("component = " + componentId));
        try {
            String ComponentIndexPath = IndexFileManager.getAbsoluteIndexPath(null, (String)componentId);
            DidYouMeanIndexer.createSpellIndexForAllLanguage((String)"content", (String)ComponentIndexPath);
        }
        catch (Exception e) {
            SilverTrace.error((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexComponent()", (String)"applicationIndexer.EX_INDEXING_COMPONENT_FAILED", (String)("component = " + componentId), (Throwable)e);
        }
        SilverTrace.info((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexComponent()", (String)"applicationIndexer.MSG_END_INDEXING_COMPONENT", (String)("component = " + componentId));
    }

    @Override
    public void indexPersonalComponent(String personalComponent) {
        SilverTrace.info((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexPersonalComponent()", (String)"applicationIndexer.MSG_START_INDEXING_PERSONAL_COMPONENT", (String)("personalComponent = " + personalComponent));
        try {
            String[] paths;
            File file = new File(IndexFileManager.getIndexUpLoadPath());
            FilenameFilter filter = null;
            if ("agenda".equalsIgnoreCase(personalComponent)) {
                filter = new FileFilterAgenda();
            } else if ("todo".equalsIgnoreCase(personalComponent)) {
                filter = new FileFilterTodo();
            } else {
                SilverTrace.error((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexPersonalComponent()", (String)"applicationIndexer.EX_INDEXING_PERSONAL_COMPONENT_FAILED", (String)("personalComponent = " + personalComponent));
                return;
            }
            for (String personalComponentName : paths = file.list(filter)) {
                String personalComponentIndexPath = IndexFileManager.getAbsoluteIndexPath(null, (String)personalComponentName);
                DidYouMeanIndexer.createSpellIndex((String)"content", (String)personalComponentIndexPath);
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexPersonalComponent()", (String)"applicationIndexer.EX_INDEXING_PERSONAL_COMPONENT_FAILED", (String)("personalComponent = " + personalComponent), (Throwable)e);
        }
        SilverTrace.info((String)ApplicationDYMIndexer.class.toString(), (String)"ApplicationDYMIndexer.indexPersonalComponent()", (String)"applicationIndexer.MSG_END_INDEXING_PERSONAL_COMPONENT", (String)("personalComponent = " + personalComponent));
    }

    public void indexPdc() {
        this.setSilverTraceLevel();
        String pdcIndexPath = IndexFileManager.getAbsoluteIndexPath(null, (String)"pdc");
        DidYouMeanIndexer.createSpellIndexForAllLanguage((String)"content", (String)pdcIndexPath);
    }
}

