/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.applicationIndexer.control;

import com.silverpeas.pdc.PdcIndexer;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.applicationIndexer.control.AbstractIndexer;
import com.stratelia.webactiv.applicationIndexer.control.ComponentIndexerAdapter;
import com.stratelia.webactiv.applicationIndexer.control.ComponentIndexerInterface;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class ApplicationIndexer
extends AbstractIndexer {
    private MainSessionController mainSessionController = null;

    public ApplicationIndexer(MainSessionController msc) {
        this.mainSessionController = msc;
    }

    public void indexAll() throws Exception {
        this.indexAllSpaces();
        this.indexPersonalComponents();
        this.indexPdc();
        this.indexGroups();
        this.indexUsers();
    }

    public void index(String personalComponent) throws Exception {
        this.setSilverTraceLevel();
        if (personalComponent != null) {
            this.indexPersonalComponent(personalComponent);
        }
    }

    public void indexComponent(String spaceId, ComponentInstLight compoInst) {
        SilverTrace.info((String)"applicationIndexer", (String)"ApplicationIndexer.indexComponent()", (String)"applicationIndexer.MSG_START_INDEXING_COMPONENT", (String)("component = " + compoInst.getLabel()));
        this.admin.indexComponent(compoInst.getId());
        ComponentIndexerInterface componentIndexer = this.getIndexer(compoInst);
        if (componentIndexer != null) {
            try {
                ComponentContext componentContext = this.mainSessionController.createComponentContext(spaceId, compoInst.getId());
                componentIndexer.index(this.mainSessionController, componentContext);
            }
            catch (Exception e) {
                SilverTrace.error((String)"applicationIndexer", (String)"ApplicationIndexer.indexComponent()", (String)"applicationIndexer.EX_INDEXING_COMPONENT_FAILED", (String)("component = " + compoInst.getLabel()), (Throwable)e);
            }
            SilverTrace.info((String)"applicationIndexer", (String)"ApplicationIndexer.indexComponent()", (String)"applicationIndexer.MSG_END_INDEXING_COMPONENT", (String)("component = " + compoInst.getLabel()));
        } else {
            SilverTrace.info((String)"applicationIndexer", (String)"ApplicationIndexer.indexComponent()", (String)"applicationIndexer.MSG_COMPONENT_INDEXER_NOT_FOUND", (String)("component = " + compoInst.getLabel()));
        }
    }

    @Override
    public void indexPersonalComponent(String personalComponent) {
        SilverTrace.info((String)"applicationIndexer", (String)"ApplicationIndexer.indexPersonalComponent()", (String)"applicationIndexer.MSG_START_INDEXING_PERSONAL_COMPONENT", (String)("personalComponent = " + personalComponent));
        String compoName = this.firstLetterToLowerCase(personalComponent);
        try {
            ComponentContext componentContext = this.mainSessionController.createComponentContext(null, null);
            componentContext.setCurrentComponentId(personalComponent);
            ComponentIndexerInterface componentIndexer = (ComponentIndexerInterface)Class.forName("com.stratelia.webactiv." + compoName + "." + personalComponent + "Indexer").newInstance();
            componentIndexer.index(this.mainSessionController, componentContext);
        }
        catch (ClassNotFoundException ce) {
            SilverTrace.warn((String)"applicationIndexer", (String)"ApplicationIndexer.indexPersonalComponent()", (String)"applicationIndexer.EX_INDEXER_PERSONAL_COMPONENT_NOT_FOUND", (String)("personalComponent = " + personalComponent));
        }
        catch (Exception e) {
            SilverTrace.error((String)"applicationIndexer", (String)"ApplicationIndexer.indexPersonalComponent()", (String)"applicationIndexer.EX_INDEXING_PERSONAL_COMPONENT_FAILED", (String)("personalComponent = " + personalComponent), (Throwable)e);
        }
        SilverTrace.info((String)"applicationIndexer", (String)"ApplicationIndexer.indexPersonalComponent()", (String)"applicationIndexer.MSG_END_INDEXING_PERSONAL_COMPONENT", (String)("personalComponent = " + personalComponent));
    }

    @Override
    public void indexComponent(String spaceId, String componentId) throws Exception {
        ComponentInstLight compoInst = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(componentId);
        this.indexComponent(spaceId, compoInst);
    }

    public void indexPdc() throws Exception {
        this.setSilverTraceLevel();
        PdcIndexer indexer = new PdcIndexer();
        indexer.index();
    }

    String firstLetterToUpperCase(String str) {
        return StringUtil.capitalize((String)str);
    }

    String firstLetterToLowerCase(String str) {
        return StringUtil.uncapitalize((String)str);
    }

    ComponentIndexerInterface getIndexer(ComponentInstLight compoInst) {
        ComponentIndexerInterface componentIndexer;
        String compoName = this.firstLetterToUpperCase(compoInst.getName());
        String className = this.getClassName(compoInst);
        String packageName = this.getPackage(compoInst);
        try {
            componentIndexer = this.loadIndexer("com.stratelia.webactiv." + packageName + '.' + className + "Indexer");
            if (componentIndexer == null) {
                componentIndexer = this.loadIndexer("com.silverpeas." + packageName + '.' + className + "Indexer");
            }
            if (componentIndexer == null) {
                componentIndexer = this.loadIndexer("org.silverpeas." + packageName + '.' + className + "Indexer");
            }
        }
        catch (InstantiationException e) {
            SilverTrace.warn((String)"applicationIndexer", (String)"ApplicationIndexer.getIndexer()", (String)"applicationIndexer.EX_INDEXING_PERSONAL_COMPONENT_FAILED", (String)("component = " + compoName), (Throwable)e);
            componentIndexer = new ComponentIndexerAdapter();
        }
        catch (IllegalAccessException e) {
            SilverTrace.warn((String)"applicationIndexer", (String)"ApplicationIndexer.getIndexer()", (String)"applicationIndexer.EX_INDEXING_PERSONAL_COMPONENT_FAILED", (String)("component = " + compoName), (Throwable)e);
            componentIndexer = new ComponentIndexerAdapter();
        }
        if (componentIndexer == null) {
            SilverTrace.warn((String)"applicationIndexer", (String)"ApplicationIndexer.getIndexer()", (String)"applicationIndexer.EX_INDEXER_COMPONENT_NOT_FOUND", (String)("component = " + compoName + " with classes com.stratelia.webactiv." + packageName + "." + className + "Indexer and com.silverpeas." + packageName + "." + className + "Indexer"));
            return new ComponentIndexerAdapter();
        }
        return componentIndexer;
    }

    ComponentIndexerInterface loadIndexer(String className) throws InstantiationException, IllegalAccessException {
        try {
            return (ComponentIndexerInterface)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    String getClassName(ComponentInstLight compoInst) {
        String name = compoInst.getName();
        String className = this.firstLetterToUpperCase(name);
        if ("toolbox".equalsIgnoreCase(name)) {
            return "Kmelia";
        }
        if ("bookmark".equalsIgnoreCase(name)) {
            return "WebSites";
        }
        if ("pollingStation".equalsIgnoreCase(name)) {
            return "Survey";
        }
        if ("webPages".equalsIgnoreCase(name)) {
            return "WebPages";
        }
        if ("mydb".equalsIgnoreCase(name)) {
            return "MyDB";
        }
        return className;
    }

    String getPackage(ComponentInstLight compoInst) {
        String packageName = this.firstLetterToLowerCase(compoInst.getName());
        if ("toolbox".equalsIgnoreCase(packageName)) {
            return "kmelia";
        }
        if ("bookmark".equalsIgnoreCase(packageName)) {
            return "webSites";
        }
        if ("pollingStation".equalsIgnoreCase(packageName)) {
            return "survey";
        }
        if ("webPages".equalsIgnoreCase(packageName) || "resourcesManager".equalsIgnoreCase(packageName) || "mydb".equalsIgnoreCase(packageName) || "formsOnline".equalsIgnoreCase(packageName)) {
            return packageName.toLowerCase();
        }
        return packageName;
    }

    public void indexUsers() {
        this.admin.indexAllUsers();
    }

    public void indexGroups() {
        this.admin.indexAllGroups();
    }
}

