/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html;

import com.silverpeas.look.SilverpeasLook;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.JavascriptPluginInclusion;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPane;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPaneSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.board.Board;
import com.stratelia.webactiv.util.viewGenerator.html.board.BoardSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.browseBars.BrowseBar;
import com.stratelia.webactiv.util.viewGenerator.html.browseBars.BrowseBarComplete;
import com.stratelia.webactiv.util.viewGenerator.html.buttonPanes.ButtonPane;
import com.stratelia.webactiv.util.viewGenerator.html.buttonPanes.ButtonPaneWA2;
import com.stratelia.webactiv.util.viewGenerator.html.buttons.Button;
import com.stratelia.webactiv.util.viewGenerator.html.buttons.ButtonSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.calendar.Calendar;
import com.stratelia.webactiv.util.viewGenerator.html.calendar.CalendarWA1;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPane;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPaneWA;
import com.stratelia.webactiv.util.viewGenerator.html.frame.Frame;
import com.stratelia.webactiv.util.viewGenerator.html.frame.FrameSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.iconPanes.IconPane;
import com.stratelia.webactiv.util.viewGenerator.html.iconPanes.IconPaneWA;
import com.stratelia.webactiv.util.viewGenerator.html.navigationList.NavigationList;
import com.stratelia.webactiv.util.viewGenerator.html.navigationList.NavigationListSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.operationPanes.OperationPane;
import com.stratelia.webactiv.util.viewGenerator.html.operationPanes.OperationPaneSilverpeasV5Web20;
import com.stratelia.webactiv.util.viewGenerator.html.pagination.Pagination;
import com.stratelia.webactiv.util.viewGenerator.html.pagination.PaginationSP;
import com.stratelia.webactiv.util.viewGenerator.html.progressMessage.ProgressMessage;
import com.stratelia.webactiv.util.viewGenerator.html.progressMessage.ProgressMessageSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.tabs.TabbedPane;
import com.stratelia.webactiv.util.viewGenerator.html.tabs.TabbedPaneSilverpeasV5;
import com.stratelia.webactiv.util.viewGenerator.html.window.Window;
import com.stratelia.webactiv.util.viewGenerator.html.window.WindowWeb20V5;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.ecs.ElementContainer;

public class GraphicElementFactory {
    public static final String RESOURCES_KEY = "resources";
    public static final String GE_FACTORY_SESSION_ATT = "SessionGraphicElementFactory";
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.util.viewGenerator.settings.graphicElementFactorySettings", "");
    private ResourceLocator lookSettings = null;
    private ResourceLocator silverpeasLookSettings = null;
    private ResourceLocator favoriteLookSettings = null;
    private static final String defaultLook = "org.silverpeas.util.viewGenerator.settings.Initial";
    private static final ResourceLocator generalSettings = new ResourceLocator("org.silverpeas.general", I18NHelper.defaultLanguage);
    private static final String iconsPath = (URLManager.getApplicationURL() + settings.getString("IconsPath")).replaceAll("/$", "");
    private ResourceLocator multilang = null;
    private String currentLookName = null;
    private String externalStylesheet = null;
    private String componentId = null;
    private MainSessionController mainSessionController = null;
    private String spaceId = null;
    private boolean componentMainPage = false;
    public static final String defaultLookName = "Initial";
    protected static final String JQUERY_JS = "jquery-1.10.2.min.js";
    protected static final String JQUERYUI_JS = "jquery-ui-1.10.3.custom.min.js";
    protected static final String JQUERYUI_CSS = "ui-lightness/jquery-ui-1.10.3.custom.css";
    protected static final String JQUERYJSON_JS = "jquery.json-2.3.min.js";
    protected static final String JQUERY_i18N_JS = "jquery.i18n.properties-min-1.0.9.js";
    private static final String SILVERPEAS_JS = "silverpeas.js";

    public GraphicElementFactory(String look) {
        this.setLook(look);
    }

    public static String getIconsPath() {
        return iconsPath;
    }

    public static ResourceLocator getGeneralSettings() {
        return generalSettings;
    }

    public ResourceLocator getMultilang() {
        if (this.multilang == null) {
            String language = this.getLanguage();
            this.multilang = new ResourceLocator("org.silverpeas.util.viewGenerator.multilang.graphicElementFactoryBundle", language);
        }
        return this.multilang;
    }

    private String getLanguage() {
        String language = I18NHelper.defaultLanguage;
        if (this.mainSessionController != null) {
            language = this.mainSessionController.getFavoriteLanguage();
        }
        return language;
    }

    public static ResourceLocator getSettings() {
        return settings;
    }

    public ResourceLocator getLookSettings() {
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookSettings()", (String)"root.MSG_GEN_ENTER_METHOD");
        if (this.lookSettings == null) {
            ResourceLocator silverpeasSettings = this.getSilverpeasLookSettings();
            SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookSettings()", (String)"root.MSG_GEN_EXIT_METHOD", (String)"lookSettings == null");
            try {
                this.lookSettings = new ResourceLocator("org.silverpeas.util.viewGenerator.settings.lookSettings", "", silverpeasSettings);
            }
            catch (MissingResourceException e) {
                this.lookSettings = silverpeasSettings;
            }
        }
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookSettings()", (String)"root.MSG_GEN_EXIT_METHOD");
        return this.lookSettings;
    }

    public ResourceLocator getSilverpeasLookSettings() {
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getSilverpeasLookSettings()", (String)"root.MSG_GEN_ENTER_METHOD");
        if (this.silverpeasLookSettings == null) {
            this.silverpeasLookSettings = new ResourceLocator("org.silverpeas.util.viewGenerator.settings.defaultLookSettings", "");
        }
        return this.silverpeasLookSettings;
    }

    public ResourceLocator getFavoriteLookSettings() {
        return this.favoriteLookSettings;
    }

    public final void setLook(String look) {
        String selectedLook;
        block2: {
            this.lookSettings = this.getLookSettings();
            try {
                selectedLook = this.lookSettings.getString(look, null);
            }
            catch (MissingResourceException e) {
                SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.setLook()", (String)"root.MSG_GEN_PARAM_VALUE", (String)" customer lookSettings is undefined !");
                this.lookSettings = this.getSilverpeasLookSettings();
                selectedLook = this.silverpeasLookSettings.getString(look, null);
                if (selectedLook != null) break block2;
                selectedLook = defaultLook;
            }
        }
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.setLook()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" look = " + look + " | corresponding settings = " + selectedLook));
        this.favoriteLookSettings = new ResourceLocator(selectedLook, "");
        this.currentLookName = look;
    }

    public String getCurrentLookName() {
        return this.currentLookName;
    }

    public void setExternalStylesheet(String externalStylesheet) {
        this.externalStylesheet = externalStylesheet;
    }

    public String getExternalStylesheet() {
        return this.externalStylesheet;
    }

    public boolean hasExternalStylesheet() {
        return this.externalStylesheet != null;
    }

    public String getLookFrame() {
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookFrame()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" FrameJSP = " + this.getFavoriteLookSettings().getString("FrameJSP")));
        return this.getFavoriteLookSettings().getString("FrameJSP");
    }

    public String getLookStyleSheet() {
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookStyleSheet()", (String)"root.MSG_GEN_ENTER_METHOD");
        String standardStyle = "/util/styleSheets/globalSP_SilverpeasV5.css";
        String standardStyleForIE = "/util/styleSheets/globalSP_SilverpeasV5-IE.css";
        String contextPath = GraphicElementFactory.getGeneralSettings().getString("ApplicationURL");
        String charset = GraphicElementFactory.getGeneralSettings().getString("charset", "UTF-8");
        StringBuilder code = new StringBuilder();
        code.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        code.append(charset);
        code.append("\"/>\n");
        String specificJS = null;
        if (this.externalStylesheet == null) {
            ComponentInstLight component;
            code.append("<link type=\"text/css\" href=\"").append(contextPath).append("/util/styleSheets/jquery/").append(JQUERYUI_CSS).append("\" rel=\"stylesheet\"/>\n");
            StringBuilder defaultComponentCSS = null;
            StringBuilder specificComponentCSS = null;
            if (StringUtil.isDefined((String)this.componentId) && this.mainSessionController != null && (component = this.mainSessionController.getOrganisationController().getComponentInstLight(this.componentId)) != null) {
                String componentName = component.getName();
                String genericComponentName = this.getGenericComponentName(componentName);
                defaultComponentCSS = new StringBuilder(50);
                defaultComponentCSS.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(contextPath).append("/").append(genericComponentName).append("/jsp/styleSheets/").append(genericComponentName).append(".css").append("\"/>\n");
                String specificStyle = this.getFavoriteLookSettings().getString("StyleSheet." + componentName);
                if (StringUtil.isDefined((String)specificStyle)) {
                    specificComponentCSS = new StringBuilder(50);
                    specificComponentCSS.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                    specificComponentCSS.append(specificStyle).append("\"/>\n");
                }
                specificJS = this.getFavoriteLookSettings().getString("JavaScript." + componentName);
            }
            code.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(contextPath);
            code.append(standardStyle).append("\"/>\n");
            code.append("<!--[if IE]>\n");
            code.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(contextPath).append(standardStyleForIE).append("\"/>\n");
            code.append("<![endif]-->\n");
            if (defaultComponentCSS != null) {
                code.append((CharSequence)defaultComponentCSS);
            }
            this.appendSpecificCSS(code);
            if (specificComponentCSS != null) {
                code.append((CharSequence)specificComponentCSS);
            }
        } else {
            code.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(this.externalStylesheet).append("\"/>\n");
        }
        code.append("<script type=\"text/javascript\">var webContext='").append(contextPath).append("';").append("</script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/").append(SILVERPEAS_JS).append("\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/jquery/").append(JQUERY_JS).append("\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/jquery/").append(JQUERYJSON_JS).append("\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/jquery/").append(JQUERYUI_JS).append("\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/jquery/").append(JQUERY_i18N_JS).append("\"></script>\n");
        if (StringUtil.isDefined(specificJS)) {
            code.append("<script type=\"text/javascript\" src=\"").append(specificJS).append("\"></script>\n");
        }
        if (this.isComponentMainPage()) {
            code.append("<script type=\"text/javascript\" src=\"").append(contextPath).append("/util/javaScript/jquery/jquery.cookie.js\"></script>\n");
        }
        if (this.getFavoriteLookSettings() != null && this.getFavoriteLookSettings().getString("OperationPane").toLowerCase().endsWith("web20")) {
            code.append(this.getYahooElements());
            code.append(JavascriptPluginInclusion.includeResponsibles(new ElementContainer(), this.getLanguage()).toString()).append("\n");
        }
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getLookStyleSheet()", (String)"root.MSG_GEN_EXIT_METHOD");
        return code.toString();
    }

    private void appendSpecificCSS(StringBuilder code) {
        SpaceInstLight curSpace;
        if (StringUtil.isDefined((String)this.spaceId) && (curSpace = this.mainSessionController.getOrganisationController().getSpaceInstLightById(this.spaceId)) != null) {
            String spaceLookStyle = curSpace.getLook();
            this.getSpaceLook(code, curSpace, spaceLookStyle);
            String css = SilverpeasLook.getSilverpeasLook().getCSSOfSpace(this.spaceId);
            if (StringUtil.isDefined((String)css)) {
                code.append("<link id=\"spaceCSSid\" rel=\"stylesheet\" type=\"text/css\" href=\"").append(css).append("\"/>\n");
            }
            return;
        }
        this.appendDefaultLookCSS(code);
    }

    private void getSpaceLook(StringBuilder code, SpaceInstLight curSpace, String spaceLookStyle) {
        if (StringUtil.isDefined((String)spaceLookStyle)) {
            this.setLook(spaceLookStyle);
            String lookStyle = this.getFavoriteLookSettings().getString("StyleSheet");
            if (StringUtil.isDefined((String)lookStyle)) {
                code.append("<link id=\"specificCSSid\" rel=\"stylesheet\" type=\"text/css\" href=\"");
                code.append(lookStyle).append("\"/>\n");
            }
        } else if (!curSpace.isRoot()) {
            String fatherSpaceId = curSpace.getFatherId();
            SpaceInstLight fatherSpace = this.mainSessionController.getOrganisationController().getSpaceInstLightById(fatherSpaceId);
            spaceLookStyle = fatherSpace.getLook();
            this.getSpaceLook(code, fatherSpace, spaceLookStyle);
        } else {
            this.appendDefaultLookCSS(code);
        }
    }

    private void appendDefaultLookCSS(StringBuilder code) {
        String userLookStyle = this.getDefaultLookName();
        this.setLook(userLookStyle);
        String lookStyle = this.getFavoriteLookSettings().getString("StyleSheet");
        if (StringUtil.isDefined((String)lookStyle)) {
            code.append("<link id=\"specificCSSid\" rel=\"stylesheet\" type=\"text/css\" href=\"");
            code.append(lookStyle).append("\"/>\n");
        }
    }

    private String getGenericComponentName(String componentName) {
        if ("toolbox".equalsIgnoreCase(componentName) || "kmax".equalsIgnoreCase(componentName)) {
            return "kmelia";
        }
        if ("pollingstation".equalsIgnoreCase(componentName)) {
            return "survey";
        }
        return componentName;
    }

    private String getYahooElements() {
        String contextPath = GraphicElementFactory.getGeneralSettings().getString("ApplicationURL");
        StringBuilder code = new StringBuilder();
        code.append("<!-- CSS for Menu -->\n");
        code.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        code.append(GraphicElementFactory.getSettings().getString("YUIMenuCss", contextPath + "/util/yui/menu/assets/menu.css"));
        code.append("\"/>\n");
        code.append("<!-- Page-specific styles -->\n");
        code.append("<style type=\"text/css\">\n");
        code.append("    div.yuimenu {\n");
        code.append("    position:dynamic;\n");
        code.append("    visibility:hidden;\n");
        code.append("    }\n");
        code.append("</style>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath);
        code.append("/util/yui/yahoo-dom-event/yahoo-dom-event.js\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath);
        code.append("/util/yui/container/container_core-min.js\"></script>\n");
        code.append("<script type=\"text/javascript\" src=\"").append(contextPath);
        code.append("/util/yui/menu/menu-min.js\"></script>\n");
        return code.toString();
    }

    public String getIcon(String iconKey) {
        SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getIcon()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("iconKey = " + iconKey));
        return this.getFavoriteLookSettings().getString(iconKey, null);
    }

    public List<String> getAvailableLooks() {
        ResourceLocator theLookSettings = this.getLookSettings();
        Enumeration keys = theLookSettings.getKeys();
        ArrayList<String> availableLooks = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            availableLooks.add((String)keys.nextElement());
        }
        return availableLooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Button getFormButton(String label, String action, boolean disabled) {
        Button button = null;
        String buttonClassName = this.getFavoriteLookSettings().getString("Button");
        try {
            button = (Button)Class.forName(buttonClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getFormButton()", (String)"viewgenerator.EX_CANT_GET_BUTTON", (String)"", (Throwable)e);
            button = new ButtonSilverpeasV5();
        }
        finally {
            if (button != null) {
                button.init(label, action, disabled);
            }
        }
        return button;
    }

    public Frame getFrame() {
        Frame frame;
        String frameClassName = this.getFavoriteLookSettings().getString("Frame");
        try {
            frame = (Frame)Class.forName(frameClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getFrame()", (String)"viewgenerator.EX_CANT_GET_FRAME", (String)"", (Throwable)e);
            frame = new FrameSilverpeasV5();
        }
        return frame;
    }

    public Board getBoard() {
        Board board;
        String boardClassName = this.getFavoriteLookSettings().getString("Board");
        try {
            board = (Board)Class.forName(boardClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getBoard()", (String)"viewgenerator.EX_CANT_GET_FRAME", (String)"", (Throwable)e);
            board = new BoardSilverpeasV5();
        }
        return board;
    }

    public NavigationList getNavigationList() {
        NavigationList navigationList;
        String navigationListClassName = this.getFavoriteLookSettings().getString("NavigationList");
        try {
            navigationList = (NavigationList)Class.forName(navigationListClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getNavigationList()", (String)"viewgenerator.EX_CANT_GET_NAVIGATIONLIST", (String)"", (Throwable)e);
            navigationList = new NavigationListSilverpeasV5();
        }
        return navigationList;
    }

    public Button getFormButton(String label, String action, boolean disabled, String imagePath) {
        return this.getFormButton(label, action, disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabbedPane getTabbedPane() {
        String tabbedPaneClassName = this.getFavoriteLookSettings().getString("TabbedPane");
        TabbedPane tabbedPane = null;
        try {
            tabbedPane = (TabbedPane)Class.forName(tabbedPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getTabbedPane()", (String)"viewgenerator.EX_CANT_GET_TABBED_PANE", (String)"", (Throwable)e);
            tabbedPane = new TabbedPaneSilverpeasV5();
        }
        finally {
            if (tabbedPane != null) {
                tabbedPane.init(1);
            }
        }
        return tabbedPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabbedPane getTabbedPane(int nbLines) {
        String tabbedPaneClassName = this.getFavoriteLookSettings().getString("TabbedPane");
        TabbedPane tabbedPane = null;
        try {
            tabbedPane = (TabbedPane)Class.forName(tabbedPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getTabbedPane()", (String)"viewgenerator.EX_CANT_GET_TABBED_PANE", (String)(" nbLines = " + nbLines), (Throwable)e);
            tabbedPane = new TabbedPaneSilverpeasV5();
        }
        finally {
            if (tabbedPane != null) {
                tabbedPane.init(nbLines);
            }
        }
        return tabbedPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayPane getArrayPane(String name, PageContext pageContext) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString("ArrayPane");
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getArrayPane()", (String)"viewgenerator.EX_CANT_GET_ARRAY_PANE", (String)(" name = " + name), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, pageContext);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayPane getArrayPane(String name, ServletRequest request, HttpSession session) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString("ArrayPane");
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getArrayPane()", (String)"viewgenerator.EX_CANT_GET_ARRAY_PANE", (String)(" name = " + name), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, request, session);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayPane getArrayPane(String name, String url, ServletRequest request, HttpSession session) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString("ArrayPane");
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getArrayPane()", (String)"viewgenerator.EX_CANT_GET_ARRAY_PANE", (String)(" name = " + name), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, url, request, session);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getWindow() {
        String windowClassName = this.getFavoriteLookSettings().getString("Window");
        Window window = null;
        try {
            window = (Window)Class.forName(windowClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getWindow()", (String)"viewgenerator.EX_CANT_GET_WINDOW", (String)"", (Throwable)e);
            window = new WindowWeb20V5();
        }
        finally {
            if (window != null) {
                window.init(this);
            }
        }
        return window;
    }

    public ButtonPane getButtonPane() {
        String buttonPaneClassName = this.getFavoriteLookSettings().getString("ButtonPane");
        try {
            return (ButtonPane)Class.forName(buttonPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getButtonPane()", (String)"viewgenerator.EX_CANT_GET_BUTTON_PANE", (String)"", (Throwable)e);
            return new ButtonPaneWA2();
        }
    }

    public IconPane getIconPane() {
        String iconPaneClassName = this.getFavoriteLookSettings().getString("IconPane");
        try {
            return (IconPane)Class.forName(iconPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getIconPane()", (String)"viewgenerator.EX_CANT_GET_ICON_PANE", (String)"", (Throwable)e);
            return new IconPaneWA();
        }
    }

    public FormPane getFormPane(String name, String actionURL, PageContext pageContext) {
        return new FormPaneWA(name, actionURL, pageContext);
    }

    public OperationPane getOperationPane() {
        OperationPane operationPane;
        String operationPaneClassName = this.getFavoriteLookSettings().getString("OperationPane");
        try {
            operationPane = (OperationPane)Class.forName(operationPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getOperationPane()", (String)"viewgenerator.EX_CANT_GET_OPERATION_PANE", (String)"", (Throwable)e);
            operationPane = new OperationPaneSilverpeasV5Web20();
        }
        operationPane.setMultilang(this.getMultilang());
        return operationPane;
    }

    public BrowseBar getBrowseBar() {
        String browseBarClassName = this.getFavoriteLookSettings().getString("BrowseBar");
        try {
            BrowseBar browseBar = (BrowseBar)Class.forName(browseBarClassName).newInstance();
            browseBar.setComponentId(this.componentId);
            browseBar.setMainSessionController(this.mainSessionController);
            return browseBar;
        }
        catch (Exception e) {
            SilverTrace.error((String)"viewgenerator", (String)"GraphicElementFactory.getBrowseBar()", (String)"viewgenerator.EX_CANT_GET_BROWSE_BAR", (String)"", (Throwable)e);
            BrowseBarComplete browseBar = new BrowseBarComplete();
            browseBar.setComponentId(this.componentId);
            browseBar.setMainSessionController(this.mainSessionController);
            return browseBar;
        }
    }

    public Calendar getCalendar(String context, String language, Date date) {
        return new CalendarWA1(context, language, date);
    }

    public Pagination getPagination(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        Pagination pagination = this.getPagination();
        pagination.init(nbItems, nbItemsPerPage, firstItemIndex);
        return pagination;
    }

    public Pagination getPagination() {
        Pagination pagination;
        String paginationClassName = this.getFavoriteLookSettings().getString("Pagination");
        if (paginationClassName == null) {
            paginationClassName = "com.stratelia.webactiv.util.viewGenerator.html.pagination.PaginationSP";
        }
        try {
            pagination = (Pagination)Class.forName(paginationClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getPagination()", (String)"viewgenerator.EX_CANT_GET_PAGINATION", (String)"", (Throwable)e);
            pagination = new PaginationSP();
        }
        pagination.setMultilang(this.getMultilang());
        return pagination;
    }

    public ProgressMessage getProgressMessage(List<String> messages) {
        ProgressMessage progress;
        String progressClassName = this.getFavoriteLookSettings().getString("Progress");
        if (progressClassName == null) {
            progressClassName = "com.stratelia.webactiv.util.viewGenerator.html.progressMessage.ProgressMessageSilverpeasV5";
        }
        try {
            progress = (ProgressMessage)Class.forName(progressClassName).newInstance();
        }
        catch (Exception e) {
            SilverTrace.info((String)"viewgenerator", (String)"GraphicElementFactory.getProgressMessage()", (String)"viewgenerator.EX_CANT_GET_PROGRESSMESSAGE", (String)"", (Throwable)e);
            progress = new ProgressMessageSilverpeasV5();
        }
        progress.init(messages);
        progress.setMultilang(this.getMultilang());
        return progress;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public MainSessionController getMainSessionController() {
        return this.mainSessionController;
    }

    public void setHttpRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        this.mainSessionController = (MainSessionController)session.getAttribute("SilverSessionController");
        this.componentMainPage = request.getRequestURI().endsWith("/Main") && !request.getRequestURI().endsWith("/jsp/Main");
    }

    public boolean isComponentMainPage() {
        return this.componentMainPage;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getDefaultLookName() {
        String userLookStyle;
        try {
            userLookStyle = this.mainSessionController.getPersonalization().getLook();
        }
        catch (Exception t) {
            SilverTrace.error((String)"viewgenerator", (String)"GEF", (String)"problem to retrieve user look", (Throwable)t);
            userLookStyle = defaultLookName;
        }
        return userLookStyle;
    }
}

