/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html;

import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.webactiv.util.viewGenerator.html.JavascriptPluginInclusion;
import com.stratelia.webactiv.util.viewGenerator.html.SupportedJavaScriptPlugins;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.ecs.ElementContainer;

public class IncludeJSPluginTag
extends SimpleTagSupport {
    private static final String MAIN_SESSION_CONTROLLER = "SilverSessionController";
    private String plugin;

    public String getName() {
        return this.plugin;
    }

    public void setName(String plugin) {
        this.plugin = plugin;
    }

    public void doTag() throws JspException, IOException {
        ElementContainer xhtml = new ElementContainer();
        try {
            SupportedJavaScriptPlugins jsPlugin = SupportedJavaScriptPlugins.valueOf(this.getName());
            switch (jsPlugin) {
                case qtip: {
                    JavascriptPluginInclusion.includeQTip(xhtml);
                    break;
                }
                case datepicker: {
                    JavascriptPluginInclusion.includeDatePicker(xhtml, this.getLanguage());
                    break;
                }
                case pagination: {
                    JavascriptPluginInclusion.includePagination(xhtml);
                    break;
                }
                case breadcrumb: {
                    JavascriptPluginInclusion.includeBreadCrumb(xhtml);
                    break;
                }
                case userZoom: {
                    JavascriptPluginInclusion.includeUserZoom(xhtml);
                    break;
                }
                case invitme: {
                    JavascriptPluginInclusion.includeInvitMe(xhtml);
                    break;
                }
                case messageme: {
                    JavascriptPluginInclusion.includeMessageMe(xhtml);
                    break;
                }
                case wysiwyg: {
                    JavascriptPluginInclusion.includeWysiwygEditor(xhtml);
                    break;
                }
                case responsibles: {
                    JavascriptPluginInclusion.includeResponsibles(xhtml, this.getLanguage());
                    break;
                }
                case popup: {
                    JavascriptPluginInclusion.includePopup(xhtml);
                    break;
                }
                case calendar: {
                    JavascriptPluginInclusion.includeCalendar(xhtml);
                    break;
                }
                case iframeajaxtransport: {
                    JavascriptPluginInclusion.includeIFrameAjaxTransport(xhtml);
                    break;
                }
                case preview: {
                    JavascriptPluginInclusion.includePreview(xhtml);
                    break;
                }
                case notifier: {
                    JavascriptPluginInclusion.includeNotifier(xhtml);
                    break;
                }
                case password: {
                    JavascriptPluginInclusion.includePassword(xhtml);
                    break;
                }
                case jquery: {
                    JavascriptPluginInclusion.includeJQuery(xhtml);
                    break;
                }
                case tags: {
                    JavascriptPluginInclusion.includeTags(xhtml);
                    break;
                }
                case pdc: {
                    JavascriptPluginInclusion.includePdc(xhtml);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        xhtml.output((Writer)this.getJspContext().getOut());
    }

    protected String getLanguage() {
        String language = I18NHelper.defaultLanguage;
        MainSessionController controller = (MainSessionController)this.getSessionAttribute(MAIN_SESSION_CONTROLLER);
        if (controller != null) {
            language = controller.getFavoriteLanguage();
        }
        return language;
    }

    protected <T> T getRequestAttribute(String name) {
        return (T)this.getJspContext().getAttribute(name, 2);
    }

    protected <T> T getSessionAttribute(String name) {
        return (T)this.getJspContext().getAttribute(name, 3);
    }
}

