/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html;

import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.i18n.I18NLanguage;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Label;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;

public class LanguageSelectorTag
extends SimpleTagSupport {
    private String currentLangCode = I18NHelper.defaultLanguage;
    private String elementId;
    private String elementName;
    private boolean includeLabel;

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setIncludeLabel(boolean includeLabel) {
        this.includeLabel = includeLabel;
    }

    public String getLangCode() {
        return this.currentLangCode;
    }

    public void doTag() throws JspException, IOException {
        ElementContainer xhtml = new ElementContainer();
        if (I18NHelper.isI18N) {
            Select langSelector = new Select();
            langSelector.setID(this.elementId);
            langSelector.setName(this.elementName);
            ArrayList<Option> options = new ArrayList<Option>(I18NHelper.getNumberOfLanguages());
            for (I18NLanguage language : I18NHelper.getAllLanguages((String)this.getLangCode())) {
                Option option = new Option(language.getLabel(), language.getCode());
                option.addElement(language.getLabel());
                if (this.getLangCode().equalsIgnoreCase(language.getCode())) {
                    option.setSelected(true);
                }
                options.add(option);
            }
            langSelector.addElement(options.toArray(new Option[options.size()]));
            if (this.includeLabel) {
                Label label = new Label(this.elementId);
                label.addElement(GeneralPropertiesManager.getGeneralMultilang((String)this.getLangCode()).getString("GML.language"));
                xhtml.addElement((Element)label);
            }
            xhtml.addElement((Element)langSelector);
        } else {
            Input hidden = new Input();
            hidden.setID(this.elementId);
            hidden.setName(this.elementName);
            hidden.setType("hidden");
            xhtml.addElement((Element)hidden);
        }
        xhtml.output((Writer)this.getJspContext().getOut());
    }

    public void setLangCode(String currentLang) {
        this.currentLangCode = I18NHelper.checkLanguage((String)currentLang);
    }
}

