/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayColumn;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPane;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPaneStatusBean;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class AbstractArrayPane
implements ArrayPane {
    private List<ArrayColumn> columns;
    private List<ArrayLine> lines;
    private String title = null;
    private String summary = null;
    private boolean xhtml = false;
    private String alignement = null;
    private String name;
    private ArrayPaneStatusBean state = null;
    private ServletRequest request = null;
    private HttpSession session = null;
    private int m_SortMode = 0;
    private int m_CellsSpacing = 2;
    private int m_CellsPadding = 2;
    private int m_CellsBorderWidth = 0;
    private String m_RoutingAddress = null;
    private String paginationJavaScriptCallback = null;
    private boolean exportData = false;
    private String exportDataURL = null;
    protected static final String EXPORT_URL_SERVLET_MAPPING = "/Export/ArrayPane";
    private boolean sortableLines = false;

    @Override
    public void init(String name, PageContext pageContext) {
        this.init(name, pageContext.getRequest(), pageContext.getSession());
    }

    @Override
    public void init(String name, ServletRequest request, HttpSession session) {
        this.init(name, null, request, session);
    }

    @Override
    public void init(String name, String url, ServletRequest request, HttpSession session) {
        String target;
        this.columns = new ArrayList<ArrayColumn>();
        this.lines = new ArrayList<ArrayLine>();
        this.name = name;
        this.setRoutingAddress(url);
        this.session = session;
        this.request = request;
        this.state = (ArrayPaneStatusBean)session.getAttribute(this.getName());
        if (this.state == null) {
            this.state = new ArrayPaneStatusBean();
            session.setAttribute(this.getName(), (Object)this.state);
        }
        if ((target = request.getParameter("ArrayPaneTarget")) != null && target.equals(name)) {
            String action = request.getParameter("ArrayPaneAction");
            SilverTrace.info((String)"viewgenerator", (String)"AbstractArrayPane.init()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" ACTION_PARAMETER_NAME = '" + action + "'"));
            if ("Sort".equals(action)) {
                String newState = request.getParameter("ArrayPaneColumn");
                if (newState != null) {
                    int ns = Integer.parseInt(newState);
                    if (ns == this.state.getSortColumn() || ns + this.state.getSortColumn() == 0) {
                        this.state.setSortColumn(-this.state.getSortColumn());
                    } else {
                        this.state.setSortColumn(ns);
                    }
                }
            } else if ("ChangePage".equals(action)) {
                String index = request.getParameter("ArrayPaneIndex");
                this.state.setFirstVisibleLine(Integer.parseInt(index));
            }
        }
        if (this.state.getSortColumn() >= 1) {
            this.setColumnToSort(this.state.getSortColumn());
        }
    }

    public ArrayPaneStatusBean getState() {
        return this.state;
    }

    @Override
    public ArrayColumn addArrayColumn(String title) {
        ArrayColumn col = new ArrayColumn(title, this.columns.size() + 1, this);
        this.columns.add(col);
        col.setRoutingAddress(this.m_RoutingAddress);
        return col;
    }

    @Override
    public ArrayLine addArrayLine() {
        ArrayLine line = new ArrayLine(this);
        this.lines.add(line);
        return line;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setVisibleLineNumber(int maximum) {
        this.state.setMaximumVisibleLine(maximum);
    }

    @Override
    public void setColumnToSort(int columnNumber) {
        SilverTrace.info((String)"viewgenerator", (String)"AbstractArrayPane.setColumnToSort()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" columNumber = '" + columnNumber + "'"));
        this.state.setSortColumn(columnNumber);
    }

    @Override
    public void setColumnBehaviour(int columnNumber, int mode) {
        if (this.columns == null || columnNumber <= 0 || columnNumber > this.columns.size()) {
            return;
        }
        ArrayColumn col = this.columns.get(columnNumber - 1);
        col.setSortable(mode == 0);
    }

    @Override
    public int getColumnToSort() {
        if (this.state != null) {
            return this.state.getSortColumn();
        }
        return 0;
    }

    @Override
    public String print() {
        return null;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public ServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRoutingAddress(String address) {
        this.m_RoutingAddress = address;
    }

    @Override
    public void setSortable(boolean sortable) {
        if (sortable) {
            this.setSortMode(0);
        } else {
            this.setSortMode(1);
        }
    }

    @Override
    public boolean getSortable() {
        return this.getSortMode() == 0;
    }

    @Override
    public void setSortMode(int mode) {
        this.m_SortMode = mode;
    }

    @Override
    public int getSortMode() {
        return this.m_SortMode;
    }

    @Override
    public void setCellsConfiguration(int spacing, int padding, int borderWidth) {
        if (spacing >= 0) {
            this.m_CellsSpacing = spacing;
        }
        if (padding >= 0) {
            this.m_CellsPadding = padding;
        }
        if (borderWidth >= 0) {
            this.m_CellsBorderWidth = borderWidth;
        }
    }

    public int getCellSpacing() {
        return this.m_CellsSpacing;
    }

    public int getCellPadding() {
        return this.m_CellsPadding;
    }

    public int getCellBorderWidth() {
        return this.m_CellsBorderWidth;
    }

    @Override
    public void setPaginationJavaScriptCallback(String callback) {
        this.paginationJavaScriptCallback = callback;
    }

    public String getPaginationJavaScriptCallback() {
        return this.paginationJavaScriptCallback;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setXHTML(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public boolean isXHTML() {
        return this.xhtml;
    }

    @Override
    public boolean getExportData() {
        return this.exportData;
    }

    @Override
    public void setExportData(boolean exportData) {
        this.exportData = exportData;
    }

    @Override
    public String getExportDataURL() {
        return this.exportDataURL;
    }

    @Override
    public void setExportDataURL(String exportDataURL) {
        this.exportDataURL = exportDataURL;
    }

    protected String getExportUrl() {
        if (StringUtil.isDefined((String)this.getExportDataURL())) {
            return this.getExportDataURL();
        }
        StringBuilder exportUrl = new StringBuilder();
        String contextPath = URLManager.getApplicationURL();
        exportUrl.append(contextPath).append(EXPORT_URL_SERVLET_MAPPING);
        exportUrl.append("?type=ArrayPane&name=");
        exportUrl.append("Silverpeas_arraypane");
        return exportUrl.toString();
    }

    @Override
    public void setSortableLines(boolean sortableLines) {
        this.sortableLines = sortableLines;
    }

    public boolean isSortableLines() {
        return this.sortableLines;
    }

    public String getUrl() {
        if (this.m_RoutingAddress == null) {
            String address = ((HttpServletRequest)this.getRequest()).getRequestURI();
            if ((address = address.substring(address.lastIndexOf(47) + 1, address.length())).lastIndexOf(63) >= 0) {
                address = address.substring(0, address.lastIndexOf(63));
            }
            return address;
        }
        return this.m_RoutingAddress;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    public String getAlignement() {
        return this.alignement;
    }

    public void setAlignement(String alignement) {
        this.alignement = alignement;
    }

    public List<ArrayLine> getLines() {
        return this.lines;
    }

    public List<ArrayColumn> getColumns() {
        return this.columns;
    }

    protected String printSortJavascriptFunction() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("<script type=\"text/javascript\">");
        sb.append("var fixArrayPaneWidthHelper = function(e, ui) {");
        sb.append("ui.children().each(function() {");
        sb.append("$(this).width($(this).width());");
        sb.append("});");
        sb.append("return ui;");
        sb.append("};");
        sb.append("$(\"#").append(this.getName()).append(" tbody\").sortable({");
        sb.append("placeholder: \"arraypane-sortable-placeholder\",");
        sb.append("cursor: \"move\",");
        sb.append("forcePlaceholderSize: true,");
        sb.append("helper: fixArrayPaneWidthHelper");
        sb.append("}).disableSelection();");
        sb.append("</script>");
        return sb.toString();
    }

    public static String getVersion() {
        return "Deprecated";
    }
}

