/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.stratelia.webactiv.util.viewGenerator.html.SimpleGraphicElement;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayEmptyCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;

public class ArrayCellLink
extends ArrayCell
implements SimpleGraphicElement,
Comparable {
    private String text = null;
    private String alignement = null;
    private String valignement = null;
    private String color = null;
    private String link = null;
    private String info = null;
    private String target = null;

    public ArrayCellLink(String text, String link2, ArrayLine line) {
        super(line);
        this.text = text;
        this.link = link2;
    }

    public ArrayCellLink(String text, String link2, String info, ArrayLine line) {
        super(line);
        this.text = text;
        this.link = link2;
        this.info = info;
    }

    public String getText() {
        return this.text;
    }

    public String getAlignement() {
        return this.alignement;
    }

    public void setAlignement(String alignement) {
        this.alignement = alignement;
    }

    public String getValignement() {
        return this.valignement;
    }

    public void setValignement(String valignement) {
        this.valignement = valignement;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getLink() {
        return this.link;
    }

    public String getInfo() {
        return this.info;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int compareTo(Object other) {
        if (other instanceof ArrayEmptyCell) {
            return 1;
        }
        if (!(other instanceof ArrayCellLink)) {
            return 0;
        }
        ArrayCellLink tmp = (ArrayCellLink)other;
        return this.getText().compareToIgnoreCase(tmp.getText());
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("<td");
        if (this.getAlignement() != null && (this.getAlignement().equalsIgnoreCase("center") || this.getAlignement().equalsIgnoreCase("right"))) {
            result.append(" align=\"").append(this.getAlignement()).append("\"");
        }
        if (this.getValignement() != null && (this.getValignement().equalsIgnoreCase("bottom") || this.getValignement().equalsIgnoreCase("top") || this.getValignement().equalsIgnoreCase("baseline"))) {
            result.append(" valign=\"").append(this.getValignement()).append("\"");
        }
        result.append(" class=\"").append(this.getStyleSheet()).append("\">");
        if (this.getColor() != null) {
            result.append(" <font color=\"").append(this.getColor()).append("\">");
        }
        result.append("<a class=\"").append(this.getStyleSheet()).append("\" ");
        result.append("href=\"").append(this.getLink()).append("\"");
        if (this.getTarget() != null) {
            result.append(" target=\"").append(this.getTarget()).append("\"");
        }
        result.append(">");
        result.append(this.getText());
        result.append("</a>");
        if (this.getColor() != null) {
            result.append("</font>");
        }
        result.append("</td>\n");
        return result.toString();
    }
}

