/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.stratelia.webactiv.util.viewGenerator.html.SimpleGraphicElement;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ArrayCellSelect
extends ArrayCell
implements SimpleGraphicElement {
    private String name;
    private ArrayList<String> values = new ArrayList();
    private String size = null;
    private ArrayList<String> labels = new ArrayList();
    private ArrayList<Integer> selected = new ArrayList();
    private String cellAlign = null;
    private String color = null;
    private String bgcolor = null;
    private String textAlign = null;
    private boolean readOnly = false;
    private boolean multiselect = false;
    private String action = null;
    private StringBuffer syntax = new StringBuffer();

    public ArrayCellSelect(String strName, String[] astrLabels, String[] astrValues, ArrayLine line) {
        super(line);
        this.name = strName;
        this.values.addAll(Arrays.asList(astrValues));
        this.labels.addAll(Arrays.asList(astrLabels));
    }

    public String getCellAlign() {
        return this.cellAlign;
    }

    public void setCellAlign(String cellAlign) {
        this.cellAlign = cellAlign;
    }

    public String getName() {
        return this.name;
    }

    public String[] getSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (Integer aSelected : this.selected) {
            selectedValues.add(this.values.get(aSelected));
        }
        return selectedValues.toArray(new String[selectedValues.size()]);
    }

    public void setSelectedValues(String[] astrSelectedValues) {
        this.selected.clear();
        for (String astrSelectedValue : astrSelectedValues) {
            int index = this.values.indexOf(astrSelectedValue);
            if (index == -1) continue;
            this.selected.add(index);
        }
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String strSize) {
        this.size = strSize;
    }

    public boolean getMultiselect() {
        return this.multiselect;
    }

    public void setMultiselect(boolean fMultiselect) {
        this.multiselect = fMultiselect;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String strColor) {
        this.color = strColor;
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(String strBgcolor) {
        this.bgcolor = strBgcolor;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String strTextAlign) {
        this.textAlign = strTextAlign;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String strAction) {
        this.action = strAction;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.readOnly = fReadOnly;
    }

    public String getSyntax() {
        Iterator<Integer> iterSelected = this.selected.iterator();
        int iSelected = -1;
        this.syntax.setLength(0);
        this.syntax.append(" <select name=\"");
        if (this.getName() == null) {
            this.syntax.append("selectfield\"");
        } else {
            this.syntax.append(this.getName());
            this.syntax.append("\"");
        }
        if (this.getSize() != null) {
            this.syntax.append(" size=\"");
            this.syntax.append(this.getSize());
            this.syntax.append("\"");
        }
        this.syntax.append(" style=\"");
        if (this.getReadOnly()) {
            this.syntax.append("border: 1 solid rgb(255,255,255); ");
        }
        if (this.getTextAlign() != null) {
            this.syntax.append("text-align:");
            this.syntax.append(this.getTextAlign());
            this.syntax.append(";");
        }
        if (this.getColor() != null) {
            this.syntax.append(" color:");
            this.syntax.append(this.getColor());
            this.syntax.append(";");
        }
        if (this.getBgcolor() != null) {
            this.syntax.append(" background-color:");
            this.syntax.append(this.getBgcolor());
            this.syntax.append(";");
        }
        this.syntax.append("\"");
        if (this.getAction() != null) {
            this.syntax.append(" ");
            this.syntax.append(this.getAction());
        }
        if (this.getReadOnly()) {
            this.syntax.append(" readOnly");
        }
        if (this.getMultiselect()) {
            this.syntax.append(" multiple");
        }
        this.syntax.append(">");
        if (iterSelected.hasNext()) {
            iSelected = iterSelected.next();
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            this.syntax.append("\n<option value=\"");
            this.syntax.append(this.values.get(i));
            this.syntax.append("\"");
            if (i == iSelected) {
                this.syntax.append(" selected");
                if (iterSelected.hasNext()) {
                    iSelected = iterSelected.next();
                }
            }
            this.syntax.append(">");
            this.syntax.append(this.labels.get(i));
            this.syntax.append("</option>");
        }
        this.syntax.append("\n</select>");
        return this.syntax.toString();
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder("<td ");
        if (this.getCellAlign() != null && (this.getCellAlign().equalsIgnoreCase("center") || this.getCellAlign().equalsIgnoreCase("right"))) {
            result.append(" align=\"");
            result.append(this.getCellAlign());
            result.append("\"");
        }
        result.append(" class=\"");
        result.append(this.getStyleSheet());
        result.append("\">");
        result.append(this.getSyntax());
        result.append("</td>\n");
        return result.toString();
    }
}

