/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.stratelia.webactiv.util.viewGenerator.html.SimpleGraphicElement;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayEmptyCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;

public class ArrayCellText
extends ArrayCell
implements SimpleGraphicElement,
Comparable {
    private String text;
    private String alignement = null;
    private String color = null;
    private String valignement = null;
    private boolean noWrap = false;
    private Comparable compareOn = null;

    public ArrayCellText(String text, ArrayLine line) {
        super(line);
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getAlignement() {
        return this.alignement;
    }

    public void setAlignement(String alignement) {
        this.alignement = alignement;
    }

    public boolean getNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getValignement() {
        return this.valignement;
    }

    public void setValignement(String valignement) {
        this.valignement = valignement;
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("<td ");
        if (this.getAlignement() != null && (this.getAlignement().equalsIgnoreCase("center") || this.getAlignement().equalsIgnoreCase("right"))) {
            result.append(" align=\"").append(this.getAlignement()).append("\"");
        }
        if (this.getValignement() != null && (this.getValignement().equalsIgnoreCase("bottom") || this.getValignement().equalsIgnoreCase("top") || this.getValignement().equalsIgnoreCase("baseline"))) {
            result.append(" valign=\"").append(this.getValignement()).append("\"");
        }
        if (this.getNoWrap()) {
            result.append(" nowrap=\"nowrap\"");
        }
        result.append(" class=\"").append(this.getStyleSheet()).append("\">");
        if (this.getColor() != null) {
            result.append(" <font color=\"").append(this.getColor()).append("\">");
            result.append(this.getText());
            result.append("</font>");
        } else {
            result.append(this.getText());
        }
        result.append("</td>\n");
        return result.toString();
    }

    public void setCompareOn(Comparable object) {
        this.compareOn = object;
    }

    public Comparable getCompareOn() {
        return this.compareOn;
    }

    public int compareTo(Object other) {
        if (other instanceof ArrayEmptyCell) {
            return 1;
        }
        if (!(other instanceof ArrayCellText)) {
            return 0;
        }
        ArrayCellText tmp = (ArrayCellText)other;
        if (this.getCompareOn() != null && tmp.getCompareOn() != null) {
            return this.getCompareOn().compareTo(tmp.getCompareOn());
        }
        return this.getText().compareToIgnoreCase(tmp.getText());
    }
}

