/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.viewGenerator.html.SimpleGraphicElement;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPane;
import javax.servlet.http.HttpServletRequest;

public class ArrayColumn
implements SimpleGraphicElement {
    public static final int COLUMN_BEHAVIOUR_NO_TRIGGER = 1;
    public static final int COLUMN_BEHAVIOUR_DEFAULT = 0;
    protected String title;
    protected String alignement;
    protected int columnNumber;
    protected ArrayPane pane;
    protected int m_Behaviour = 0;
    protected String width = null;
    protected String m_RoutingAddress = null;

    public ArrayColumn(String title, int columnNumber, ArrayPane pane) {
        this.title = title;
        this.columnNumber = columnNumber;
        this.pane = pane;
        this.alignement = null;
    }

    public static String getVersion() {
        String v = "$Id: ArrayColumn.java,v 1.6 2008/04/16 14:45:06 neysseri Exp $";
        return v;
    }

    public void setRoutingAddress(String address) {
        this.m_RoutingAddress = address;
    }

    public void setSortable(boolean sortable) {
        if (sortable) {
            this.setBehaviour(0);
        } else {
            this.setBehaviour(1);
        }
    }

    public boolean getSortable() {
        if (this.pane.getSortable()) {
            return this.m_Behaviour == 0;
        }
        return false;
    }

    public void setBehaviour(int behaviour) {
        switch (behaviour) {
            case 0: 
            case 1: {
                this.m_Behaviour = behaviour;
                return;
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAlignement(String alignement) {
        this.alignement = alignement;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAlignement() {
        return this.alignement;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        return this.width;
    }

    protected boolean isArrayPaneURL(String address) {
        return address != null && address.trim().toLowerCase().startsWith("arraypane:");
    }

    @Override
    public String print() {
        return this.print(false);
    }

    public String print(boolean xhtml) {
        StringBuilder result = new StringBuilder();
        boolean isAP = false;
        String JSStartString = "";
        String JSEndString = "";
        result.append("<th scope=\"col\"");
        if (this.alignement != null && (this.alignement.equalsIgnoreCase("center") || this.alignement.equalsIgnoreCase("right"))) {
            if (this.alignement.equalsIgnoreCase("center")) {
                result.append(" align=\"center\"");
            } else {
                result.append(" align=\"right\"");
            }
        }
        if (this.getWidth() != null) {
            result.append(" width=\"").append(this.getWidth()).append("\" ");
        }
        if (this.title != null) {
            result.append(" class=\"ArrayColumn\">");
            if (this.getSortable()) {
                String address = null;
                if (this.m_RoutingAddress == null) {
                    address = ((HttpServletRequest)this.pane.getRequest()).getRequestURI();
                    if ((address = address.substring(address.lastIndexOf(47) + 1, address.length())).lastIndexOf(63) >= 0) {
                        address = address.substring(0, address.lastIndexOf(63));
                    }
                } else {
                    address = this.m_RoutingAddress;
                    isAP = this.isArrayPaneURL(address);
                    if (isAP) {
                        address = "javascript:doArrayPane";
                        JSStartString = "(";
                        JSEndString = ");";
                    }
                }
                SilverTrace.info((String)"viewgenerator", (String)"ArrayColumn.print()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" adresse = '" + address + "'"));
                String sep = "&";
                if (xhtml) {
                    sep = "&amp;";
                }
                StringBuilder href = new StringBuilder();
                href.append(address).append(JSStartString);
                if (!isAP) {
                    String temp = result.toString();
                    if (temp.indexOf(63) >= 0 || href.indexOf("?") >= 0) {
                        href.append(sep);
                    } else {
                        href.append("?");
                    }
                    href.append("ArrayPaneAction").append("=Sort").append(sep);
                    href.append("ArrayPaneTarget").append('=').append(this.pane.getName());
                    href.append(sep).append("ArrayPaneColumn").append('=').append(this.getColumnNumber());
                } else {
                    href.append("'").append(this.pane.getName()).append("',").append(this.getColumnNumber());
                }
                href.append(JSEndString);
                result.append("<a class=\"ArrayColumn\" href=\"").append((CharSequence)href);
                result.append("\">").append(this.title).append("</a>");
                result.append("</th>");
            } else {
                result.append(this.title).append("</th>");
            }
        } else {
            result.append(" class=\"ArrayColumn\">&nbsp;</th>");
        }
        return result.toString();
    }
}

