/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import com.stratelia.webactiv.util.viewGenerator.html.SimpleGraphicElement;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellButton;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellCheckbox;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellIconPane;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellInputText;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellLink;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellRadio;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellSelect;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellText;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayEmptyCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayPane;
import com.stratelia.webactiv.util.viewGenerator.html.iconPanes.IconPane;
import java.util.ArrayList;
import java.util.List;

public class ArrayLine
implements SimpleGraphicElement,
Comparable {
    private List<SimpleGraphicElement> cells = new ArrayList<SimpleGraphicElement>();
    private ArrayPane pane;
    private String css = null;
    private String id = null;
    private List<ArrayLine> sublines = new ArrayList<ArrayLine>();

    public ArrayLine(ArrayPane pane) {
        this.pane = pane;
    }

    public void addSubline(ArrayLine subline) {
        this.sublines.add(subline);
    }

    public void setStyleSheet(String css) {
        this.css = css;
    }

    public String getStyleSheet() {
        return this.css;
    }

    public ArrayCellText addArrayCellText(String text) {
        ArrayCellText cell = new ArrayCellText(text, this);
        if (this.pane != null) {
            cell.setSortMode(this.pane.getSortMode());
        }
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellText addArrayCellText(int number) {
        return this.addArrayCellText(Integer.toString(number));
    }

    public ArrayCellText addArrayCellText(float number) {
        return this.addArrayCellText(Float.toString(number));
    }

    public ArrayCellLink addArrayCellLink(String text, String link2) {
        ArrayCellLink cell = new ArrayCellLink(text, link2, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellLink addArrayCellLink(String text, String link2, String target) {
        ArrayCellLink cell = new ArrayCellLink(text, link2, this);
        cell.setTarget(target);
        this.cells.add(cell);
        return cell;
    }

    public ArrayEmptyCell addArrayEmptyCell() {
        ArrayEmptyCell cell = new ArrayEmptyCell();
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellIconPane addArrayCellIconPane(IconPane iconPane) {
        ArrayCellIconPane cell = new ArrayCellIconPane(iconPane, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellInputText addArrayCellInputText(String name, String value) {
        ArrayCellInputText cell = new ArrayCellInputText(name, value, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellInputText addArrayCellInputText(ArrayCellInputText cell) {
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellSelect addArrayCellSelect(String name, String[] astrLabels, String[] astrValues) {
        ArrayCellSelect cell = new ArrayCellSelect(name, astrLabels, astrValues, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellButton addArrayCellButton(String name, String value, boolean activate) {
        ArrayCellButton cell = new ArrayCellButton(name, value, activate, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellRadio addArrayCellRadio(String name, String value, boolean checked) {
        ArrayCellRadio cell = new ArrayCellRadio(name, value, checked, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellCheckbox addArrayCellCheckbox(String name, String value, boolean checked) {
        ArrayCellCheckbox cell = new ArrayCellCheckbox(name, value, checked, this);
        this.cells.add(cell);
        return cell;
    }

    public SimpleGraphicElement getCellAt(int column) {
        try {
            return this.cells.get(column - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String printPseudoColumn() {
        return "<td><img src=\"" + GraphicElementFactory.getIconsPath() + "/1px.gif\" width=\"2\" height=\"2\" alt=\"\"/></td>";
    }

    @Override
    public String print() {
        String result = "";
        result = StringUtil.isDefined((String)this.getId()) ? result + "<tr id=\"" + this.getId() + "\">" : result + "<tr>";
        for (SimpleGraphicElement element : this.cells) {
            result = result + element.print();
        }
        result = result + "</tr>\n";
        for (ArrayLine line : this.sublines) {
            result = result + line.print();
        }
        return result;
    }

    public String printWithPseudoColumns() {
        String result = "";
        result = result + "<tr>\n";
        result = result + ArrayLine.printPseudoColumn();
        for (SimpleGraphicElement element : this.cells) {
            result = result + element.print();
            result = result + ArrayLine.printPseudoColumn();
        }
        result = result + "</tr>\n";
        for (ArrayLine line : this.sublines) {
            result = result + line.printWithPseudoColumns();
        }
        return result;
    }

    public int compareTo(Object other) {
        SimpleGraphicElement cell;
        if (this.pane.getColumnToSort() == 0) {
            SilverTrace.info((String)"viewgenerator", (String)"ArrayLine.compareTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)" columnToSort = 0 ");
            return 0;
        }
        if (!(other instanceof ArrayLine)) {
            SilverTrace.info((String)"viewgenerator", (String)"ArrayLine.compareTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" other not an ArrayLine : other=" + other.toString()));
            return 0;
        }
        ArrayLine tmp = (ArrayLine)other;
        int sort = this.pane.getColumnToSort();
        if (sort < 0) {
            sort = -sort;
        }
        if ((cell = this.getCellAt(sort)) == null) {
            return 0;
        }
        if (!(cell instanceof Comparable)) {
            SilverTrace.info((String)"viewgenerator", (String)"ArrayLine.compareTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" cell not Comparable : cell=" + cell.toString()));
            return 0;
        }
        sort = ((Comparable)((Object)cell)).compareTo(tmp.getCellAt(sort));
        if (this.pane.getColumnToSort() < 0) {
            return -sort;
        }
        return sort;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

