/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.arrayPanes;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.datapaginator.WADataPage;
import com.stratelia.webactiv.util.datapaginator.WADataPaginator;
import com.stratelia.webactiv.util.datapaginator.WAItem;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.AbstractArrayPane;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellLink;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayCellText;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayColumn;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayEmptyCell;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;
import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class ArrayPaneWithDataSource
extends AbstractArrayPane {
    WADataPaginator m_DataSource = null;
    ArrayLine m_ArrayLine = null;

    public ArrayPaneWithDataSource(String name, PageContext pageContext) {
        if (pageContext != null) {
            this.init(name, null, pageContext.getRequest(), pageContext.getSession());
        } else {
            this.init(name, null, null, null);
        }
    }

    public ArrayPaneWithDataSource(String name, ServletRequest request, HttpSession session) {
        this.init(name, null, request, session);
    }

    public void setDataSource(WADataPaginator p) {
        this.m_DataSource = p;
        this.m_ArrayLine = new ArrayLine(this);
    }

    public ArrayPaneWithDataSource(String name, String url, ServletRequest request, HttpSession session) {
        this.init(name, url, request, session);
    }

    private String printPseudoColumn() {
        return "<td>&nbsp;</td>";
    }

    @Override
    public String print() {
        if (this.m_DataSource == null) {
            return this.standardPrint();
        }
        return this.dataSourcePrint();
    }

    private String dataSourcePrint() {
        int i;
        SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_ENETR_METHOD");
        int columnsCount = 0;
        int sortCol = 0;
        WADataPage page = null;
        String pageActionString = "none";
        try {
            columnsCount = this.m_DataSource.getHeader().getFieldCount();
            sortCol = this.getColumnToSort();
            if (sortCol != 0) {
                if (sortCol < 0) {
                    sortCol = -sortCol;
                }
                SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" Toggling column sort order on column = " + sortCol));
                this.m_DataSource.getHeader().toggleFieldSortOrder(sortCol - 1);
                this.setColumnToSort(0);
            }
            if (this.getState() != null) {
                if (this.getState().getFirstVisibleLine() > 0) {
                    pageActionString = "next";
                    SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" pageActionString = " + pageActionString));
                    page = this.m_DataSource.getNextPage();
                } else if (this.getState().getFirstVisibleLine() < 0) {
                    pageActionString = "previous";
                    SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" pageActionString = " + pageActionString));
                    page = this.m_DataSource.getPreviousPage();
                } else {
                    pageActionString = "current";
                    SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" pageActionString = " + pageActionString));
                    page = this.m_DataSource.getCurrentPage();
                    if (page == null) {
                        pageActionString = "first";
                        SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" pageActionString = " + pageActionString));
                        page = this.m_DataSource.getFirstPage();
                    }
                }
                this.getState().setFirstVisibleLine(0);
            } else {
                pageActionString = "next";
                SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" pageActionString = " + pageActionString));
                page = this.m_DataSource.getNextPage();
            }
        }
        catch (Exception x) {
            SilverTrace.error((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"viewgenerator.EX_CANT_LOAD_PAGE");
            return "";
        }
        if (page == null) {
            return "";
        }
        int pageNumber = this.m_DataSource.getCurrentPageNumber();
        int firstItemNumber = page.getStartItemDocumentIndex();
        int lastItemNumber = page.getEndItemDocumentIndex();
        int itemCount = this.m_DataSource.getItemCount();
        int pageItemCount = page.getItemCount();
        SilverTrace.info((String)"viewgenerator", (String)"ArrayPaneWithDataSource.dataSourcePrint()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" PageNumber=" + pageNumber + ", pageItemCount=" + pageItemCount));
        String result = "";
        result = result + "<table width=\"98%\" class=\"ArrayColumn\" cellspacing=0 cellpadding=2 border=0><tr><td>\n";
        result = result + "<table bgcolor=\"ffffff\" width=\"100%\" cellspacing=\"" + this.getCellSpacing() + "\" cellpadding=\"" + this.getCellPadding() + "\" border=\"" + this.getCellBorderWidth() + "\">";
        if (this.getTitle() != null) {
            result = result + "<tr>";
            result = result + "<td class=\"txttitrecol\" colspan=\"" + columnsCount + "\">";
            result = result + this.getTitle();
            result = result + "</td>";
            result = result + "</tr>\n";
        }
        result = result + "<tr>";
        for (i = 0; i < columnsCount; ++i) {
            ArrayColumn ac = new ArrayColumn(this.m_DataSource.getHeader().getFieldDisplayName(i), i + 1, this);
            String fra = this.m_DataSource.getHeader().getFieldRoutingAddress(i);
            if (fra == null) {
                ac.setRoutingAddress(this.getUrl());
            } else {
                ac.setRoutingAddress(fra);
                if ("".equals(fra)) {
                    ac.setSortable(false);
                }
            }
            if (this.getRequest() != null) {
                result = result + ac.print();
            }
            if (this.getCellSpacing() != 0) continue;
            result = result + this.printPseudoColumn();
        }
        result = result + "</tr>\n";
        for (i = 0; i < pageItemCount; ++i) {
            WAItem item = null;
            item = i == 0 ? page.getFirstItem() : page.getNextItem();
            result = result + "<tr id=\"" + i + "\">\n";
            result = result + "<!-- column count is + " + columnsCount + " -->\n";
            for (int j = 0; j < columnsCount; ++j) {
                ArrayCell ct;
                String name = this.m_DataSource.getHeader().getFieldName(j);
                String value = item.getFieldByName(name);
                String anchor = item.getAnchorByName(name);
                String style = item.getStyle();
                if (anchor == null) {
                    ct = new ArrayCellText(value, this.m_ArrayLine);
                    if (style != null) {
                        ct.setStyleSheet(style);
                    }
                    result = result + ((ArrayCellText)ct).print();
                } else {
                    ct = new ArrayCellLink(value, anchor, this.m_ArrayLine);
                    if (style != null) {
                        ct.setStyleSheet(style);
                    }
                    result = result + ((ArrayCellLink)ct).print();
                }
                if (this.getCellSpacing() != 0) continue;
                result = result + new ArrayEmptyCell().print();
            }
            result = result + "</tr>\n";
        }
        result = result + "</table>\n";
        if (-1 != this.getState().getMaximumVisibleLine()) {
            String url;
            String iconPath = this.getIconsPath();
            result = result + "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"ArrayColumn\">\n<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\" bgcolor=\"#FFFFFF\">\n" + "<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\"> \n" + "<td class=\"ArrayNavigation\" height=\"20\">";
            if (pageNumber > 0) {
                result = result + "<a class=\"ArrayNavigation\" href=\"";
                url = this.getUrl();
                url = !url.contains("?") ? url + "?" : url + "&";
                url = url + "ArrayPaneAction=Previous&ArrayPaneTarget=" + this.getName();
                result = result + url + "\"><< Pr&eacute;c&eacute;dent </a>  | ";
            }
            result = firstItemNumber != lastItemNumber ? result + (firstItemNumber + 1) + " - " + lastItemNumber : result + (firstItemNumber + 1);
            result = result + " / " + itemCount;
            if (lastItemNumber + 1 < itemCount) {
                result = result + " | <a class=\"ArrayNavigation\" href=\"";
                url = this.getUrl();
                url = !url.contains("?") ? url + "?" : url + "&";
                url = url + "ArrayPaneAction=Next&ArrayPaneTarget=" + this.getName();
                result = result + url + "\">Suivant >></a>";
            }
            result = result + "</td></tr>\n<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\" bgcolor=\"#666666\">\n" + "<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "</table>";
        }
        result = result + "</td></tr></table>\n";
        return result;
    }

    private String standardPrint() {
        int first = -1;
        int last = -1;
        if (this.getColumnToSort() != 0) {
            Collections.sort(this.getLines());
        }
        int columnsCount = this.getColumns().size();
        if (this.getCellSpacing() == 0) {
            columnsCount *= 2;
        }
        String result = "";
        result = result + "<table width=\"98%\" class=\"ArrayColumn\" cellspacing=0 cellpadding=2 border=0><tr><td>\n";
        result = result + "<table bgcolor=\"ffffff\" width=\"100%\" cellspacing=\"" + this.getCellSpacing() + "\" cellpadding=\"" + this.getCellPadding() + "\" border=\"" + this.getCellBorderWidth() + "\">";
        if (this.getTitle() != null) {
            result = result + "<tr>";
            result = result + "<td class=\"txttitrecol\" colspan=\"" + columnsCount + "\">";
            result = result + this.getTitle();
            result = result + "</td>";
            result = result + "</tr>\n";
        }
        result = result + "<tr>";
        for (ArrayColumn column : this.getColumns()) {
            result = result + column.print(this.isXHTML());
            if (this.getCellSpacing() != 0) continue;
            result = result + this.printPseudoColumn();
        }
        result = result + "</tr>\n";
        if (this.getLines().isEmpty()) {
            result = result + "<tr><td>&nbsp;</td></tr>\n";
        } else {
            int max = this.getState().getMaximumVisibleLine();
            if (max == -1) {
                max = this.getLines().size();
            }
            if ((first = this.getState().getFirstVisibleLine()) > this.getLines().size() - max) {
                first = this.getLines().size() - max;
            }
            if (first < 0) {
                first = 0;
            }
            this.getState().setFirstVisibleLine(first);
            int i = first;
            while (i < this.getLines().size() && i < first + max) {
                result = this.getCellSpacing() == 0 ? result + this.getLines().get(i).printWithPseudoColumns() : result + this.getLines().get(i).print();
                last = i++;
            }
        }
        result = result + "</table>\n";
        if (-1 != this.getState().getMaximumVisibleLine()) {
            String iconPath = this.getIconsPath();
            result = result + "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"ArrayColumn\">\n<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\" bgcolor=\"#FFFFFF\">\n" + "<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\"> \n" + "<td class=\"ArrayNavigation\" height=\"20\">";
            if (first > 0) {
                result = result + "<a class=\"ArrayNavigation\" href=\"";
                String url = this.getUrl();
                url = !url.contains("?") ? url + "?" : url + "&";
                url = url + "ArrayPaneAction=Previous&ArrayPaneTarget=" + this.getName();
                result = result + url + "\"><< Pr&eacute;c&eacute;dent </a>  | ";
            }
            result = first != last ? result + (first + 1) + " - " + (last + 1) : result + (first + 1);
            result = result + " / " + this.getLines().size();
            if (last + 1 < this.getLines().size()) {
                result = result + " | <a class=\"ArrayNavigation\" href=\"";
                String url = this.getUrl();
                url = !url.contains("?") ? url + "?" : url + "&";
                url = url + "ArrayPaneAction=Next&ArrayPaneTarget=" + this.getName();
                result = result + url + "\">Suivant >></a>";
            }
            result = result + "</td></tr>\n<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "<tr align=\"center\" bgcolor=\"#666666\">\n" + "<td><img src=\"" + iconPath + "1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n" + "</tr>\n" + "</table>";
        }
        result = result + "</td></tr></table>\n";
        return result;
    }
}

