/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.browseBars;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.html.HtmlCleaner;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.viewGenerator.html.browseBars.AbstractBrowseBar;
import com.stratelia.webactiv.util.viewGenerator.html.browseBars.BrowseBarElement;
import java.io.IOException;
import java.util.List;
import org.apache.xerces.xni.XNIException;
import org.owasp.encoder.Encode;

public class BrowseBarComplete
extends AbstractBrowseBar {
    private static String CONNECTOR = "<span class=\"connector\">&nbsp;>&nbsp;</span>";

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("<div id=\"browseBar\">");
        result.append(this.printBreadCrumb());
        if (this.isI18N()) {
            result.append("<div id=\"i18n\">");
            result.append(this.getI18NHTMLLinks());
            result.append("&nbsp;|&nbsp;");
            result.append("</div>");
        }
        result.append("</div>");
        return result.toString();
    }

    private String printBreadCrumb() {
        String language;
        StringBuilder result = new StringBuilder();
        String information = this.getExtraInformation();
        String path = this.getPath();
        result.append(this.printScript());
        if (!StringUtil.isDefined((String)this.getSpaceJavascriptCallback())) {
            this.setSpaceJavascriptCallback("goSpace");
        }
        result.append("<div id=\"breadCrumb\">");
        boolean emptyBreadCrumb = true;
        String string = language = this.getMainSessionController() == null ? "" : this.getMainSessionController().getFavoriteLanguage();
        if (StringUtil.isDefined((String)this.getComponentId()) || StringUtil.isDefined((String)this.getSpaceId())) {
            ComponentInstLight componentInstLight;
            List spaces = StringUtil.isDefined((String)this.getComponentId()) ? this.getMainSessionController().getOrganisationController().getSpacePathToComponent(this.getComponentId()) : this.getMainSessionController().getOrganisationController().getSpacePath(this.getSpaceId());
            boolean firstSpace = true;
            for (SpaceInst spaceInst : spaces) {
                String spaceId = spaceInst.getId();
                if (!spaceId.startsWith("WA")) {
                    spaceId = "WA" + spaceId;
                }
                String href = "javascript:" + this.getSpaceJavascriptCallback() + "('" + spaceId + "')";
                if (!this.isClickable()) {
                    href = "#";
                }
                if (!firstSpace) {
                    result.append(CONNECTOR);
                }
                result.append("<a href=\"").append(href).append("\"");
                result.append(" class=\"space\"");
                result.append(" id=\"space").append(spaceId).append("\"");
                result.append(">");
                result.append(Encode.forHtml((String)spaceInst.getName(language)));
                result.append("</a>");
                firstSpace = false;
                emptyBreadCrumb = false;
            }
            if (StringUtil.isDefined((String)this.getComponentId()) && (componentInstLight = this.getMainSessionController().getOrganisationController().getComponentInstLight(this.getComponentId())) != null) {
                result.append(CONNECTOR);
                result.append("<a href=\"");
                if (!this.isClickable()) {
                    result.append("#");
                } else if (StringUtil.isDefined((String)this.getComponentJavascriptCallback())) {
                    result.append("javascript:").append(this.getComponentJavascriptCallback()).append("('").append(this.getComponentId()).append("')");
                } else {
                    result.append(URLManager.getApplicationURL()).append(URLManager.getURL((String)this.getSpaceId(), (String)this.getComponentId()));
                    if (this.ignoreComponentLink()) {
                        result.append("Main");
                    } else {
                        result.append(this.getComponentLink());
                    }
                }
                result.append("\"");
                result.append(" class=\"component\"");
                result.append(" id=\"bc_").append(componentInstLight.getId()).append("\"");
                result.append(">");
                result.append(Encode.forHtml((String)componentInstLight.getLabel(language)));
                result.append("</a>");
                emptyBreadCrumb = false;
            }
        } else {
            if (this.getDomainName() != null) {
                result.append(this.getDomainName());
                emptyBreadCrumb = false;
            }
            if (this.getComponentName() != null) {
                if (this.getDomainName() != null) {
                    result.append(CONNECTOR);
                }
                if (this.getComponentLink() != null) {
                    result.append("<a href=\"").append(this.getComponentLink()).append("\">").append(this.getComponentName()).append("</a>");
                } else {
                    result.append(this.getComponentName());
                }
                emptyBreadCrumb = false;
            }
        }
        List<BrowseBarElement> elements = this.getElements();
        if (!elements.isEmpty()) {
            for (BrowseBarElement element : elements) {
                if (!emptyBreadCrumb) {
                    result.append(CONNECTOR);
                }
                result.append("<a href=\"").append(element.getLink()).append("\"");
                result.append(" class=\"element\"");
                if (StringUtil.isDefined((String)element.getId())) {
                    result.append(" id=\"").append(element.getId()).append("\"");
                }
                result.append(">");
                result.append(EncodeHelper.javaStringToHtmlString((String)element.getLabel()));
                result.append("</a>");
                emptyBreadCrumb = false;
            }
        } else if (StringUtil.isDefined((String)path)) {
            if (!emptyBreadCrumb) {
                result.append(CONNECTOR);
            }
            result.append("<span class=\"path\">");
            result.append(path);
            result.append("</span>");
        }
        if (StringUtil.isDefined((String)information)) {
            if (!emptyBreadCrumb) {
                result.append(CONNECTOR);
            }
            result.append("<span class=\"information\">");
            result.append(information);
            result.append("</span>");
        }
        result.append("</div>");
        return result.toString();
    }

    private String printScript() {
        String context = URLManager.getApplicationURL();
        StringBuilder script2 = new StringBuilder();
        script2.append("<script type=\"text/javascript\">");
        script2.append("function goSpace(spaceId) {");
        String mainFrame = "/admin/jsp/MainFrameSilverpeasV5.jsp";
        if (this.look != null && StringUtil.isDefined((String)this.look.getMainFrame()) && !(mainFrame = this.look.getMainFrame()).startsWith("/")) {
            mainFrame = "/admin/jsp/" + mainFrame;
        }
        script2.append(" top.location = \"").append(context).append(mainFrame).append("?RedirectToSpaceId=\"+spaceId;");
        script2.append("}");
        script2.append("</script>");
        return script2.toString();
    }

    @Override
    public String getBreadCrumb() {
        try {
            return this.getTextBreadCrumb(this.printBreadCrumb());
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    String getTextBreadCrumb(String html) throws IOException {
        HtmlCleaner cleaner = new HtmlCleaner();
        return cleaner.cleanHtmlFragment(html);
    }
}

