/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.calendar;

import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.calendar.Calendar;
import com.stratelia.webactiv.util.viewGenerator.html.monthCalendar.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractCalendar
implements Calendar {
    protected boolean navigationBar = true;
    protected boolean shortName = true;
    protected boolean monthVisible = true;
    protected String weekDayStyle = "class=\"txtnav\"";
    protected String monthDayStyle = "class=\"txtnav3\"";
    protected String monthDayStyleEvent = "class=\"intfdcolor3\"";
    private String context = "";
    protected ResourceLocator settings = null;
    protected String language = null;
    private List<Event> events = null;
    private List<Date> nonSelectableDays = null;
    private Date currentDate = null;
    private boolean emptyDayNonSelectable = false;

    public AbstractCalendar(String context, String language, Date date) {
        this.context = context;
        this.language = language;
        this.currentDate = date;
        this.settings = new ResourceLocator("com.stratelia.webactiv.multilang.generalMultilang", language);
    }

    @Override
    public void setEvents(List<Event> events) {
        if (events != null) {
            this.events = new ArrayList<Event>(events);
        }
    }

    @Override
    public void addEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(event);
    }

    public boolean isEmptyDayNonSelectable() {
        return this.emptyDayNonSelectable;
    }

    @Override
    public void setEmptyDayNonSelectable(boolean nonSelectable) {
        this.emptyDayNonSelectable = nonSelectable;
    }

    @Override
    public void setWeekDayStyle(String value) {
        this.weekDayStyle = value;
    }

    @Override
    public void setMonthDayStyle(String value) {
        this.monthDayStyle = value;
    }

    @Override
    public void setMonthVisible(boolean value) {
        this.monthVisible = value;
    }

    @Override
    public void setNavigationBar(boolean value) {
        this.navigationBar = value;
    }

    @Override
    public void setShortName(boolean value) {
        this.shortName = value;
    }

    public String getContext() {
        return this.context;
    }

    public Collection<Event> getEvents() {
        return this.events;
    }

    public List<Date> getNonSelectableDays() {
        return this.nonSelectableDays;
    }

    @Override
    public void setNonSelectableDays(List<Date> nonSelectableDays) {
        this.nonSelectableDays = nonSelectableDays;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }
}

