/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.formPanes;

import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormButton;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormButtonSubmit;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLabel;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLine;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPane;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPaneWA;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormTextField;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class FormButtonsLine
extends FormLine {
    private List<FormButton> buttons;

    public FormButtonsLine(String nam, String val) {
        super(nam, val);
        this.buttons = new ArrayList<FormButton>();
        this.setType("buttonLine");
    }

    public FormButtonsLine(String nam, String val, String lab) {
        super(nam, val);
        this.setLabel(lab);
        this.buttons = new ArrayList<FormButton>();
        this.setType("buttonLine");
    }

    public void addButton(FormButton fb) {
        this.buttons.add(fb);
    }

    @Override
    public String print() {
        StringBuilder buttonLine = new StringBuilder();
        if (!this.label.equals("")) {
            buttonLine.append("\n<td>").append(this.noNull(this.label)).append("</td>");
        } else {
            buttonLine.append("\n<td>&nbsp;</td>");
        }
        if (this.buttons.size() > 0) {
            buttonLine.append("\n<td><table><tr>");
            for (FormButton button : this.buttons) {
                buttonLine.append(button.print());
            }
            buttonLine.append("\n</tr></table></td>");
        } else {
            buttonLine.append("\n<td>&nbsp;</td>");
        }
        return buttonLine.toString();
    }

    @Override
    public FormPane getDescriptor(String nam, String url, PageContext pc) {
        FormPaneWA fpw = new FormPaneWA(nam, url, pc);
        fpw.add(new FormLabel("configuratorTitle", "Configuration du FormLabel"));
        fpw.add(new FormTextField("configuratorLabelValue", "", "Entrez la valeur : "));
        fpw.add(new FormButtonSubmit("newConfiguratorSubmitButton", "Cr\u00e9er"));
        return fpw;
    }

    @Override
    public void getConfigurationByRequest(HttpServletRequest req) {
        this.setLabel(req.getParameter("configuratorLabelValue"));
    }

    @Override
    public String printDemo() {
        StringBuilder buttonLine = new StringBuilder();
        if (!this.label.equals("")) {
            buttonLine.append("\n<td>").append(this.label).append("</td>");
        } else {
            buttonLine.append("\n<td>&nbsp;</td>");
        }
        if (this.buttons.size() > 0) {
            buttonLine.append("\n<td><table><tr>");
            for (FormButton button : this.buttons) {
                buttonLine.append(button.printDemo());
            }
            buttonLine.append("\n</tr></table></td>");
        } else {
            buttonLine.append("\n<td>&nbsp;</td>");
        }
        return buttonLine.toString();
    }

    @Override
    public String toXML() {
        StringBuilder buttonLine = new StringBuilder();
        buttonLine.append("\n<field id=\"").append(this.id).append("\" type=\"buttonLine\">").append("\n<name>").append(this.name).append("</name>").append("\n<label>").append(this.label).append("</label>").append("\n<value>").append(this.value).append("</value>");
        if (this.buttons.size() > 0) {
            buttonLine.append("\n<actions>");
            for (FormButton button : this.buttons) {
                buttonLine.append(button.toLineXML());
            }
            buttonLine.append("\n</actions>");
        }
        buttonLine.append("\n</field>");
        return buttonLine.toString();
    }
}

