/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.formPanes;

import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormButtonSubmit;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLabel;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLine;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPane;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPaneWA;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormTextField;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class FormSelect
extends FormLine {
    private int size;
    private int nbItems;
    private List<String> itemsLabels;
    private List<String> itemValues;
    private List<Boolean> itemsSelected;

    public FormSelect(String nam, String val) {
        super(nam, val);
        this.setLabel(nam);
        this.size = 1;
        this.itemsLabels = new ArrayList<String>();
        this.itemValues = new ArrayList<String>();
        this.itemsSelected = new ArrayList<Boolean>();
        this.nbItems = 0;
        this.setType("select");
    }

    public FormSelect(String nam, String val, String lab, int siz) {
        super(nam, val);
        this.setLabel(lab);
        this.size = siz;
        this.itemsLabels = new ArrayList<String>();
        this.itemValues = new ArrayList<String>();
        this.itemsSelected = new ArrayList<Boolean>();
        this.nbItems = 0;
        this.setType("select");
    }

    public void addItem(String itemsLabel, String itemValue, boolean selected) {
        this.itemsLabels.add(itemsLabel);
        this.itemValues.add(itemValue);
        this.itemsSelected.add(selected);
        ++this.nbItems;
    }

    public void addItem(String itemsLabel, String itemValue) {
        this.itemsLabels.add(itemsLabel);
        this.itemValues.add(itemValue);
        this.itemsSelected.add(Boolean.FALSE);
        ++this.nbItems;
    }

    @Override
    public String print() {
        String retour = "\n<td>" + this.label + "</td>";
        retour = retour + "\n<td><select name=\"" + this.name + "\" size=\"" + String.valueOf(this.size) + "\">";
        for (int i = 0; i < this.nbItems; ++i) {
            retour = retour + "\n<option value=\"" + this.itemValues.get(i) + "\"";
            if (this.itemsSelected.get(i).booleanValue()) {
                retour = retour + " selected ";
            }
            retour = retour + ">" + this.itemsLabels.get(i) + "</option>";
        }
        retour = retour + "\n</select></td>";
        return retour;
    }

    @Override
    public FormPane getDescriptor(String nam, String url, PageContext pc) {
        FormPaneWA fpw = new FormPaneWA(nam, url, pc);
        fpw.add(new FormLabel("configuratorTitle", "Configuration du FormLabel"));
        fpw.add(new FormTextField("configuratorLabelValue", "", "Entrez la valeur : "));
        fpw.add(new FormButtonSubmit("newConfiguratorSubmitButton", "Cr\u00e9er"));
        return fpw;
    }

    @Override
    public void getConfigurationByRequest(HttpServletRequest req) {
        this.setLabel(req.getParameter("configuratorLabelValue"));
    }

    @Override
    public String printDemo() {
        String retour = "\n<td>" + this.label + "</td>";
        retour = retour + "<td>" + this.value + "</td>";
        return retour;
    }

    @Override
    public String toXML() {
        String retour = "\n<field id=\"" + this.id + "\" type=\"label\">";
        retour = retour + "\n</field>";
        return retour;
    }
}

