/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.formPanes;

import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormButtonSubmit;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLabel;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormLine;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPane;
import com.stratelia.webactiv.util.viewGenerator.html.formPanes.FormPaneWA;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class FormTextField
extends FormLine {
    private int nbCharMax;
    protected static int TOUS_CARACTERES = 0;
    protected static int BASIQUES_NON_ACCENTUES = 1;
    protected static int BASIQUES_ACCENTUES = 2;
    protected static int ETENDUS_NON_ACCENTUES = 3;
    protected static int ETENDUS_ACCENTUES = 4;
    protected static int NO_CONVERSION = 0;
    protected static int LOWER_CONVERSION = 1;
    protected static int UPPER_CONVERSION = 2;

    public FormTextField() {
        this.setName("newFormTextField");
        this.setLabel("newFormTextField");
        this.setType("text");
        this.nbCharMax = 255;
        this.setDBEntry(true);
    }

    public FormTextField(String nam, String val) {
        super(nam, val);
        this.setLabel("newFormTextField");
        this.setType("text");
        this.nbCharMax = 255;
        this.setDBEntry(true);
    }

    public FormTextField(String nam, String val, String lab) {
        super(nam, val);
        this.setLabel(lab);
        this.setType("text");
        this.nbCharMax = 255;
        this.setDBEntry(true);
    }

    public void setNbCharMax(int nb) {
        this.nbCharMax = nb;
    }

    @Override
    public String print() {
        String retour = "\n<td class=\"couleurFondCadre\" align=\"right\" width=\"50%\"><span class=\"txtnote\">" + this.noNull(this.label);
        retour = retour + "&nbsp;</span></td>";
        retour = retour + "<td class=\"couleurFondCadre\" width=\"50%\">&nbsp;";
        retour = retour + "<input type=\"text\" name=\"" + this.name + "\" value=\"" + this.noNull(this.value) + "\"></td>";
        return retour;
    }

    @Override
    public FormPane getDescriptor(String nam, String url, PageContext pc) {
        FormPaneWA fpw = new FormPaneWA(nam, url, pc);
        fpw.add(new FormLabel("configuratorTitle", this.message.getString("TextFieldConfig"), ""));
        fpw.add(new FormTextField("configuratorLabelValue", "", this.message.getString("EnterLabelValue") + " : "));
        fpw.add(new FormTextField("configuratorDefaultValue", "", this.message.getString("EnterDefaultValue") + " : "));
        fpw.add(new FormButtonSubmit("newConfiguratorSubmitButton", this.message.getString("Create")));
        return fpw;
    }

    @Override
    public void getConfigurationByRequest(HttpServletRequest req) {
        this.setLabel(req.getParameter("configuratorLabelValue"));
        this.setValue(req.getParameter("configuratorDefaultValue"));
    }

    @Override
    public String printDemo() {
        String retour = "\n<td class=\"couleurFondCadre\" align=\"right\" width=\"50%\"><span class=\"txtnote\">" + this.label;
        retour = retour + "&nbsp;</span></td>";
        retour = retour + "<td class=\"couleurFondCadre\" width=\"50%\">&nbsp;";
        retour = retour + "<input type=\"text\" name=\"" + this.name + "\" value=\"" + this.value + "\"></td>";
        return retour;
    }

    @Override
    public String toXML() {
        String retour = "\n<field id=\"" + this.id + "\" type=\"text\">";
        retour = retour + "\n<name>" + this.name + "</name>";
        retour = retour + "\n<label>" + this.label + "</label>";
        retour = retour + "\n<value>" + this.value + "</value>";
        retour = retour + "\n<size>" + String.valueOf(this.nbCharMax) + "</size>";
        retour = retour + "\n<dbtype>" + this.DBType + "</dbtype>";
        retour = retour + "\n</field>";
        return retour;
    }

    @Override
    public String getDBColumnCreationRequest() {
        String result = this.id + " " + this.DBType;
        if (this.DBType.equals("character varying")) {
            result = result + "(" + String.valueOf(this.nbCharMax) + ")";
        }
        result = this.mandatory ? result + " NOT NULL, " : result + " , ";
        return result;
    }
}

