/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.map;

import com.silverpeas.look.LookHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.silverpeas.core.admin.OrganisationController;

public class MapTag
extends TagSupport {
    private static final long serialVersionUID = 1425756234498404463L;
    private String spaceId;

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public int doStartTag() throws JspException {
        try {
            LookHelper helper = (LookHelper)this.pageContext.getSession().getAttribute("Silverpeas_LookHelper");
            boolean showHiddenComponents = helper.getSettings("display.all.components", false);
            this.pageContext.getOut().print(this.printSpaceAndSubSpaces(this.spaceId, 0, showHiddenComponents));
        }
        catch (IOException e) {
            throw new JspException("Can't display the site map", (Throwable)e);
        }
        return 0;
    }

    private String printSpaceAndSubSpaces(String spaceId, int depth, boolean showHiddenComponents) {
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        MainSessionController sessionController = (MainSessionController)this.pageContext.getSession().getAttribute("SilverSessionController");
        OrganisationController organisationController = sessionController.getOrganisationController();
        SpaceInst spaceInst = organisationController.getSpaceInstById(spaceId);
        StringBuilder result = new StringBuilder(500);
        if (spaceInst != null) {
            String[] subSpaceIds;
            String language = sessionController.getFavoriteLanguage();
            result.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\n");
            if (depth == 0) {
                result.append("<tr><td>&nbsp;</td></tr>\n");
            }
            result.append("<tr>\n");
            if (URLManager.displayUniversalLinks()) {
                result.append("<td class=\"txttitrecol\">&#8226; <a href=\"");
                result.append(URLManager.getSimpleURL((int)0, (String)spaceInst.getId()));
                result.append("\" target=\"_top\">").append(spaceInst.getName(language));
                result.append("</a></td></tr>\n");
            } else {
                result.append("<td class=\"txttitrecol\">&#8226; ").append(spaceInst.getName(language));
                result.append("</td></tr>\n");
            }
            result.append("<tr><td>\n");
            ArrayList alCompoInst = spaceInst.getAllComponentsInst();
            for (ComponentInst componentInst : alCompoInst) {
                boolean bAllowed;
                if (componentInst.isHidden() && !showHiddenComponents || !(bAllowed = organisationController.isComponentAvailable(componentInst.getId(), sessionController.getUserId()))) continue;
                String label = componentInst.getLabel(language);
                if (!StringUtil.isDefined((String)label)) {
                    label = componentInst.getName();
                }
                result.append("&nbsp;<img src=\"").append(contextPath).append("/util/icons/component/");
                if (componentInst.isWorkflow()) {
                    result.append("processManager");
                } else {
                    result.append(componentInst.getName());
                }
                result.append("Small.gif\" border=\"0\" width=\"15\" align=\"top\" alt=\"\"/>&nbsp;");
                if (URLManager.displayUniversalLinks()) {
                    result.append("<a href=\"");
                    result.append(URLManager.getSimpleURL((int)1, (String)componentInst.getId()));
                    result.append("\" target=\"_top\">").append(label).append("</a>\n");
                    continue;
                }
                result.append("<a href=\"");
                result.append(contextPath).append(URLManager.getURL((String)componentInst.getName(), (String)spaceId, (String)componentInst.getId()));
                result.append("Main\" target=\"MyMain\" title=\"").append(componentInst.getDescription()).append("\">").append(label).append("</a>\n");
            }
            for (String subSpaceId : subSpaceIds = organisationController.getAllowedSubSpaceIds(sessionController.getUserId(), spaceId)) {
                String subSpaceContent = this.printSpaceAndSubSpaces(subSpaceId, depth + 1, showHiddenComponents);
                if (!StringUtil.isDefined((String)subSpaceContent)) continue;
                result.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n");
                result.append("<tr><td>&nbsp;&nbsp;</td>\n");
                result.append("<td>\n");
                result.append(subSpaceContent);
                result.append("</td></tr></table>\n");
            }
            result.append("</td>\n");
            result.append("</tr>\n");
            result.append("</table>\n");
        }
        return result.toString();
    }
}

