/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.pagination;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import com.stratelia.webactiv.util.viewGenerator.html.pagination.Pagination;

public abstract class AbstractPagination
implements Pagination {
    private int nbItems = -1;
    private int nbItemsPerPage = -1;
    private int firstItemIndex = -1;
    private String actionSuffix = "";
    private String altPreviousPage = "";
    private String altNextPage = "";
    private String baseURL = null;
    private int nbPagesAround = -1;
    private ResourceLocator multilang;

    @Override
    public void init(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        this.nbItems = nbItems;
        this.nbItemsPerPage = nbItemsPerPage;
        this.firstItemIndex = firstItemIndex > nbItems - 1 ? (nbItems == 0 ? 0 : firstItemIndex - nbItemsPerPage) : firstItemIndex;
        SilverTrace.info((String)"viewgenerator", (String)"AbstractPagination.constructor()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nbItems = " + nbItems + ", nbItemsPerPage = " + nbItemsPerPage + ", firstItemIndex = " + firstItemIndex));
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    public int getNbItems() {
        return this.nbItems;
    }

    public int getNbItemsPerPage() {
        return this.nbItemsPerPage;
    }

    @Override
    public int getFirstItemIndex() {
        return this.firstItemIndex;
    }

    @Override
    public int getLastItemIndex() {
        int end = this.getFirstItemIndex() + this.getNbItemsPerPage();
        if (end > this.getNbItems() - 1) {
            end = this.getNbItems();
        }
        return end;
    }

    public int getCurrentPage() {
        int currentPage = (this.getFirstItemIndex() + 1) / this.getNbItemsPerPage();
        SilverTrace.info((String)"viewgenerator", (String)"AbstractPagination.getCurrentPage()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("currentPage = " + currentPage));
        currentPage = currentPage == 0 ? 1 : ++currentPage;
        return currentPage;
    }

    public int getNbPage() {
        int nbPage = this.getNbItems() / this.getNbItemsPerPage();
        if (this.getNbItems() % this.getNbItemsPerPage() != 0) {
            ++nbPage;
        }
        SilverTrace.info((String)"viewgenerator", (String)"AbstractPagination.getNbPage()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nbPage = " + nbPage));
        return nbPage;
    }

    @Override
    public boolean isLastPage() {
        return this.getFirstItemIndex() + 1 + this.getNbItemsPerPage() > this.getNbItems();
    }

    @Override
    public int getIndexForPreviousPage() {
        return this.getIndexForDirectPage(this.getCurrentPage() - 1);
    }

    @Override
    public int getIndexForDirectPage(int page) {
        int result = (page - 1) * this.getNbItemsPerPage();
        if (result > this.getNbItems()) {
            result = this.getIndexForLastPage();
        }
        return result;
    }

    @Override
    public int getIndexForCurrentPage() {
        return this.getIndexForDirectPage(this.getCurrentPage());
    }

    @Override
    public int getIndexForNextPage() {
        return this.getIndexForDirectPage(this.getCurrentPage() + 1);
    }

    public int getIndexForLastPage() {
        return this.getNbPage() * this.getNbItemsPerPage() - this.getNbItemsPerPage();
    }

    @Override
    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    public String getActionSuffix() {
        return this.actionSuffix;
    }

    @Override
    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setAltPreviousPage(String text) {
        this.altPreviousPage = text;
    }

    @Override
    public void setAltNextPage(String text) {
        this.altNextPage = text;
    }

    public String getAltPreviousPage() {
        return this.altPreviousPage;
    }

    public String getAltNextPage() {
        return this.altNextPage;
    }

    public int getNumberOfPagesAround() {
        if (this.nbPagesAround == -1) {
            this.nbPagesAround = Integer.parseInt(GraphicElementFactory.getSettings().getString("Pagination.NumberOfPagesAround", "10"));
        }
        return this.nbPagesAround;
    }

    public boolean displayTotalNumberOfPages() {
        return GraphicElementFactory.getSettings().getBoolean("Pagination.DisplayTotalNumberOfPages", false);
    }

    @Override
    public void setMultilang(ResourceLocator multilang) {
        this.multilang = multilang;
    }

    public ResourceLocator getMultilang() {
        return this.multilang;
    }

    public String getString(String key) {
        return this.getMultilang().getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getMultilang().getString(key, defaultValue);
    }

    @Override
    public abstract String print();

    @Override
    public abstract String printIndex();

    @Override
    public abstract String printIndex(String var1);

    @Override
    public abstract String printCounter();
}

