/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.pagination;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.viewGenerator.html.pagination.AbstractPagination;
import java.util.Date;

public class PaginationSP
extends AbstractPagination {
    @Override
    public void init(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        super.init(nbItems, nbItemsPerPage, firstItemIndex);
    }

    @Override
    public String printCounter() {
        StringBuilder result = new StringBuilder();
        if (this.getNbItems() <= this.getNbItemsPerPage()) {
            result.append(this.getNbItems()).append(" ");
        } else {
            int end = this.getFirstItemIndex() + this.getNbItemsPerPage();
            if (end > this.getNbItems()) {
                end = this.getNbItems();
            }
            result.append(this.getFirstItemIndex() + 1).append(" - ").append(end).append(" / ").append(this.getNbItems()).append(" ");
        }
        return result.toString();
    }

    @Override
    public String printIndex() {
        return this.printIndex(null);
    }

    @Override
    public String printIndex(String javascriptFunc) {
        StringBuilder result = new StringBuilder();
        if (this.getNbItems() > 0 && this.getNbItems() > this.getNbItemsPerPage()) {
            boolean displayJumper;
            result.append("<div class=\"pageNav\">");
            result.append("<div class=\"pageNavContent\">");
            int nbPage = this.getNbPage();
            int currentPage = this.getCurrentPage();
            int index = -1;
            if (this.displayTotalNumberOfPages() && nbPage > this.getNumberOfPagesAround()) {
                result.append("<div class=\"pageIndex\">");
                result.append(this.getString("GEF.pagination.page")).append(" ").append(currentPage).append(this.getString("GEF.pagination.pageOn")).append(nbPage);
                result.append("</div>");
            }
            if (this.getFirstItemIndex() >= this.getNbItemsPerPage()) {
                if (currentPage - this.getNumberOfPagesAround() > 1) {
                    result.append("<div class=\"pageOff\">");
                    result.append(this.getLink(javascriptFunc, 0, this.getString("GEF.pagination.firstPage")));
                    result.append("<img src=\"").append(this.getIconsPath()).append("/arrows/arrowDoubleLeft.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(this.getString("GEF.pagination.firstPage")).append("\"/></a>");
                    result.append("</div>");
                }
                result.append("<div class=\"pageOff\">");
                index = this.getIndexForPreviousPage();
                result.append(this.getLink(javascriptFunc, index, this.getString("GEF.pagination.previousPage")));
                result.append("<img src=\"").append(this.getIconsPath()).append("/arrows/arrowLeft.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(this.getString("GEF.pagination.previousPage")).append("\"/></a>");
                result.append("</div>");
            }
            for (int i = 1; i <= nbPage; ++i) {
                if (i == currentPage) {
                    result.append("<div class=\"pageOn\">");
                    result.append(i).append("</div>");
                    continue;
                }
                int nbDisplayPages = this.getNumberOfPagesAround();
                if (currentPage - nbDisplayPages > i || i > currentPage + nbDisplayPages) continue;
                index = this.getIndexForDirectPage(i);
                result.append("<div class=\"pageOff\">");
                result.append(this.getLink(javascriptFunc, index, this.getString("GEF.pagination.gotoPage") + i));
                result.append(i).append("</a>");
                result.append("</div>");
            }
            if (!this.isLastPage()) {
                index = this.getIndexForNextPage();
                result.append("<div class=\"pageOff\">");
                result.append(this.getLink(javascriptFunc, index, this.getString("GEF.pagination.nextPage")));
                result.append("<img src=\"").append(this.getIconsPath()).append("/arrows/arrowRight.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(this.getString("GEF.pagination.nextPage")).append("\"/></a>");
                result.append("</div>");
                if (currentPage + this.getNumberOfPagesAround() < nbPage) {
                    result.append("<div class=\"pageOff\">");
                    result.append(this.getLink(javascriptFunc, this.getIndexForLastPage(), this.getString("GEF.pagination.lastPage")));
                    result.append("<img src=\"").append(this.getIconsPath()).append("/arrows/arrowDoubleRight.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(this.getString("GEF.pagination.lastPage")).append("\"/></a> ");
                    result.append("</div>");
                }
            }
            long timeStamp = new Date().getTime();
            String jumperName = "jumper" + timeStamp;
            boolean bl = displayJumper = nbPage > this.getNumberOfPagesAround();
            if (displayJumper) {
                result.append("<div class=\"pageJumper\">");
                result.append("<a href=\"javascript:display").append(jumperName).append("()\" onfocus=\"this.blur()\" title=\"").append(this.getString("GEF.pagination.jumptoPage")).append("\">").append(this.getString("GEF.pagination.jumper")).append(" </a>");
                result.append("<input type=\"text\" class=\"jumper\" id=\"").append(jumperName).append("\" size=\"3\" onkeydown=\"check").append(jumperName).append("Submit(event)\"/>");
                result.append("</div>");
            }
            result.append("</div>");
            result.append("</div>");
            if (displayJumper) {
                result.append("<script type=\"text/javascript\">");
                result.append("function display").append(jumperName).append("() {");
                result.append("var ").append(jumperName).append(" = document.getElementById(\"").append(jumperName).append("\");");
                result.append("if (").append(jumperName).append(".style.visibility != \"visible\") {");
                result.append("").append(jumperName).append(".style.visibility = \"visible\";");
                result.append("").append(jumperName).append(".focus();");
                result.append("} else {");
                result.append("").append(jumperName).append(".style.visibility = \"hidden\";");
                result.append("}");
                result.append("}");
                result.append("function check").append(jumperName).append("Submit(ev) {");
                result.append("var touche = ev.keyCode;");
                result.append("if (touche == 13) {");
                result.append("var index = parseInt(document.getElementById(\"").append(jumperName).append("\").value);");
                result.append("if (isNaN(index) || index < 0) { index = 0; }");
                result.append("if (index > ").append(nbPage).append(") { index = ").append(nbPage).append("; }");
                result.append("index = (index-1)*").append(this.getNbItemsPerPage()).append(";");
                if (StringUtil.isDefined((String)javascriptFunc)) {
                    result.append(javascriptFunc).append("(index);");
                } else if (this.getBaseURL() != null) {
                    result.append("location.href=\"").append(this.getBaseURL()).append("\"+index;");
                } else {
                    String action = "Pagination" + this.getActionSuffix();
                    result.append("location.href=\"").append(action).append("?Index=").append("\"+index;");
                }
                result.append("}");
                result.append("}");
                result.append("</script>");
            }
        }
        return result.toString();
    }

    private String getLink(String javascriptFunc, int index, String title) {
        StringBuilder link2 = new StringBuilder();
        String action = "Pagination" + this.getActionSuffix();
        if (javascriptFunc == null) {
            if (this.getBaseURL() != null) {
                link2.append(" <a class=\"ArrayNavigation\"").append(" title=\"").append(title).append("\"").append(" href=\"").append(this.getBaseURL()).append(index);
            } else {
                link2.append(" <a class=\"ArrayNavigation\"").append(" title=\"").append(title).append("\"").append(" href=\"").append(action).append("?Index=").append(index);
            }
        } else {
            link2.append(" <a class=\"ArrayNavigation\"").append(" title=\"").append(title).append("\"").append(" href=\"").append("javascript:onClick=").append(javascriptFunc).append("(").append(index).append(")");
        }
        link2.append("\">");
        return link2.toString();
    }

    @Override
    public String print() {
        return this.printIndex();
    }
}

