/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.pagination;

import com.stratelia.webactiv.util.viewGenerator.html.pagination.AbstractPagination;

public class PaginationSilverpeasV5
extends AbstractPagination {
    @Override
    public void init(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        super.init(nbItems, nbItemsPerPage, firstItemIndex);
    }

    @Override
    public String printCounter() {
        StringBuilder result = new StringBuilder();
        if (this.getNbItems() <= this.getNbItemsPerPage()) {
            result.append(this.getNbItems()).append(" ");
        } else {
            int end = this.getFirstItemIndex() + this.getNbItemsPerPage();
            if (end > this.getNbItems()) {
                end = this.getNbItems();
            }
            result.append(this.getFirstItemIndex() + 1).append(" - ").append(end).append(" / ").append(this.getNbItems()).append(" ");
        }
        return result.toString();
    }

    @Override
    public String printIndex() {
        return this.printIndex(null);
    }

    @Override
    public String printIndex(String javascriptFunc) {
        StringBuilder result = new StringBuilder();
        if (this.getNbItems() > 0 && this.getNbItems() > this.getNbItemsPerPage()) {
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" align=\"center\">");
            result.append("<tr valign=\"middle\" class=\"intfdcolor\">");
            result.append("<td align=\"center\">");
            String action = "Pagination" + this.getActionSuffix();
            String altNextPage = this.getAltNextPage();
            String altPreviousPage = this.getAltPreviousPage();
            int nbPage = this.getNbPage();
            int currentPage = this.getCurrentPage();
            int index = -1;
            if (this.getFirstItemIndex() >= this.getNbItemsPerPage()) {
                index = this.getIndexForPreviousPage();
                if (javascriptFunc == null) {
                    result.append(" <a href=\"").append(action).append("?Index=").append(index);
                } else {
                    result.append(" <a href=\"").append("javascript:onClick=").append(javascriptFunc).append("(").append(index).append(")");
                }
                result.append("\"><img src=\"").append(this.getIconsPath()).append("/arrows/arrowLeft.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(altPreviousPage).append("\"/></a> ");
            } else {
                result.append("&#160;&#160;&#160;");
            }
            for (int i = 1; i <= nbPage; ++i) {
                if (i == currentPage) {
                    result.append(" ").append(i).append(" ");
                    continue;
                }
                index = this.getIndexForDirectPage(i);
                if (javascriptFunc == null) {
                    result.append(" <a href=\"").append(action).append("?Index=").append(index);
                } else {
                    result.append(" <a href=\"").append("javascript:onClick=").append(javascriptFunc).append("(").append(index).append(")");
                }
                result.append("\">").append(i).append("</a> ");
            }
            if (!this.isLastPage()) {
                index = this.getIndexForNextPage();
                if (javascriptFunc == null) {
                    result.append(" <a href=\"").append(action).append("?Index=").append(index);
                } else {
                    result.append(" <a href=\"").append("javascript:onClick=").append(javascriptFunc).append("(").append(index).append(")");
                }
                result.append("\"><img src=\"").append(this.getIconsPath()).append("/arrows/arrowRight.gif\" border=\"0\" align=\"absmiddle\" alt=\"").append(altNextPage).append("\"/></a>");
            } else {
                result.append("&#160;&#160;&#160;");
            }
            result.append("</td>");
            result.append("</tr>");
            result.append("</table>");
        }
        return result.toString();
    }

    @Override
    public String print() {
        return this.printIndex();
    }
}

