/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.pagination;

import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class PaginationTag
extends TagSupport {
    private static final long serialVersionUID = 7931703988418922022L;
    private int currentPage;
    private int nbPages;
    private String action;
    private String pageParam;
    private String altPreviousAction;
    private String altNextAction;
    private String altGoToAction;

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setNbPages(Integer nbPages) {
        this.nbPages = nbPages;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAltPreviousAction(String altPreviousAction) {
        this.altPreviousAction = altPreviousAction;
    }

    public void setAltNextAction(String altNextAction) {
        this.altNextAction = altNextAction;
    }

    public void setAltGoToAction(String altGoToAction) {
        this.altGoToAction = altGoToAction;
    }

    public void setPageParam(String pageParam) {
        this.pageParam = pageParam;
    }

    public int doEndTag() throws JspException {
        if (this.nbPages <= 1) {
            return 6;
        }
        boolean hasParam = this.action.indexOf(63) > 0;
        JspWriter out = this.pageContext.getOut();
        try {
            out.println("<table id=\"pagination\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" align=\"center\">");
            out.println("<tr valign=\"middle\" class=\"intfdcolor\">");
            out.println("<td align=\"center\" class=\"ArrayNavigation\">");
            out.println("<div class=\"pageNav\">");
            out.println("<div class=\"pageNavContent\">");
            if (this.currentPage > 0) {
                out.println("<div class=\"pageOff\">");
                out.println(this.getUrl(this.action, hasParam, this.altPreviousAction, this.currentPage - 1));
                out.println("<img src=\"" + this.getIconsPath() + "/arrows/arrowLeft.gif\" border=\"0\" align=\"absmiddle\" alt=\"" + this.altPreviousAction + "\"/></a>");
                out.println("</div>");
            }
            for (int i = 0; i < this.nbPages; ++i) {
                if (i == this.currentPage) {
                    out.println("<div class=\"pageOn\">");
                    out.println(i + 1);
                    out.println("</div>");
                    continue;
                }
                out.println("<div class=\"pageOff\">");
                out.println(this.getUrl(this.action, hasParam, this.altGoToAction + " " + (i + 1), i));
                out.println(i + 1);
                out.println("</a>");
                out.println("</div>");
            }
            if (this.currentPage + 1 < this.nbPages) {
                out.println("<div class=\"pageOff\">");
                out.println(this.getUrl(this.action, hasParam, this.altNextAction, this.currentPage + 1));
                out.println("<img src=\"" + this.getIconsPath() + "/arrows/arrowRight.gif\" border=\"0\" align=\"absmiddle\" alt=\"" + this.altNextAction + "\"/></a>");
                out.println("</div>");
            }
            out.println("</div>");
            out.println("</div>");
            out.println("</td>");
            out.println("</tr>");
            out.println("</table>");
            return 6;
        }
        catch (IOException e) {
            throw new JspException("Pagination Tag", (Throwable)e);
        }
    }

    public String getUrl(String elAction, boolean hasParam, String title, int page) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(" <a class=\"ArrayNavigation\"").append(" title=\"").append(title).append("\"");
        buffer.append(" href=\"").append(elAction);
        if (hasParam) {
            buffer.append('&');
        } else {
            buffer.append('?');
        }
        buffer.append(this.pageParam).append('=').append(page);
        buffer.append("\">");
        return buffer.toString();
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }
}

