/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.result;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.search.ResultDisplayer;
import com.silverpeas.search.ResultDisplayerFactory;
import com.silverpeas.search.ResultSearchRendererUtil;
import com.silverpeas.search.SearchResultContentVO;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.pdcPeas.model.GlobalSilverResult;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class HtmlSearchResultTag
extends TagSupport {
    private static final long serialVersionUID = -7747695403360864218L;
    private static final String PDC_BUNDLE_PREFIX_KEY = "result.template.";
    protected static final String RESULT_TEMPLATE_ALL = "ALL";
    protected static final String RESULT_TEMPLATE_NONE = "NONE";
    private String userId = null;
    private GlobalSilverResult gsr = null;
    private Integer sortValue = null;
    private Boolean activeSelection = false;
    private Boolean exportEnabled = false;
    private ResourcesWrapper settings = null;
    private Map<String, Boolean> componentSettings = new HashMap<String, Boolean>();

    public int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().print(this.getHtmlResult());
        }
        catch (IOException ex) {
            throw new JspException("Silverpeas Java to html paragraph Converter Tag", (Throwable)ex);
        }
        return 6;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GlobalSilverResult getGsr() {
        return this.gsr;
    }

    public void setGsr(GlobalSilverResult gsr) {
        this.gsr = gsr;
    }

    public Integer getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(Integer sortValue) {
        this.sortValue = sortValue;
    }

    public Boolean getActiveSelection() {
        return this.activeSelection;
    }

    public void setActiveSelection(Boolean activeSelection) {
        this.activeSelection = activeSelection;
    }

    public Boolean getExportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(Boolean exportEnabled) {
        this.exportEnabled = exportEnabled;
    }

    private String getHtmlResult() throws JspTagException {
        boolean processResultTemplating;
        ComponentInstLight component;
        String instanceId;
        ResourcesWrapper settings = this.getSettings();
        String componentName = instanceId = this.gsr.getInstanceId();
        String addedInformation = null;
        if (StringUtil.isDefined((String)instanceId) && !instanceId.startsWith("user") && !instanceId.startsWith("pdc") && (component = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(instanceId)) != null && (processResultTemplating = this.isResultTemplating(instanceId, componentName = component.getName()))) {
            ResultDisplayer resultDisplayer = ResultDisplayerFactory.getResultDisplayerFactory().getResultDisplayer(componentName);
            SilverTrace.debug((String)"viewgenerator", (String)HtmlSearchResultTag.class.getName(), (String)("load specific for current result: instanceid=" + instanceId + ", contentid=" + this.gsr.getId()));
            if (resultDisplayer != null) {
                addedInformation = resultDisplayer.getResultContent(new SearchResultContentVO(this.userId, this.gsr, this.sortValue, this.activeSelection, this.exportEnabled, settings));
            }
        }
        return this.generateHTMLSearchResult(settings, componentName, addedInformation);
    }

    private boolean isResultTemplating(String instanceId, String componentName) {
        boolean doResultTemplating = false;
        Boolean cacheResult = this.componentSettings.get(componentName);
        if (cacheResult != null) {
            return cacheResult;
        }
        String compConfig = PDC_BUNDLE_PREFIX_KEY + componentName;
        String listComponent = this.getSettings().getSetting(compConfig, "");
        if (StringUtil.isDefined((String)listComponent)) {
            for (String curInstanceId : listComponent.split(",")) {
                if (!curInstanceId.equals(instanceId) && !RESULT_TEMPLATE_ALL.equals(curInstanceId)) continue;
                this.componentSettings.put(instanceId, Boolean.TRUE);
                return true;
            }
        }
        this.componentSettings.put(instanceId, Boolean.FALSE);
        return doResultTemplating;
    }

    private String generateHTMLSearchResult(ResourcesWrapper settings, String componentName, String extraInformation) {
        StringBuilder result = new StringBuilder();
        String downloadSrc = "<img src=\"" + settings.getIcon("pdcPeas.download") + "\" class=\"fileDownload\" alt=\"" + settings.getString("pdcPeas.DownloadInfo") + "\" title=\"" + settings.getString("pdcPeas.DownloadInfo") + "\"/>";
        String language = this.getSettings().getLanguage();
        String sName = EncodeHelper.javaStringToHtmlString((String)this.gsr.getName(language));
        String sDescription = StringUtil.abbreviate((String)this.gsr.getDescription(language), (int)400);
        String sURL = this.gsr.getTitleLink();
        String sDownloadURL = this.gsr.getDownloadLink();
        String sLocation = this.gsr.getLocation();
        String sCreatorName = this.gsr.getCreatorName();
        String sCreationDate = null;
        try {
            sCreationDate = this.sortValue == 4 ? settings.getOutputDate(this.gsr.getCreationDate()) : settings.getOutputDate(this.gsr.getDate());
        }
        catch (Exception e) {
            sCreationDate = null;
        }
        String serverName = "";
        if (settings.getSetting("external.search.enable", false) && this.gsr.getIndexEntry() != null) {
            serverName = "external_server_" + (StringUtil.isDefined((String)this.gsr.getIndexEntry().getServerName()) ? this.gsr.getIndexEntry().getServerName() : "unknown");
        }
        result.append("<li class=\"lineResult ").append(this.gsr.getSpaceId()).append(" ");
        result.append(componentName).append(" ");
        result.append(this.gsr.getInstanceId()).append(" ");
        result.append(serverName).append("\">");
        if ((this.activeSelection.booleanValue() || this.exportEnabled.booleanValue()) && this.gsr.isExportable()) {
            String checked = "";
            if (this.gsr.isSelected()) {
                checked = "checked=\"checked\"";
            }
            result.append("<input class=\"selection\" type=\"checkbox\" ").append(checked).append(" name=\"resultObjects\" value=\"").append(this.gsr.getId()).append("-").append(this.gsr.getInstanceId()).append("\"/>");
        }
        if (settings.getSetting("PertinenceVisible", false)) {
            result.append("<div class=\"pertinence\">").append(ResultSearchRendererUtil.displayPertinence(this.gsr.getRawScore())).append("</div>");
        }
        result.append("<div class=\"content\">");
        if (StringUtil.isDefined((String)this.gsr.getThumbnailURL())) {
            result.append("<div class=\"thumb\">");
            if ("UserFull".equals(this.gsr.getType())) {
                result.append("<img class=\"avatar\" src=\"").append(URLManager.getApplicationURL()).append(this.gsr.getThumbnailURL()).append("\" border=\"0\" />");
            } else {
                result.append("<img src=\"").append(this.gsr.getThumbnailURL()).append("\" border=\"0\" width=\"").append(this.gsr.getThumbnailWidth()).append("\" height=\"").append(this.gsr.getThumbnailHeight()).append("\"/>");
            }
            result.append("</div>");
        }
        if (this.gsr.getType() != null && (this.gsr.getType().startsWith("Attachment") || this.gsr.getType().startsWith("Versioning") || this.gsr.getType().equals("LinkedFile"))) {
            String fileType = FilenameUtils.getExtension((String)this.gsr.getAttachmentFilename());
            String fileIcon = FileRepositoryManager.getFileIcon((String)fileType);
            if (!StringUtil.isDefined((String)sName)) {
                sName = this.gsr.getAttachmentFilename();
            }
            sName = "<img src=\"" + fileIcon + "\" class=\"fileIcon\"/>" + sName;
        }
        result.append("<div class=\"locationTitle\">");
        String curResultId = "readSpanId_" + this.gsr.getResultId();
        if (this.activeSelection.booleanValue()) {
            result.append("<span id=\"").append(curResultId).append("\" class=\"textePetitBold\">").append(sName).append("</span>");
        } else {
            String cssClass = "";
            String cssClassDisableVisited = "";
            if (this.gsr.isHasRead()) {
                cssClass = "markedAsRead";
                cssClassDisableVisited = "markedAsReadDisableVisited";
            }
            result.append("<a href=\"").append(sURL).append("\" class=\"").append(cssClassDisableVisited).append("\"><span id=\"").append(curResultId).append("\" class=\"").append(cssClass).append("\">").append(sName).append("</span></a>");
        }
        if (this.gsr.getIndexEntry() != null && this.gsr.getIndexEntry().isAlias()) {
            result.append(" (").append(settings.getString("GML.alias")).append(")");
        }
        if (StringUtil.isDefined((String)sDownloadURL)) {
            result.append("<a href=\"").append(sDownloadURL).append("\" class=\"fileDownload\" target=\"_blank\">").append(downloadSrc).append("</a>");
        }
        if (this.gsr.isPreviewable()) {
            result.append(" <img onclick=\"javascript:previewFile(this, '").append(this.gsr.getAttachmentId()).append("',").append(this.gsr.isVersioned()).append(",'").append(this.gsr.getInstanceId()).append("');\" class=\"preview-file\" src=\"").append(settings.getIcon("pdcPeas.file.preview")).append("\" alt=\"").append(settings.getString("GML.preview")).append("\" title=\"").append(settings.getString("GML.preview")).append("\"/>");
        }
        if (this.gsr.isViewable()) {
            result.append(" <img onclick=\"javascript:viewFile(this, '").append(this.gsr.getAttachmentId()).append("',").append(this.gsr.isVersioned()).append(",'").append(this.gsr.getInstanceId()).append("');\" class=\"view-file\" src=\"").append(settings.getIcon("pdcPeas.file.view")).append("\" alt=\"").append(settings.getString("GML.view")).append("\" title=\"").append(settings.getString("GML.view")).append("\"/>");
        }
        result.append("</div>");
        if (StringUtil.isDefined((String)sDescription)) {
            result.append("<div class=\"description\">").append(EncodeHelper.javaStringToHtmlParagraphe((String)sDescription)).append("</div>");
        }
        if (StringUtil.isDefined((String)extraInformation)) {
            result.append("<div class=\"extra\">");
            result.append(extraInformation);
            result.append("</div>");
        }
        if (this.sortValue == 7 && this.gsr.getHits() >= 0) {
            result.append("<div class=\"popularity\">").append(settings.getStringWithParam("pdcPeas.popularity", Integer.toString(this.gsr.getHits()))).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sCreationDate)) {
            result.append("<div class=\"creationDate\"> ").append(sCreationDate).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sCreatorName)) {
            result.append("<div class=\"creatorName\">").append(EncodeHelper.javaStringToHtmlString((String)sCreatorName)).append(" | </div>");
        }
        if (StringUtil.isDefined((String)serverName)) {
            result.append("<div class=\"serveurName\"> ").append(serverName).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sLocation)) {
            result.append("<div class=\"location\">").append(EncodeHelper.javaStringToHtmlString((String)sLocation)).append("</div>");
        }
        result.append("</div>");
        result.append("</li>");
        return result.toString();
    }

    private UserPreferences getUserPreferences() {
        return SilverpeasServiceProvider.getPersonalizationService().getUserSettings(this.getUserId());
    }

    private ResourcesWrapper getSettings() {
        if (this.settings == null) {
            String language = this.getUserPreferences().getLanguage();
            ResourceLocator messages = new ResourceLocator("org.silverpeas.pdcPeas.multilang.pdcBundle", language);
            this.settings = new ResourcesWrapper(messages, new ResourceLocator("org.silverpeas.pdcPeas.settings.pdcPeasIcons", ""), new ResourceLocator("org.silverpeas.pdcPeas.settings.pdcPeasSettings", ""), language);
        }
        return this.settings;
    }

    public void setSettings(ResourcesWrapper settings) {
        this.settings = settings;
    }
}

