/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.tabs;

import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import com.stratelia.webactiv.util.viewGenerator.html.tabs.Tab;
import com.stratelia.webactiv.util.viewGenerator.html.tabs.TabbedPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public abstract class AbstractTabbedPane
implements TabbedPane {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    private Vector<Collection<Tab>> tabLines = null;
    private int nbLines = 1;
    private int indentation = 0;

    @Override
    public void init(int nbLines) {
        Vector tabLines = new Vector(2, 1);
        for (int i = 1; i <= nbLines; ++i) {
            tabLines.add(new ArrayList());
        }
        this.nbLines = nbLines;
        this.tabLines = tabLines;
    }

    @Override
    public void addTab(String label, String action, boolean disabled) {
        Vector<Collection<Tab>> tabLines = this.getTabLines();
        Collection<Tab> tabs = tabLines.get(0);
        tabs.add(new Tab(label, action, disabled));
    }

    @Override
    public void addTab(String label, String action, boolean disabled, boolean enabled) {
        Vector<Collection<Tab>> tabLines = this.getTabLines();
        Collection<Tab> tabs = tabLines.get(0);
        tabs.add(new Tab(label, action, disabled, enabled));
    }

    @Override
    public void addTab(String label, String action, boolean disabled, int nbLines) {
        Vector<Collection<Tab>> tabLines = this.getTabLines();
        Collection<Tab> tabs = null;
        tabs = nbLines <= 0 ? tabLines.get(0) : tabLines.get(nbLines - 1);
        tabs.add(new Tab(label, action, disabled));
    }

    @Override
    public void addTab(String label, String action, boolean disabled, boolean enabled, int nbLines) {
        Vector<Collection<Tab>> tabLines = this.getTabLines();
        Collection<Tab> tabs = null;
        tabs = nbLines <= 0 ? tabLines.get(0) : tabLines.get(nbLines - 1);
        tabs.add(new Tab(label, action, disabled, enabled));
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    public Vector<Collection<Tab>> getTabLines() {
        return this.tabLines;
    }

    public int getNbLines() {
        return this.nbLines;
    }

    @Override
    public abstract String print();

    @Override
    public void setIndentationLeft() {
        this.indentation = 1;
    }

    public int getIndentation() {
        return this.indentation;
    }

    @Override
    public void setLevelRootImage(int level) {
    }
}

