/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.viewGenerator.html.window;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import com.stratelia.webactiv.util.viewGenerator.html.browseBars.BrowseBar;
import com.stratelia.webactiv.util.viewGenerator.html.operationPanes.OperationPane;
import com.stratelia.webactiv.util.viewGenerator.html.window.Window;
import java.util.List;
import org.silverpeas.core.admin.OrganisationController;

public abstract class AbstractWindow
implements Window {
    private BrowseBar browseBar = null;
    private OperationPane operationPane = null;
    private GraphicElementFactory gef = null;
    private String body = null;
    private String width = null;
    private boolean browserBarDisplayable = true;

    @Override
    public void init(GraphicElementFactory gef) {
        this.gef = gef;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public void addBody(String body) {
        this.body = body;
    }

    public GraphicElementFactory getGEF() {
        return this.gef;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    @Override
    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        if (this.width == null) {
            this.width = "100%";
        }
        return this.width;
    }

    @Override
    public OperationPane getOperationPane() {
        if (this.operationPane == null) {
            this.operationPane = this.getGEF().getOperationPane();
            if (GeneralPropertiesManager.getBoolean((String)"AdminFromComponentEnable", (boolean)true) && StringUtil.isDefined((String)this.getGEF().getComponentId())) {
                this.addOperationToSetupComponent();
            }
        }
        return this.operationPane;
    }

    private void addOperationToSetupComponent() {
        MainSessionController msc = this.getGEF().getMainSessionController();
        if (msc.getOrganisationController().isComponentManageable(this.getGEF().getComponentId(), msc.getUserId()) && this.getGEF().isComponentMainPage()) {
            String label = GeneralPropertiesManager.getGeneralMultilang((String)this.getGEF().getMultilang().getLanguage()).getString("GML.operations.setupComponent");
            String url = URLManager.getApplicationURL() + "/R" + "jobStartPagePeas" + "/jsp/SetupComponent?ComponentId=" + this.getGEF().getComponentId();
            this.operationPane.addOperation("useless", label, url);
            this.operationPane.addLine();
        }
    }

    @Override
    public BrowseBar getBrowseBar() {
        if (this.browseBar == null) {
            this.browseBar = this.getGEF().getBrowseBar();
        }
        return this.browseBar;
    }

    public String getContextualDiv() {
        String spaceIds = "";
        String componentId = this.gef.getComponentId();
        OrganisationController oc = this.gef.getMainSessionController().getOrganisationController();
        if (StringUtil.isDefined((String)componentId)) {
            List spaces = oc.getSpacePathToComponent(componentId);
            for (SpaceInst spaceInst : spaces) {
                String spaceId = spaceInst.getId();
                if (!spaceId.startsWith("WA")) {
                    spaceId = "WA" + spaceId;
                }
                spaceIds = spaceIds + spaceId + " ";
            }
        }
        if (StringUtil.isDefined((String)spaceIds)) {
            ComponentInstLight component = oc.getComponentInstLight(componentId);
            return "<div class=\"" + spaceIds + component.getName() + " " + componentId + "\">";
        }
        return null;
    }

    @Override
    public boolean isBrowseBarVisible() {
        return this.browserBarDisplayable;
    }

    @Override
    public void setBrowseBarVisibility(boolean browseBarVisible) {
        this.browserBarDisplayable = browseBarVisible;
    }

    private String getWelcomeMessage(ComponentInstLight component, String language) {
        String message = null;
        String fileName = null;
        try {
            fileName = "welcome_" + language;
            message = this.getSilverpeasTemplate().applyFileTemplateOnComponent(component.getName(), fileName);
        }
        catch (Exception e) {
            SilverTrace.info((String)"viewgenerator", (String)"AbstractWindow.getWelcomeMessage", (String)"CANT_FIND_TEMPLATE", (String)("fileName = " + fileName + ", component = " + component.getName()));
        }
        if (!StringUtil.isDefined((String)message)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        String title = this.getGEF().getMultilang().getString("GEF.welcome.title");
        sb.append("<div id=\"welcome-message\" title=\"").append(title).append("\" style=\"display: none;\">\n");
        sb.append("<p>\n");
        sb.append(message);
        sb.append("</p>\n");
        sb.append("</div>\n");
        return sb.toString();
    }

    private SilverpeasTemplate getSilverpeasTemplate() {
        return SilverpeasTemplateFactory.createSilverpeasTemplateOnComponents();
    }

    private String getWelcomeMessageScript(ComponentInstLight component) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var welcomeMessageAlreadyShown = false;\n");
        sb.append("$(function() {\n");
        sb.append("var welcomeMessageCookieName = \"Silverpeas_").append(component.getName()).append("_WelcomeMessage\";\n");
        sb.append("if (!welcomeMessageAlreadyShown && \"IKnowIt\" != $.cookie(welcomeMessageCookieName)) {\n");
        sb.append("if (!welcomeMessageAlreadyShown) {\n");
        sb.append("welcomeMessageAlreadyShown = true;\n");
        sb.append("$('#welcome-message').dialog({\n");
        sb.append("modal: true,\n");
        sb.append("resizable: false,\n");
        sb.append("width: 400,\n");
        sb.append("dialogClass: 'help-modal-message',\n");
        sb.append("buttons: {\n");
        sb.append("\"").append(this.getGEF().getMultilang().getString("GEF.welcome.button.ok")).append("\": function() {\n");
        sb.append("$.cookie(welcomeMessageCookieName, \"IKnowIt\", { expires: 3650, path: '/' });\n");
        sb.append("$(this).dialog(\"close\");\n");
        sb.append(" }, \n");
        sb.append("\"").append(this.getGEF().getMultilang().getString("GEF.welcome.button.reminder")).append("\": function() {\n");
        sb.append(" $(this).dialog(\"close\");\n");
        sb.append(" }\n");
        sb.append("}\n");
        sb.append("});\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append(");\n");
        sb.append("</script>");
        return sb.toString();
    }

    public String displayWelcomeMessage() {
        String componentId;
        if (this.getGEF().isComponentMainPage() && StringUtil.isDefined((String)(componentId = this.getGEF().getComponentId()))) {
            StringBuilder sb = new StringBuilder(300);
            ComponentInstLight component = this.getGEF().getMainSessionController().getOrganisationController().getComponentInstLight(componentId);
            String language = this.getGEF().getMainSessionController().getFavoriteLanguage();
            if (component != null) {
                String message = this.getWelcomeMessage(component, language);
                if (message == null) {
                    return "";
                }
                sb.append(message);
                sb.append(this.getWelcomeMessageScript(component));
            }
            return sb.toString();
        }
        return "";
    }
}

