/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin;

import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletID;
import com.sun.portal.container.PortletLang;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletApp;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.PortletWindow;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreference;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreferenceRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryContextImpl;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryWriter;
import com.sun.portal.portletcontainer.common.PortletPreferencesUtility;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PreferenceDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SupportsDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.UserAttributeDescriptor;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContext;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContextAbstractFactory;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContextFactory;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import com.sun.portal.portletcontainer.warupdater.PortletWebAppUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class PortletRegistryGenerator
implements PortletRegistryTags {
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String WEB_XML = "web.xml";
    private static final String PORTLET_XML = "portlet.xml";
    private static final String SUN_PORTLET_XML = "sun-portlet.xml";
    private static final String DD_SUFFIX = "_portlet.xml";
    private static final String WAR_SUFFIX = ".war";
    private PortletsDescriptor portletsDescriptor;
    private PortletAppDescriptor portletAppDescriptor;
    private String portletAppName;
    private String warName;
    private Properties configProps = new Properties();
    private List portletAppElementList = new ArrayList();
    private List portletWindowElementList = new ArrayList();
    private List portletWindowPreferenceElementList = new ArrayList();
    private static Logger logger = Logger.getLogger("com.sun.portal.portletcontainer.admin", "org.silverpeas.portlets.PALogMessages");

    private InputStream getPortletXmlStream(JarFile jar) throws Exception {
        InputStream in = null;
        try {
            ZipEntry portletXMLEntry = jar.getEntry("WEB-INF/portlet.xml");
            in = jar.getInputStream(portletXMLEntry);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{jar.getName()};
            throw new PortletRegistryException("errorStreamRead", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new String[]{"WEB-INF/portlet.xml"};
            throw new PortletRegistryException("invalidWar", ex, tokens);
        }
        return in;
    }

    private List getWebAppRoles(JarFile jar) throws Exception {
        InputStream webXMLStream = null;
        List roles = new ArrayList();
        try {
            ZipEntry webXMLEntry = jar.getEntry("WEB-INF/web.xml");
            webXMLStream = jar.getInputStream(webXMLEntry);
            roles = PortletWebAppUpdater.getRoles((InputStream)webXMLStream);
        }
        catch (IOException ioe) {
            throw new PortletRegistryException("errorGettingRoles", ioe);
        }
        catch (Exception ex) {
            Object[] tokens = new String[]{"WEB-INF/web.xml"};
            throw new PortletRegistryException("invalidWar", ex, tokens);
        }
        finally {
            try {
                if (webXMLStream != null) {
                    webXMLStream.close();
                }
            }
            catch (IOException ignored) {}
        }
        return roles;
    }

    public void register(File updatedArchiveFile, String warFileLocation, Properties roleProperties, Properties userInfoProperties, PortletLang portletLang) throws Exception {
        JarFile jar = new JarFile(updatedArchiveFile);
        String configFileLocation = PortletRegistryHelper.getConfigFileLocation();
        DeploymentDescriptorReader ddReader = new DeploymentDescriptorReader(configFileLocation);
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        logger.log(Level.FINE, "PSPL_CSPPAM0006", registryLocation);
        this.warName = updatedArchiveFile.getName();
        logger.log(Level.FINE, "PSPL_CSPPAM0005", this.warName);
        this.portletAppName = this.warName.substring(0, this.warName.lastIndexOf(46));
        InputStream portletXmlStream = null;
        try {
            portletXmlStream = this.getPortletXmlStream(jar);
            this.portletAppDescriptor = ddReader.loadPortletAppDescriptor(this.portletAppName, portletXmlStream);
            ddReader.processDeployPortletExtensionDescriptor(updatedArchiveFile, configFileLocation);
        }
        catch (DeploymentDescriptorException dde) {
            Object[] tokens = new Object[]{dde.toString()};
            throw new PortletRegistryException("errorReadingPortletDD", tokens);
        }
        finally {
            try {
                if (portletXmlStream != null) {
                    portletXmlStream.close();
                }
            }
            catch (IOException ignored) {}
        }
        this.portletsDescriptor = this.portletAppDescriptor.getPortletsDescriptor();
        this.createPortletRegistryElements(roleProperties, userInfoProperties, this.getWebAppRoles(jar), portletLang);
        PortletAppRegistryWriter portletAppRegistryWriter = new PortletAppRegistryWriter(registryLocation);
        ((PortletRegistryWriter)portletAppRegistryWriter).appendDocument(this.portletAppElementList);
        logger.log(Level.FINE, "PSPL_CSPPAM0010", "portlet-app-registry.xml");
        PortletWindowRegistryWriter portletWindowRegistryWriter = new PortletWindowRegistryWriter(registryLocation, null);
        ((PortletRegistryWriter)portletWindowRegistryWriter).appendDocument(this.portletWindowElementList);
        logger.log(Level.FINE, "PSPL_CSPPAM0010", "portlet-window-registry.xml");
        PortletWindowPreferenceRegistryWriter portletWindowPreferenceRegistryWriter = new PortletWindowPreferenceRegistryWriter(registryLocation, null);
        ((PortletRegistryWriter)portletWindowPreferenceRegistryWriter).appendDocument(this.portletWindowPreferenceElementList);
        logger.log(Level.FINE, "PSPL_CSPPAM0010", "portlet-window-preference-registry.xml");
        try {
            portletXmlStream = this.getPortletXmlStream(jar);
            this.copyPortletXML(portletXmlStream, warFileLocation, this.portletAppName);
        }
        catch (IOException ioe) {
            throw new PortletRegistryException("errorSavingFile", ioe);
        }
        finally {
            try {
                if (portletXmlStream != null) {
                    portletXmlStream.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public String getPortletAppName() {
        return this.portletAppName;
    }

    public String getPortletWarName() {
        return this.warName;
    }

    private void createPortletRegistryElements(Properties roleProperties, Properties userInfoProperties, List webAppRoles, PortletLang portletLang) throws PortletRegistryException {
        List portletDescriptors = this.portletsDescriptor.getPortletDescriptors();
        int size = portletDescriptors.size();
        if (size == 0) {
            Object[] tokens = new Object[]{PORTLET_XML};
            throw new PortletRegistryException("invalidWar", tokens);
        }
        for (int i2 = 0; i2 < portletDescriptors.size(); ++i2) {
            String tgType;
            List constrainedPortlets;
            SecurityConstraintDescriptor securityConstraintDescriptor;
            List supportedLocales;
            Map descriptionMap;
            Map map;
            List supportsDescriptors;
            List securityRoleRefDescriptors;
            String value;
            PortletApp portletApp = new PortletApp();
            PortletWindow portletWindow = new PortletWindow();
            PortletWindowPreference portletWindowPreference = new PortletWindowPreference();
            this.portletAppElementList.add(portletApp);
            this.portletWindowElementList.add(portletWindow);
            this.portletWindowPreferenceElementList.add(portletWindowPreference);
            PortletDescriptor portletDescriptor = (PortletDescriptor)portletDescriptors.get(i2);
            String portletName = portletDescriptor.getPortletName();
            logger.log(Level.FINE, "PSPL_CSPPAM0007", portletName);
            PortletID portletID = new PortletID(this.getPortletAppName(), portletName);
            String portletIDValue = portletID.toString();
            logger.log(Level.FINEST, "PSPL_CSPPAM0008", portletIDValue);
            portletApp.setPortletName(portletIDValue);
            portletApp.setName(portletIDValue);
            portletApp.setStringProperty("archiveName", this.getPortletWarName());
            portletApp.setStringProperty("archiveType", this.getPortletWarName().substring(this.getPortletWarName().lastIndexOf(46) + 1));
            portletWindow.setPortletName(portletIDValue);
            portletWindow.setName(portletIDValue);
            portletWindow.setRemote(Boolean.FALSE.toString());
            portletWindow.setLang(portletLang.toString());
            portletWindowPreference.setPortletName(portletIDValue);
            portletWindowPreference.setName(portletIDValue);
            EntityID entityID = new EntityID(portletID);
            String entityIDPrefix = entityID.getPrefix();
            logger.log(Level.FINE, "PSPL_CSPPAM0009", entityIDPrefix);
            portletWindow.setStringProperty("entityIDPrefix", entityIDPrefix);
            PortletInfoDescriptor portletInfo = portletDescriptor.getPortletInfoDescriptor();
            String title2 = portletName;
            String shortTitle = null;
            List keywords = null;
            if (portletInfo != null) {
                title2 = portletInfo.getTitle();
                shortTitle = portletInfo.getShortTitle();
                keywords = portletInfo.getKeywords();
            }
            portletApp.setStringProperty("title", title2);
            portletApp.setStringProperty("shortTitle", shortTitle);
            portletApp.setCollectionProperty("keywords", keywords);
            portletWindow.setStringProperty("title", title2);
            portletWindow.setStringProperty("visible", "false");
            String description = "";
            if (portletDescriptor.getDescription() != null) {
                description = portletDescriptor.getDescription();
            }
            portletApp.setStringProperty("description", description);
            PortletPreferencesDescriptor ppd = portletDescriptor.getPortletPreferencesDescriptor();
            List preferenceDescriptors = null;
            if (ppd != null && (preferenceDescriptors = ppd.getPreferenceDescriptors()) != null && !preferenceDescriptors.isEmpty()) {
                HashMap<String, String> preferences = new HashMap<String, String>();
                HashMap<String, String> preferencesReadOnly = new HashMap<String, String>();
                for (int j = 0; j < preferenceDescriptors.size(); ++j) {
                    PreferenceDescriptor prd = (PreferenceDescriptor)preferenceDescriptors.get(j);
                    String string = prd.getPrefName();
                    List values = prd.getPrefValues();
                    value = PortletPreferencesUtility.getPreferenceString((List)values);
                    preferences.put(string, value);
                    String string2 = String.valueOf(prd.getReadOnly());
                    preferencesReadOnly.put(string, string2);
                }
                portletWindowPreference.setCollectionProperty("prefProperties", preferences);
                portletWindowPreference.setCollectionProperty("prefReadOnly", preferencesReadOnly);
            }
            if ((securityRoleRefDescriptors = portletDescriptor.getSecurityRoleRefDescriptors()) != null && securityRoleRefDescriptors.size() > 0) {
                ArrayList<String> roles = new ArrayList<String>();
                for (int k = 0; k < securityRoleRefDescriptors.size(); ++k) {
                    SecurityRoleRefDescriptor srd = (SecurityRoleRefDescriptor)securityRoleRefDescriptors.get(k);
                    String string = srd.getRoleLink();
                    String portletRole = srd.getRoleName();
                    if (webAppRoles.contains(string)) {
                        roles.add(string);
                        continue;
                    }
                    if (webAppRoles.contains(portletRole)) {
                        roles.add(portletRole);
                        continue;
                    }
                    Object[] tokens = new Object[]{portletRole};
                    throw new PortletRegistryException("errorRoleValidation", tokens);
                }
                HashMap<String, String> roleMap = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : roleProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    roleMap.put(key, value);
                }
                if (!roles.isEmpty()) {
                    for (String string : roles) {
                        if (roleMap.containsValue(string)) continue;
                        Object[] tokens = new Object[]{string};
                        throw new PortletRegistryException("errorReverseRoleMapping", tokens);
                    }
                }
                if (!roleMap.isEmpty()) {
                    portletApp.setCollectionProperty("roleMap", roleMap);
                }
                boolean hasRoleDescriptions = false;
                HashMap hashMap = new HashMap();
                for (int k = 0; k < securityRoleRefDescriptors.size(); ++k) {
                    SecurityRoleRefDescriptor srd = (SecurityRoleRefDescriptor)securityRoleRefDescriptors.get(k);
                    Map map2 = srd.getDescriptionMap();
                    if (map2 == null || map2.size() <= 0) continue;
                    hasRoleDescriptions = true;
                    String name = srd.getRoleName();
                    if (!roles.contains(name)) {
                        Object[] tokens = new String[]{srd.getRoleName()};
                        throw new PortletRegistryException("errorReverseRoleMapping", tokens);
                    }
                    HashMap<String, String> descriptions = new HashMap<String, String>();
                    for (Map.Entry entry : map2.entrySet()) {
                        String lang = (String)entry.getKey();
                        String desc = (String)entry.getValue();
                        descriptions.put(lang, desc);
                    }
                    hashMap.put(name, descriptions);
                }
                if (hasRoleDescriptions) {
                    portletApp.setCollectionProperty("roleDescriptions", hashMap);
                }
            }
            if (userInfoProperties != null && !userInfoProperties.isEmpty()) {
                HashMap<String, String> userInfoMap = new HashMap<String, String>();
                Set<Object> keys = userInfoProperties.keySet();
                for (String string : keys) {
                    String value2 = userInfoProperties.getProperty(string);
                    userInfoMap.put(string, value2);
                }
                portletApp.setCollectionProperty("userInfoMap", userInfoMap);
            } else {
                List userAttrDescriptors = this.portletAppDescriptor.getUserAttributeDescriptors();
                if (userAttrDescriptors != null && userAttrDescriptors.size() > 0) {
                    HashMap<String, String> userInfoMap = new HashMap<String, String>();
                    for (UserAttributeDescriptor userAttributeDescriptor : userAttrDescriptors) {
                        String attrName = userAttributeDescriptor.getName();
                        userInfoMap.put(attrName, attrName);
                    }
                    if (userAttrDescriptors.size() > 0) {
                        portletApp.setCollectionProperty("userInfoMap", userInfoMap);
                    }
                }
            }
            boolean hasUserAttrDescriptions = false;
            List userAttrDescriptors = this.portletAppDescriptor.getUserAttributeDescriptors();
            if (userAttrDescriptors != null && userAttrDescriptors.size() > 0) {
                HashMap userAttrDescriptions = new HashMap();
                for (UserAttributeDescriptor uad : userAttrDescriptors) {
                    Map userAttrDescMap = uad.getDescriptionMap();
                    if (userAttrDescMap.size() <= 0) continue;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (Map.Entry entry : userAttrDescMap.entrySet()) {
                        String lang = (String)entry.getKey();
                        String desc = (String)entry.getValue();
                        hashMap.put(lang, desc);
                    }
                    userAttrDescriptions.put(uad.getName(), hashMap);
                }
                if (hasUserAttrDescriptions) {
                    portletApp.setCollectionProperty("userInfoDescriptions", userAttrDescriptions);
                }
            }
            if ((supportsDescriptors = portletDescriptor.getSupportsDescriptors()) != null && supportsDescriptors != null) {
                HashMap<String, List> hashMap = new HashMap<String, List>();
                ArrayList<String> contentTypes = new ArrayList<String>();
                for (SupportsDescriptor supportsDescriptor : supportsDescriptors) {
                    String mimeType = supportsDescriptor.getMimeType();
                    contentTypes.add(mimeType);
                    List portletModes = supportsDescriptor.getPortletModes();
                    hashMap.put(mimeType, portletModes);
                }
                portletApp.setCollectionProperty("supportsMap", hashMap);
                portletApp.setCollectionProperty("supportedContentTypes", contentTypes);
            }
            if ((map = portletDescriptor.getDisplayNameMap()) != null) {
                HashMap<String, String> displayNames = new HashMap<String, String>();
                for (Map.Entry entry : map.entrySet()) {
                    String lang = (String)entry.getKey();
                    String dn = (String)entry.getValue();
                    displayNames.put(lang, dn);
                }
                portletApp.setCollectionProperty("displayNameMap", displayNames);
            }
            if ((descriptionMap = portletDescriptor.getDescriptionMap()) != null) {
                HashMap<String, String> descriptions = new HashMap<String, String>();
                for (Map.Entry entry : descriptionMap.entrySet()) {
                    String lang = (String)entry.getKey();
                    String desc = (String)entry.getValue();
                    descriptions.put(lang, desc);
                }
                portletApp.setCollectionProperty("descriptionMap", descriptions);
            }
            if ((supportedLocales = portletDescriptor.getSupportedLocales()) != null) {
                portletApp.setCollectionProperty("supportedLocales", supportedLocales);
            }
            if ((securityConstraintDescriptor = this.portletAppDescriptor.getSecurityConstraintDescriptor()) == null || (constrainedPortlets = securityConstraintDescriptor.getConstrainedPortlets()) == null || !constrainedPortlets.contains(portletName) || (tgType = securityConstraintDescriptor.getTransportGuaranteeType()) == null || tgType.length() <= 0) continue;
            portletApp.setStringProperty("transportGuarantee", tgType);
        }
    }

    public Boolean unregister(String configFileLocation, String warFileLocation, String warName) throws Exception {
        File warFile = new File(warFileLocation, warName + WAR_SUFFIX);
        String ddName = warName + DD_SUFFIX;
        InputStream in = null;
        try {
            File portletFile = new File(warFileLocation, ddName);
            if (!portletFile.exists()) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PSPL_CSPPAM0034", portletFile.getPath());
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            in = new FileInputStream(portletFile);
            Properties properties = new Properties();
            properties.put("portletXML.validate", "false");
            DeploymentDescriptorReader ddReader = new DeploymentDescriptorReader(properties);
            this.portletAppDescriptor = ddReader.loadPortletAppDescriptor(warName, in);
            ddReader.processUndeployPortletExtensionDescriptor(warFile, configFileLocation);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{warFileLocation + File.separator + ddName, warName + WAR_SUFFIX};
            throw new PortletRegistryException("errorStreamReadWhileUndeploy", ioe, tokens);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ignoreit) {}
        }
        this.portletAppName = warName;
        this.portletsDescriptor = this.portletAppDescriptor.getPortletsDescriptor();
        List portletDescriptors = this.portletsDescriptor.getPortletDescriptors();
        PortletRegistryContext portletRegistryContext = this.getPortletRegistryContext();
        for (int i2 = 0; i2 < portletDescriptors.size(); ++i2) {
            PortletDescriptor portletDescriptor = (PortletDescriptor)portletDescriptors.get(i2);
            String portletName = portletDescriptor.getPortletName();
            logger.log(Level.FINE, "PSPL_CSPPAM0007", portletName);
            PortletID portletID = new PortletID(this.getPortletAppName(), portletName);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSPL_CSPPAM0008", portletID);
            }
            portletRegistryContext.removePortlet(portletID.toString());
        }
        return Boolean.TRUE;
    }

    public void removePortletWar(String warFileLocation, String warName) throws Exception {
        String ddName = warName + DD_SUFFIX;
        File portletFile = new File(warFileLocation, ddName);
        boolean portletFileRemoved = portletFile.delete();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_CSPPAM0018", new String[]{portletFile.getAbsolutePath(), String.valueOf(portletFileRemoved)});
        }
        File warFile = new File(warFileLocation, warName + WAR_SUFFIX);
        boolean warFileRemoved = warFile.delete();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_CSPPAM0019", new String[]{warFile.getAbsolutePath(), String.valueOf(warFileRemoved)});
        }
    }

    public void registerRemote(String portletWindowName, String consumerId, String producerEntityId, String portletHandle, String portletId) throws Exception {
        PortletWindow portletWindow = new PortletWindow();
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        portletWindow.setName(portletWindowName);
        portletWindow.setPortletName(portletId);
        portletWindow.setRemote(Boolean.TRUE.toString());
        portletWindow.setStringProperty("consumerId", consumerId);
        portletWindow.setStringProperty("producerEntityID", producerEntityId);
        portletWindow.setStringProperty("portletHandle", portletHandle);
        portletWindow.setStringProperty("portletID", portletId);
        this.portletWindowElementList.add(portletWindow);
        PortletWindowRegistryWriter portletWindowRegistryWriter = new PortletWindowRegistryWriter(registryLocation, null);
        ((PortletRegistryWriter)portletWindowRegistryWriter).appendDocument(this.portletWindowElementList);
        logger.log(Level.FINE, "PSPL_CSPPAM0010", "portlet-window-registry.xml");
        PortletWindowPreference portletWindowPreference = new PortletWindowPreference();
        this.portletWindowPreferenceElementList.add(portletWindowPreference);
        portletWindowPreference.setPortletName(portletId);
        portletWindowPreference.setName(portletWindowName);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("portletHandle", portletHandle);
        portletWindowPreference.setCollectionProperty("prefProperties", preferences);
        PortletWindowPreferenceRegistryWriter portletWindowPreferenceRegistryWriter = new PortletWindowPreferenceRegistryWriter(registryLocation, null);
        ((PortletRegistryWriter)portletWindowPreferenceRegistryWriter).appendDocument(this.portletWindowPreferenceElementList);
        logger.log(Level.FINE, "PSPL_CSPPAM0010", "portlet-window-preference-registry.xml");
    }

    public void unregisterRemote(String portletWindowName) throws Exception {
        PortletWindowRegistryContextImpl pwrContext = new PortletWindowRegistryContextImpl(null);
        PortletRegistryContext portletRegistryContext = this.getPortletRegistryContext();
        portletRegistryContext.removePortletWindow(portletWindowName);
    }

    private void copyPortletXML(InputStream portletXMLStream, String warFileLocation, String portletAppName) throws Exception {
        String destFile = warFileLocation + "/" + portletAppName + DD_SUFFIX;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = portletXMLStream.read(buffer, 0, buffer.length)) != -1);
        }
        catch (IOException ioe) {
            throw new PortletRegistryException("errorStreamRead", ioe);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        logger.log(Level.FINE, "PSPL_CSPPAM0011", destFile);
    }

    private PortletRegistryContext getPortletRegistryContext() throws PortletRegistryException {
        PortletRegistryContextAbstractFactory afactory = new PortletRegistryContextAbstractFactory();
        PortletRegistryContextFactory factory = afactory.getPortletRegistryContextFactory();
        return factory.getPortletRegistryContext();
    }
}

