/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.deployment;

import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployer;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployerException;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployerUtil;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlassFishWebAppDeployer
implements WebAppDeployer {
    private static Logger logger = Logger.getLogger(GlassFishWebAppDeployer.class.getPackage().getName(), "org.silverpeas.portlets.PALogMessages");
    private static final String GLASSFISH_DOMAIN = "DOMAIN_ROOT";
    private String autoDeployDirectory;

    public GlassFishWebAppDeployer() throws Exception {
        String portletContainerConfigDir = PortletRegistryHelper.getConfigFileLocation();
        if (portletContainerConfigDir != null) {
            FileInputStream config = null;
            String configFileName = portletContainerConfigDir + File.separator + "pcenv.conf";
            try {
                config = new FileInputStream(configFileName);
                Properties properties = new Properties();
                properties.load(config);
                String domainDirectory = properties.getProperty(GLASSFISH_DOMAIN);
                this.autoDeployDirectory = domainDirectory + File.separator + "autodeploy";
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSPL_CSPPAM0025", e);
                throw e;
            }
            finally {
                try {
                    if (config != null) {
                        config.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }

    @Override
    public boolean deploy(String warFileName) throws WebAppDeployerException {
        boolean success = false;
        String warFileLocation = null;
        try {
            warFileLocation = PortletRegistryHelper.getWarFileLocation();
        }
        catch (PortletRegistryException pre) {
            // empty catch block
        }
        String warName = PortletWarUpdaterUtil.getWarName((String)warFileName);
        try {
            if (this.autoDeployDirectory != null) {
                String warFile = warFileLocation + File.separator + warName;
                WebAppDeployerUtil.copyFile(warFile, this.autoDeployDirectory + File.separator + warName);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "PSPL_CSPPAM0020", new String[]{warFile, this.autoDeployDirectory});
                }
                success = true;
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "PSPL_CSPPAM0021", ioe);
            throw new WebAppDeployerException(ioe.getMessage(), ioe);
        }
        return success;
    }

    @Override
    public boolean undeploy(String warFileName) throws WebAppDeployerException {
        boolean success = false;
        try {
            if (this.autoDeployDirectory != null) {
                int index = warFileName.indexOf(".war");
                if (index == -1) {
                    warFileName = warFileName + ".war";
                }
                String warFile = this.autoDeployDirectory + File.separator + warFileName;
                File file = new File(warFile);
                success = file.delete();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "PSPL_CSPPAM0022", new String[]{warFile, String.valueOf(success)});
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSPL_CSPPAM0023", e);
            throw new WebAppDeployerException(e.getMessage(), e);
        }
        return success;
    }
}

