/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.deployment;

import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class WebAppDeployerFactory {
    private static final WebAppDeployerFactory factory = new WebAppDeployerFactory();
    private WebAppDeployer manager = null;
    private static final String DEPLOYMENT_MANAGER_CLASS = "deployment.manager.class";
    private static final String DEFAULT_DEPLOYMENT_MANAGER_CLASS = "com.sun.portal.portletadmin.deployment.DefaultWebAppDeployer";
    private static Logger logger = Logger.getLogger(WebAppDeployerFactory.class.getPackage().getName(), "org.silverpeas.portlets.PALogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebAppDeployerFactory() {
        FileInputStream config = null;
        try {
            String portletContainerConfigDir = PortletRegistryHelper.getConfigFileLocation();
            if (portletContainerConfigDir != null) {
                String configFileName = portletContainerConfigDir + File.separator + "pcenv.conf";
                config = new FileInputStream(configFileName);
                Properties properties = new Properties();
                properties.load(config);
                String deploymentManagerClass = properties.getProperty(DEPLOYMENT_MANAGER_CLASS);
                this.manager = (WebAppDeployer)Class.forName(deploymentManagerClass).newInstance();
            }
        }
        catch (Throwable t) {
            System.out.println("Exception: " + t.toString() + ". Using DefaultWebAppDeployer");
            try {
                this.manager = (WebAppDeployer)Class.forName(DEFAULT_DEPLOYMENT_MANAGER_CLASS).newInstance();
            }
            catch (Throwable t1) {
                System.out.println("Exception initializing DefaultWebAppDeployer: " + t1.toString());
            }
        }
        finally {
            if (config != null) {
                try {
                    config.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static WebAppDeployerFactory getInstance() {
        return factory;
    }

    public WebAppDeployer getDeploymentManager() {
        return this.manager;
    }
}

