/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPortletRegistryElement
implements PortletRegistryTags,
PortletRegistryElement {
    private String name;
    private String userName;
    private String portletName;
    private String isRemote = Boolean.FALSE.toString();
    private String lang;
    private Map collectionMapTable = new HashMap();
    private Map collectionStringTable = new HashMap();

    @Override
    public void setCollectionProperty(String key, Map values) {
        this.setMap(key, values);
    }

    @Override
    public Map getCollectionProperty(String key) {
        return this.getMapValue(key);
    }

    @Override
    public void setCollectionProperty(String key, List values) {
        this.setList(key, values);
    }

    @Override
    public void setStringProperty(String key, String value) {
        this.setString(key, value);
    }

    @Override
    public String getStringProperty(String key) {
        return this.getStringValue(key);
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.trim().length() == 0) {
            return this.getPortletName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPortletName() {
        return this.portletName;
    }

    @Override
    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String getUserName() {
        if (this.userName == null) {
            return "default";
        }
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getRemote() {
        return this.isRemote;
    }

    @Override
    public void setRemote(String isRemote) {
        this.isRemote = isRemote;
    }

    private void setList(String key, List values) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (values != null) {
            int size = values.size();
            for (int i2 = 0; i2 < size; ++i2) {
                String s = (String)values.get(i2);
                m.put(s, s);
            }
        }
        this.setMap(key, m);
    }

    private void setMap(String key, Map values) {
        this.collectionMapTable.put(key, values);
    }

    private void setString(String key, String value) {
        this.collectionStringTable.put(key, value);
    }

    private Map getMapValue(String key) {
        return (Map)this.collectionMapTable.get(key);
    }

    private String getStringValue(String key) {
        return (String)this.collectionStringTable.get(key);
    }

    protected Map getMapCollectionTable() {
        return this.collectionMapTable;
    }

    protected Map getStringCollectionTable() {
        return this.collectionStringTable;
    }

    protected void populateValues(Element rootTag) {
        Element propertiesTag = XMLDocumentHelper.getChildElement(rootTag, "Properties");
        List tags = XMLDocumentHelper.createElementList(propertiesTag);
        int numOfTags = tags.size();
        for (int j = 0; j < numOfTags; ++j) {
            Element tag = (Element)tags.get(j);
            String tagName = tag.getTagName();
            Map attributes = XMLDocumentHelper.createAttributeTable(tag);
            String name = (String)attributes.get("name");
            if (tagName.equals("String")) {
                this.setStringProperty(name, (String)attributes.get("value"));
                continue;
            }
            if (!tagName.equals("Collection")) continue;
            List innerTags = XMLDocumentHelper.createElementList(tag);
            int numOfInnerTags = innerTags.size();
            HashMap<String, Object> mapValues = new HashMap<String, Object>();
            for (int k = 0; k < numOfInnerTags; ++k) {
                String innerName;
                Element innerTag = (Element)innerTags.get(k);
                String innerTagName = innerTag.getTagName();
                if (innerTagName.equals("String")) {
                    Map stringAttributes = XMLDocumentHelper.createAttributeTable(innerTag);
                    innerName = (String)stringAttributes.get("name");
                    String innerValue = (String)stringAttributes.get("value");
                    if (innerName == null) {
                        mapValues.put(innerValue, innerValue);
                        continue;
                    }
                    mapValues.put(innerName, innerValue);
                    continue;
                }
                if (!innerTagName.equals("Collection")) continue;
                Map innerAttributes = XMLDocumentHelper.createAttributeTable(innerTag);
                innerName = (String)innerAttributes.get("name");
                List stringTags = XMLDocumentHelper.createElementList(innerTag);
                int numOfStringTags = stringTags.size();
                ArrayList listValues = new ArrayList();
                for (int l = 0; l < numOfStringTags; ++l) {
                    Element stringTag = (Element)stringTags.get(l);
                    Map stringAttributes = XMLDocumentHelper.createAttributeTable(stringTag);
                    listValues.add(stringAttributes.get("value"));
                }
                mapValues.put(innerName, listValues);
            }
            this.setCollectionProperty(name, mapValues);
        }
    }

    protected void create(Document document, Element propertiesTag) {
        String value;
        String name;
        Map stringTags = this.getStringCollectionTable();
        Set mappings = stringTags.entrySet();
        for (Map.Entry me : mappings) {
            name = (String)me.getKey();
            value = (String)me.getValue();
            if (value == null || value.trim().length() == 0) continue;
            Element stringTag = XMLDocumentHelper.createElement(document, "String");
            stringTag.setAttribute("name", name);
            stringTag.setAttribute("value", value);
            propertiesTag.appendChild(stringTag);
        }
        Map collectionTags = this.getMapCollectionTable();
        mappings = collectionTags.entrySet();
        for (Map.Entry me : mappings) {
            name = (String)me.getKey();
            Map values = (Map)me.getValue();
            Set keys = values.entrySet();
            Iterator keysItr = keys.iterator();
            if (!keysItr.hasNext()) continue;
            Element collectionTag = XMLDocumentHelper.createElement(document, "Collection");
            collectionTag.setAttribute("name", name);
            propertiesTag.appendChild(collectionTag);
            while (keysItr.hasNext()) {
                Element innerCollectionTag;
                Map.Entry entry = keysItr.next();
                String key = (String)entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof String) {
                    value = (String)obj;
                    this.createStringTag(document, collectionTag, key, value);
                    continue;
                }
                if (obj instanceof List) {
                    List innerValuesList = (List)obj;
                    innerCollectionTag = XMLDocumentHelper.createElement(document, "Collection");
                    innerCollectionTag.setAttribute("name", key);
                    collectionTag.appendChild(innerCollectionTag);
                    int innerValuesListSize = innerValuesList.size();
                    for (int i2 = 0; i2 < innerValuesListSize; ++i2) {
                        value = (String)innerValuesList.get(i2);
                        this.createStringTag(document, innerCollectionTag, value, value);
                    }
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                Map innerValuesMap = (Map)obj;
                Set innerKeys = values.keySet();
                Iterator innerkeysItr = innerKeys.iterator();
                innerCollectionTag = XMLDocumentHelper.createElement(document, "Collection");
                innerCollectionTag.setAttribute("name", key);
                collectionTag.appendChild(innerCollectionTag);
                while (innerkeysItr.hasNext()) {
                    key = (String)innerkeysItr.next();
                    value = (String)innerValuesMap.get(key);
                    this.createStringTag(document, innerCollectionTag, key, value);
                }
            }
        }
    }

    private void createStringTag(Document document, Element collectionTag, String key, String value) {
        Element stringTag = XMLDocumentHelper.createElement(document, "String");
        if (key.equals(value)) {
            stringTag.setAttribute("value", value);
        } else {
            stringTag.setAttribute("name", key);
            stringTag.setAttribute("value", value);
        }
        collectionTag.appendChild(stringTag);
    }
}

