/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.registry.PortletApp;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletAppRegistry
implements PortletRegistryTags,
PortletRegistryObject {
    private String version;
    private Map portletAppTable = new LinkedHashMap();
    private List portletAppList = new ArrayList();

    @Override
    public void read(Document document) throws PortletRegistryException {
        Element root = PortletRegistryHelper.getRootElement(document);
        if (root != null) {
            this.populate(root);
        }
    }

    @Override
    public void addRegistryElement(PortletRegistryElement portletApp) {
        this.portletAppTable.put(portletApp.getName(), portletApp);
        this.portletAppList.add(portletApp);
    }

    @Override
    public PortletRegistryElement getRegistryElement(String name) {
        return (PortletRegistryElement)this.portletAppTable.get(name);
    }

    @Override
    public List getRegistryElements() {
        return this.portletAppList;
    }

    @Override
    public boolean removeRegistryElement(PortletRegistryElement portletApp) {
        this.portletAppTable.remove(portletApp.getName());
        return this.portletAppList.remove(portletApp);
    }

    private Map getPortletAppTable() {
        return this.portletAppTable;
    }

    private void populate(Element root) {
        Map portletAppRegistryAttributes = XMLDocumentHelper.createAttributeTable(root);
        this.setVersion((String)portletAppRegistryAttributes.get("version"));
        List portletAppTags = XMLDocumentHelper.createElementList(root);
        int numOfPortletAppTags = portletAppTags.size();
        for (int i2 = 0; i2 < numOfPortletAppTags; ++i2) {
            Element portletAppTag = (Element)portletAppTags.get(i2);
            PortletApp portletApp = new PortletApp();
            portletApp.populateValues(portletAppTag);
            this.addRegistryElement(portletApp);
        }
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void write(Document document) {
        Element rootTag = XMLDocumentHelper.createElement(document, "PortletAppRegistry");
        rootTag.setAttribute("version", this.getVersion());
        document.appendChild(rootTag);
        Collection collection = this.getPortletAppTable().values();
        for (PortletApp portletApp : collection) {
            portletApp.create(document, rootTag);
        }
    }
}

