/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.PortletRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletApp;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryReader;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryWriter;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PortletAppRegistryContextImpl
implements PortletAppRegistryContext {
    PortletRegistryObject portletAppRegistry;

    public PortletAppRegistryContextImpl() throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        PortletAppRegistryReader portletAppRegistryReader = new PortletAppRegistryReader(registryLocation);
        this.portletAppRegistry = portletAppRegistryReader.readDocument();
    }

    @Override
    public List getMarkupTypes(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map map = portletRegistryElement.getCollectionProperty("supportedContentTypes");
        List markupTypes = null;
        if (map != null) {
            markupTypes = this.mapValuesToList(map);
        }
        return markupTypes;
    }

    @Override
    public String getDescription(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map map = portletRegistryElement.getCollectionProperty("descriptionMap");
        String description = null;
        if (map != null) {
            description = (String)map.get(desiredLocale);
        }
        return description;
    }

    @Override
    public String getShortTitle(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        String shortTitle = portletRegistryElement.getStringProperty("title");
        return shortTitle;
    }

    @Override
    public String getTitle(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        String title2 = portletRegistryElement.getStringProperty("title");
        return title2;
    }

    @Override
    public List getKeywords(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map map = portletRegistryElement.getCollectionProperty("keywords");
        List keywords = null;
        if (map != null) {
            keywords = this.mapValuesToList(map);
        }
        return keywords;
    }

    @Override
    public String getDisplayName(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map map = portletRegistryElement.getCollectionProperty("displayNameMap");
        String displayName = null;
        if (map != null) {
            displayName = (String)map.get(desiredLocale);
        }
        return displayName;
    }

    @Override
    public Map getRoleMap(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map roleMap = portletRegistryElement.getCollectionProperty("roleMap");
        return roleMap;
    }

    @Override
    public Map getUserInfoMap(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map userInfoMap = portletRegistryElement.getCollectionProperty("userInfoMap");
        return userInfoMap;
    }

    @Override
    public void removePortlet(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletApp;
        int i2;
        List portletApps = this.portletAppRegistry.getRegistryElements();
        ArrayList<PortletRegistryElement> removeablePortletApps = new ArrayList<PortletRegistryElement>();
        boolean remove = false;
        int size = portletApps.size();
        for (i2 = 0; i2 < size; ++i2) {
            portletApp = (PortletRegistryElement)portletApps.get(i2);
            if (!portletApp.getPortletName().equals(portletName)) continue;
            remove = true;
            removeablePortletApps.add(portletApp);
        }
        size = removeablePortletApps.size();
        for (i2 = 0; i2 < size; ++i2) {
            portletApp = (PortletRegistryElement)removeablePortletApps.get(i2);
            this.portletAppRegistry.removeRegistryElement(portletApp);
        }
        if (remove) {
            this.writeDocument(this.portletAppRegistry);
        }
    }

    @Override
    public boolean hasView(String portletName) throws PortletRegistryException {
        return true;
    }

    @Override
    public boolean hasEdit(String portletName) throws PortletRegistryException {
        List<String> list = this.getSupportedPortletModes(portletName);
        return list.contains("EDIT");
    }

    @Override
    public boolean hasHelp(String portletName) throws PortletRegistryException {
        List<String> list = this.getSupportedPortletModes(portletName);
        return list.contains("HELP");
    }

    @Override
    public List getAvailablePortlets() throws PortletRegistryException {
        List portlets = this.portletAppRegistry.getRegistryElements();
        ArrayList<String> availablePortlets = new ArrayList<String>();
        int size = portlets.size();
        for (int i2 = 0; i2 < size; ++i2) {
            PortletApp portletApp = (PortletApp)portlets.get(i2);
            String portletName = portletApp.getPortletName();
            availablePortlets.add(portletName);
        }
        return availablePortlets;
    }

    private List<String> getSupportedPortletModes(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map map = portletRegistryElement.getCollectionProperty("supportsMap");
        ArrayList<String> list = new ArrayList<String>();
        Set entries = map.entrySet();
        for (Map.Entry mapEntry : entries) {
            for (String s : (List)mapEntry.getValue()) {
                list.add(s);
            }
        }
        return list;
    }

    private PortletRegistryElement getRegistryElement(String name) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.portletAppRegistry.getRegistryElement(name);
        if (portletRegistryElement == null) {
            throw new PortletRegistryException(name + " does not exist");
        }
        return portletRegistryElement;
    }

    private List mapValuesToList(Map map) {
        ArrayList list = new ArrayList();
        Set keys = map.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            list.add(map.get(itr.next()));
        }
        return list;
    }

    private PortletRegistryWriter getPortletRegistryWriter() throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        return new PortletAppRegistryWriter(registryLocation);
    }

    private void writeDocument(PortletRegistryObject portletAppRegistry) throws PortletRegistryException {
        PortletRegistryWriter portletAppRegistryWriter = this.getPortletRegistryWriter();
        List portletAppElementList = portletAppRegistry.getRegistryElements();
        try {
            portletAppRegistryWriter.writeDocument(portletAppElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }
}

