/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.admin.web.AbstractPersonnalEntity;
import org.silverpeas.admin.web.AbstractTypeEntity;
import org.silverpeas.admin.web.AdminResourceURIs;
import org.silverpeas.admin.web.AdminWebService;
import org.silverpeas.admin.web.ComponentEntity;
import org.silverpeas.admin.web.PersonalComponentEntity;
import org.silverpeas.admin.web.PersonalToolEntity;
import org.silverpeas.admin.web.SpaceAppearanceEntity;
import org.silverpeas.admin.web.SpaceEntity;
import org.silverpeas.admin.web.StructureElementEntity;
import org.silverpeas.admin.web.delegate.AdminPersonalWebDelegate;
import org.silverpeas.admin.web.tools.AbstractTool;
import org.silverpeas.look.web.delegate.LookWebDelegate;

public abstract class AbstractAdminResource
extends RESTWebService {
    @Inject
    private AdminWebService adminServices;
    private AdminPersonalWebDelegate adminPersonalDelegate;
    @Inject
    @Named(value="spaceAccessController")
    private AccessController<String> spaceAccessController;
    private LookWebDelegate lookDelegate;

    protected SpaceInstLight loadSpace(String spaceId) {
        Collection<SpaceInstLight> space = this.loadSpaces(spaceId);
        return space.isEmpty() ? null : space.iterator().next();
    }

    protected Collection<SpaceInstLight> loadSpaces(String ... spaceIds) {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        for (String spaceId : spaceIds) {
            SpaceInstLight space = this.getAdminServices().getSpaceById(spaceId);
            if (space == null) continue;
            spaces.add(space);
        }
        return spaces;
    }

    protected ComponentInstLight loadComponent(String componentId) {
        Collection<ComponentInstLight> component = this.loadComponents(componentId);
        return component.isEmpty() ? null : component.iterator().next();
    }

    protected Collection<ComponentInstLight> loadComponents(String ... componentIds) {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        for (String componentId : componentIds) {
            ComponentInstLight component = this.getAdminServices().getComponentById(componentId);
            if (component == null) continue;
            components.add(component);
        }
        return components;
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebEntities(Class<E> entityClass, Collection<T> data) {
        return this.asWebEntities(entityClass, data, false);
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebEntities(Class<E> entityClass, Collection<T> data, boolean forceGettingFavorite) {
        ArrayList<StructureElementEntity> entities = new ArrayList<StructureElementEntity>(data.size());
        for (T object : data) {
            if (object instanceof SpaceInstLight) {
                entities.add(this.asWebEntity((SpaceInstLight)object, forceGettingFavorite));
                continue;
            }
            if (object instanceof ComponentInstLight) {
                entities.add(this.asWebEntity((ComponentInstLight)object));
                continue;
            }
            this.asWebEntity(object);
        }
        return entities;
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebPersonalEntities(Class<E> entityClass, Collection<T> data) {
        ArrayList<AbstractPersonnalEntity> entities = new ArrayList<AbstractPersonnalEntity>(data.size());
        for (T object : data) {
            if (object instanceof WAComponent) {
                entities.add(this.asWebPersonalEntity((WAComponent)object));
                continue;
            }
            if (object instanceof ComponentInst) {
                entities.add(this.asWebPersonalEntity((ComponentInst)object));
                continue;
            }
            if (object instanceof AbstractTool) {
                entities.add(this.asWebPersonalEntity((AbstractTool)object));
                continue;
            }
            this.asWebEntity(object);
        }
        return entities;
    }

    protected SpaceEntity asWebEntity(SpaceInstLight space, boolean forceGettingFavorite) {
        this.checkNotFoundStatus(space);
        StringBuilder userFavoriteSpace = new StringBuilder();
        if (this.isUserAuthorizedToAccessLookContext()) {
            userFavoriteSpace.append(this.getLookDelegate().getUserFavorite(space, forceGettingFavorite));
        }
        return SpaceEntity.createFrom(space, this.getUserPreferences().getLanguage()).withURI(AdminResourceURIs.buildURIOfSpace(space, this.getUriInfo())).addUserFavorites(userFavoriteSpace.toString());
    }

    protected SpaceAppearanceEntity asWebEntity(SpaceInstLight space, String look, String wallpaper, String css) {
        this.checkNotFoundStatus(space);
        return SpaceAppearanceEntity.createFrom(space, look, wallpaper, css).withURI(AdminResourceURIs.buildURIOfSpaceAppearance(space, this.getUriInfo()));
    }

    protected ComponentEntity asWebEntity(ComponentInstLight component) {
        this.checkNotFoundStatus(component);
        return (ComponentEntity)ComponentEntity.createFrom(component, this.getUserPreferences().getLanguage()).withURI(AdminResourceURIs.buildURIOfComponent(component, this.getUriInfo()));
    }

    protected PersonalComponentEntity asWebPersonalEntity(WAComponent component) {
        this.checkNotFoundStatus(component);
        return (PersonalComponentEntity)PersonalComponentEntity.createFrom(component, this.getAdminPersonalDelegate().getComponentLabel(component), this.getUserPreferences().getLanguage()).withUriBase(this.getUriInfo().getBaseUri());
    }

    protected PersonalComponentEntity asWebPersonalEntity(ComponentInst component) {
        this.checkNotFoundStatus(component);
        return (PersonalComponentEntity)PersonalComponentEntity.createFrom(component).withUriBase(this.getUriInfo().getBaseUri());
    }

    protected PersonalToolEntity asWebPersonalEntity(AbstractTool tool) {
        this.checkNotFoundStatus(tool);
        return (PersonalToolEntity)PersonalToolEntity.createFrom(tool).withUriBase(this.getUriInfo().getBaseUri());
    }

    protected AbstractTypeEntity asWebEntity(Object object) {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private void checkNotFoundStatus(Object object) {
        if (object == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected AdminWebService getAdminServices() {
        return this.adminServices;
    }

    protected AdminPersonalWebDelegate getAdminPersonalDelegate() {
        if (this.adminPersonalDelegate == null) {
            this.adminPersonalDelegate = AdminPersonalWebDelegate.getInstance(this.getUserDetail(), this.getUserPreferences(), this.getLookDelegate());
        }
        return this.adminPersonalDelegate;
    }

    protected void verifyUserAuthorizedToAccessSpace(String spaceId) {
        if (!this.spaceAccessController.isUserAuthorized(this.getUserDetail().getId(), (Object)spaceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    protected void verifyUserAuthorizedToAccessLookContext() {
        if (!this.isUserAuthorizedToAccessLookContext()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    protected boolean isUserAuthorizedToAccessLookContext() {
        if (this.lookDelegate == null) {
            this.lookDelegate = LookWebDelegate.getInstance(this.getUserDetail(), this.getUserPreferences(), this.getHttpServletRequest());
        }
        return this.lookDelegate != null && this.lookDelegate.getHelper() != null;
    }

    protected LookWebDelegate getLookDelegate() {
        this.verifyUserAuthorizedToAccessLookContext();
        return this.lookDelegate;
    }
}

