/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.admin.web.AbstractTypeEntity;
import org.silverpeas.admin.web.AdminResourceURIs;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractPersonnalEntity
extends AbstractTypeEntity {
    private static final long serialVersionUID = 1025414384658732933L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(required=true)
    private final String id;
    @XmlElement
    private final int nb;
    @XmlElement(defaultValue="")
    private final String name;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private final String label;
    @XmlElement(defaultValue="")
    private final String description;
    @XmlElement(required=true)
    @NotNull
    private String url = "";

    public <T extends AbstractPersonnalEntity> T withUriBase(URI uriBase) {
        this.uri = AdminResourceURIs.buildURI(uriBase.toString(), "spaces", "personal", this.getUriIdentifier());
        return (T)this;
    }

    protected abstract String getUriIdentifier();

    @Override
    public URI getURI() {
        return this.uri;
    }

    protected final String getId() {
        return this.id;
    }

    protected final int getNb() {
        return this.nb;
    }

    protected final String getName() {
        return this.name;
    }

    protected final String getLabel() {
        return this.label;
    }

    protected final String getDescription() {
        return this.description;
    }

    protected final String getUrl() {
        return this.url;
    }

    public AbstractPersonnalEntity(String type, String id, int nb, String name, String label, String description, String url) {
        super(type);
        this.id = id;
        this.nb = nb;
        this.name = name;
        this.label = label;
        this.description = description;
        this.url = url;
    }

    protected AbstractPersonnalEntity() {
        this("", "", 0, "", "", "", "");
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.id).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractPersonnalEntity other = (AbstractPersonnalEntity)obj;
        return new EqualsBuilder().append((Object)this.getType(), (Object)other.getType()).append((Object)this.id, (Object)other.id).append((Object)this.name, (Object)other.name).isEquals();
    }
}

