/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriInfo;

public final class AdminResourceURIs {
    public static final String SPACES_BASE_URI = "spaces";
    public static final String SPACES_SPACES_URI_PART = "spaces";
    public static final String SPACES_COMPONENTS_URI_PART = "components";
    public static final String SPACES_CONTENT_URI_PART = "content";
    public static final String SPACES_APPEARANCE_URI_PART = "appearance";
    public static final String SPACES_PERSONAL_URI_PART = "personal";
    public static final String USERS_AND_GROUPS_ROLES_URI_PART = "usersAndGroupsRoles";
    public static final String ROLES_PARAM = "roles";
    public static final String FORCE_GETTING_FAVORITE_PARAM = "forceGettingFavorite";
    public static final String GET_NOT_USED_COMPONENTS_PARAM = "getNotUsedComponents";
    public static final String GET_USED_COMPONENTS_PARAM = "getUsedComponents";
    public static final String GET_USED_TOOLS_PARAM = "getUsedTools";
    public static final String COMPONENTS_BASE_URI = "components";
    private static final char separator = '/';

    public static URI buildURIOfSpace(SpaceInstLight space, UriInfo uriInfo) {
        return AdminResourceURIs.buildURIOfSpace(space.getShortId(), uriInfo);
    }

    public static URI buildURIOfSpace(String spaceId, UriInfo uriInfo) {
        return AdminResourceURIs.buildURI(uriInfo, "spaces", spaceId);
    }

    public static URI buildURIOfSpaceAppearance(SpaceInstLight space, UriInfo uriInfo) {
        return AdminResourceURIs.buildURIOfSpaceAppearance(space.getShortId(), uriInfo);
    }

    public static URI buildURIOfSpaceAppearance(String spaceId, UriInfo uriInfo) {
        return AdminResourceURIs.buildURI(uriInfo, "spaces", spaceId, SPACES_APPEARANCE_URI_PART);
    }

    public static URI buildURIOfSpaceUsersAndGroupsRoles(String spaceId, SilverpeasRole role, UriInfo uriInfo) {
        return AdminResourceURIs.buildURI(uriInfo, "spaces", spaceId, "usersAndGroupsRoles?roles=" + role.getName());
    }

    public static URI buildURIOfComponent(ComponentInstLight component, UriInfo uriInfo) {
        return AdminResourceURIs.buildURIOfComponent(component.getId() == null ? "" : component.getId().replaceFirst(component.getName(), ""), uriInfo);
    }

    public static URI buildURIOfComponent(String componentId, UriInfo uriInfo) {
        return AdminResourceURIs.buildURI(uriInfo, "components", componentId);
    }

    public static URI buildURIOfComponentUsersAndGroupsRoles(String componentId, SilverpeasRole role, UriInfo uriInfo) {
        return AdminResourceURIs.buildURI(uriInfo, "components", componentId, "usersAndGroupsRoles?roles=" + role.getName());
    }

    protected static URI buildURI(UriInfo uriInfo, String ... uriPathParts) {
        return AdminResourceURIs.buildURI(uriInfo.getBaseUri().toString(), uriPathParts);
    }

    protected static URI buildURI(String uriBase, String ... uriPathParts) {
        try {
            return new URI(AdminResourceURIs.buildStringURI(uriBase, uriPathParts));
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(AdminResourceURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String buildStringURI(String uriBase, String ... uriPathParts) {
        if (!StringUtil.isDefined((String)uriBase)) {
            return "";
        }
        StringBuilder stringURI = new StringBuilder(uriBase);
        if (uriPathParts != null) {
            for (String pathPart : uriPathParts) {
                if (stringURI.charAt(stringURI.length() - 1) != '/') {
                    stringURI.append('/');
                }
                stringURI.append(pathPart);
            }
        }
        return stringURI.toString();
    }
}

