/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.silverpeas.admin.web.AbstractAdminResource;
import org.silverpeas.admin.web.AdminResourceURIs;
import org.silverpeas.admin.web.ComponentEntity;
import org.silverpeas.admin.web.UsersAndGroupsRoleEntity;

@Service
@RequestScoped
@Path(value="components/{componentId}")
@Authorized
public class ComponentResource
extends AbstractAdminResource {
    @PathParam(value="componentId")
    private String componentId;
    @XmlTransient
    private String fullComponentId;

    @GET
    @Produces(value={"application/json"})
    public ComponentEntity get() {
        try {
            Collection<ComponentInstLight> component = this.loadComponents(this.componentId);
            return this.asWebEntity(component.isEmpty() ? null : component.iterator().next());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="usersAndGroupsRoles")
    @Produces(value={"application/json"})
    public Map<SilverpeasRole, UsersAndGroupsRoleEntity> getUsersAndGroupsRoles(@QueryParam(value="roles") String roles) {
        try {
            LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity> result = new LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity>();
            List aimedRoles = new ArrayList(0);
            if (StringUtil.isDefined((String)roles)) {
                aimedRoles = CollectionUtil.asList((Object[])StringUtils.split((String)roles, (String)","));
            }
            ComponentInst componentInst = this.getOrganisationController().getComponentInst(this.getComponentId());
            ArrayList profiles = new ArrayList();
            profiles.addAll(componentInst.getInheritedProfiles());
            profiles.addAll(componentInst.getProfiles());
            ResourceLocator resource = new ResourceLocator("com.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle", this.getUserPreferences().getLanguage());
            for (ProfileInst profile : profiles) {
                SilverpeasRole role = SilverpeasRole.from((String)profile.getName());
                if (role == null || !aimedRoles.isEmpty() && !aimedRoles.contains(role.getName())) continue;
                UsersAndGroupsRoleEntity roleEntity = (UsersAndGroupsRoleEntity)result.get(role);
                if (roleEntity == null) {
                    roleEntity = UsersAndGroupsRoleEntity.createFrom(role, resource.getString("JSPP." + role.getName()));
                    roleEntity.withURI(AdminResourceURIs.buildURIOfComponentUsersAndGroupsRoles(this.componentId, role, this.getUriInfo())).withParentURI(AdminResourceURIs.buildURIOfComponent(this.componentId, this.getUriInfo()));
                    result.put(role, roleEntity);
                }
                for (String userId : profile.getAllUsers()) {
                    roleEntity.addUser(AdminResourceURIs.buildURI(this.getUriInfo().getBaseUri().toString(), "profile/users", userId));
                }
                for (String groupId : profile.getAllGroups()) {
                    roleEntity.addGroup(AdminResourceURIs.buildURI(this.getUriInfo().getBaseUri().toString(), "profile/groups", groupId));
                }
            }
            return result;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String getComponentId() {
        if (!StringUtil.isDefined((String)this.fullComponentId)) {
            Collection<ComponentInstLight> components = this.loadComponents(this.componentId);
            ComponentInstLight component = components.isEmpty() ? null : components.iterator().next();
            this.fullComponentId = component != null ? component.getId() : this.componentId;
        }
        return this.fullComponentId;
    }
}

