/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.admin.web.AdminResourceURIs;
import org.silverpeas.admin.web.StructureElementEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SpaceEntity
extends StructureElementEntity<SpaceEntity> {
    public static final String TYPE = "space";
    private static final long serialVersionUID = 2872199842421965243L;
    @XmlElement(defaultValue="")
    private URI spacesURI;
    @XmlElement(defaultValue="")
    private URI componentsURI;
    @XmlElement(defaultValue="")
    private URI contentURI;
    @XmlElement(defaultValue="")
    private URI appearanceURI;
    @XmlElement
    private int level;
    @XmlElement
    private boolean isSpaceDisplayedAtFirst;
    @XmlElement(defaultValue="")
    private String favorite = "";

    public static SpaceEntity createFrom(SpaceInstLight space, String language) {
        return new SpaceEntity(space, language);
    }

    @Override
    public SpaceEntity withURI(URI uri) {
        super.withURI(uri);
        this.spacesURI = AdminResourceURIs.buildURI(this.getStringBaseURI(), this.getId(), "spaces");
        this.componentsURI = AdminResourceURIs.buildURI(this.getStringBaseURI(), this.getId(), "components");
        this.contentURI = AdminResourceURIs.buildURI(this.getStringBaseURI(), this.getId(), "content");
        this.appearanceURI = AdminResourceURIs.buildURI(this.getStringBaseURI(), this.getId(), "appearance");
        return this;
    }

    public SpaceEntity addUserFavorites(String favorite) {
        this.favorite = favorite;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public URI getSpacesURI() {
        return this.spacesURI;
    }

    public URI getComponentsURI() {
        return this.componentsURI;
    }

    public URI getContentURI() {
        return this.contentURI;
    }

    public URI getAppearanceURI() {
        return this.appearanceURI;
    }

    public boolean isSpaceDisplayedAtFirst() {
        return this.isSpaceDisplayedAtFirst;
    }

    protected final String getFavorite() {
        return this.favorite;
    }

    private SpaceEntity(SpaceInstLight space, String language) {
        super(TYPE, space.getShortId(), space.getFatherId(), space.getName(language), space.getDescription(), space.getStatus(), space.getOrderNum(), space.isInheritanceBlocked());
        this.level = space.getLevel();
        this.isSpaceDisplayedAtFirst = space.isDisplaySpaceFirst();
    }

    protected SpaceEntity() {
    }

    @Override
    protected String getStringBaseURI() {
        return this.getURI().toString().replaceFirst("spaces/[0-9]+", "spaces");
    }

    @Override
    protected String getStringParentBaseURI() {
        return this.getStringBaseURI();
    }
}

