/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.silverpeas.admin.web.AbstractAdminResource;
import org.silverpeas.admin.web.AbstractPersonnalEntity;
import org.silverpeas.admin.web.AbstractTypeEntity;
import org.silverpeas.admin.web.AdminResourceURIs;
import org.silverpeas.admin.web.ComponentEntity;
import org.silverpeas.admin.web.PersonalComponentEntity;
import org.silverpeas.admin.web.PersonalToolEntity;
import org.silverpeas.admin.web.SpaceAppearanceEntity;
import org.silverpeas.admin.web.SpaceEntity;
import org.silverpeas.admin.web.UsersAndGroupsRoleEntity;

@Service
@RequestScoped
@Path(value="spaces")
@Authenticated
public class SpaceResource
extends AbstractAdminResource {
    @GET
    @Produces(value={"application/json"})
    public Collection<SpaceEntity> getAll(@QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            return this.asWebEntities(SpaceEntity.class, this.loadSpaces(this.getAdminServices().getAllRootSpaceIds(this.getUserDetail().getId())), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}")
    @Produces(value={"application/json"})
    public SpaceEntity get(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntity(this.loadSpace(spaceId), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/usersAndGroupsRoles")
    @Produces(value={"application/json"})
    public Map<SilverpeasRole, UsersAndGroupsRoleEntity> getUsersAndGroupsRoles(@PathParam(value="spaceId") String spaceId, @QueryParam(value="roles") String roles) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity> result = new LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity>();
            List aimedRoles = new ArrayList(0);
            if (StringUtil.isDefined((String)roles)) {
                aimedRoles = CollectionUtil.asList((Object[])StringUtils.split((String)roles, (String)","));
            }
            SpaceInst spaceInst = this.getOrganisationController().getSpaceInstById(spaceId);
            ArrayList profiles = new ArrayList();
            profiles.addAll(spaceInst.getInheritedProfiles());
            profiles.addAll(spaceInst.getProfiles());
            ResourceLocator resource = new ResourceLocator("com.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle", this.getUserPreferences().getLanguage());
            for (SpaceProfileInst profile : profiles) {
                SilverpeasRole role = SilverpeasRole.from((String)profile.getName());
                if (role == null || !aimedRoles.isEmpty() && !aimedRoles.contains(role.getName())) continue;
                UsersAndGroupsRoleEntity roleEntity = (UsersAndGroupsRoleEntity)result.get(role);
                if (roleEntity == null) {
                    roleEntity = UsersAndGroupsRoleEntity.createFrom(role, resource.getString("JSPP." + role.getName()));
                    roleEntity.withURI(AdminResourceURIs.buildURIOfSpaceUsersAndGroupsRoles(spaceId, role, this.getUriInfo())).withParentURI(AdminResourceURIs.buildURIOfSpace(spaceId, this.getUriInfo()));
                    result.put(role, roleEntity);
                }
                for (String userId : profile.getAllUsers()) {
                    roleEntity.addUser(AdminResourceURIs.buildURI(this.getUriInfo().getBaseUri().toString(), "profile/users", userId));
                }
                for (String groupId : profile.getAllGroups()) {
                    roleEntity.addGroup(AdminResourceURIs.buildURI(this.getUriInfo().getBaseUri().toString(), "profile/groups", groupId));
                }
            }
            return result;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Path(value="{spaceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public SpaceEntity update(@PathParam(value="spaceId") String spaceId, SpaceEntity spaceEntity) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            SpaceEntity oldSpaceEntity = this.get(spaceId, true);
            if (!oldSpaceEntity.getFavorite().equals(spaceEntity.getFavorite())) {
                if (spaceEntity.getFavorite().equals(String.valueOf(Boolean.TRUE))) {
                    this.getLookDelegate().addToUserFavorites(this.loadSpace(spaceId));
                } else if (spaceEntity.getFavorite().equals(String.valueOf(Boolean.FALSE))) {
                    this.getLookDelegate().removeFromUserFavorites(this.loadSpace(spaceId));
                }
            }
            return this.asWebEntity(this.loadSpace(spaceId), true);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/spaces")
    @Produces(value={"application/json"})
    public Collection<SpaceEntity> getSpaces(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntities(SpaceEntity.class, this.loadSpaces(this.getAdminServices().getAllSubSpaceIds(spaceId, this.getUserDetail().getId())), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/components")
    @Produces(value={"application/json"})
    public Collection<ComponentEntity> getComponents(@PathParam(value="spaceId") String spaceId) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntities(ComponentEntity.class, this.loadComponents(this.getAdminServices().getAllComponentIds(spaceId, this.getUserDetail().getId())));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/content")
    @Produces(value={"application/json"})
    public Collection<AbstractTypeEntity> getContent(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            ArrayList<AbstractTypeEntity> content = new ArrayList<AbstractTypeEntity>();
            content.addAll(this.getSpaces(spaceId, forceGettingFavorite));
            content.addAll(this.getComponents(spaceId));
            return content;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/appearance")
    @Produces(value={"application/json"})
    public SpaceAppearanceEntity getAppearance(@PathParam(value="spaceId") String spaceId) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            SpaceInstLight space = this.loadSpace(spaceId);
            return this.asWebEntity(space, this.getLookDelegate().getLook(space), this.getLookDelegate().getWallpaper(space), this.getLookDelegate().getCSS(space));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="personal")
    @Produces(value={"application/json"})
    public Collection<AbstractPersonnalEntity> getPersonals(@QueryParam(value="getNotUsedComponents") boolean getNotUsedComponents, @QueryParam(value="getUsedComponents") boolean getUsedComponents, @QueryParam(value="getUsedTools") boolean getUsedTools) {
        try {
            boolean getAll = !getNotUsedComponents && !getUsedComponents && !getUsedTools;
            ArrayList<AbstractPersonnalEntity> personals = new ArrayList<AbstractPersonnalEntity>();
            if (getAll || getNotUsedComponents) {
                personals.addAll(this.asWebPersonalEntities(PersonalComponentEntity.class, this.getAdminPersonalDelegate().getNotUsedComponents()));
            }
            if (getAll || getUsedComponents) {
                personals.addAll(this.asWebPersonalEntities(PersonalComponentEntity.class, this.getAdminPersonalDelegate().getUsedComponents()));
            }
            if (getAll || getUsedTools) {
                personals.addAll(this.asWebPersonalEntities(PersonalToolEntity.class, this.getAdminPersonalDelegate().getUsedTools()));
            }
            return personals;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Path(value="personal/{componentName}")
    @Produces(value={"application/json"})
    public PersonalComponentEntity useComponent(@PathParam(value="componentName") String componentName) {
        try {
            return this.asWebPersonalEntity(this.getAdminPersonalDelegate().useComponent(componentName));
        }
        catch (AdminException ex) {
            SilverTrace.error((String)"admin", (String)"SpaceResource.useComponent", (String)"root.EX_UNKNOWN_COMPONENT_OR_COMPONENT_ALREADY_USED");
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="personal/{componentName}")
    @Produces(value={"application/json"})
    public PersonalComponentEntity discardComponent(@PathParam(value="componentName") String componentName) {
        try {
            return this.asWebPersonalEntity(this.getAdminPersonalDelegate().discardComponent(componentName));
        }
        catch (AdminException ex) {
            SilverTrace.error((String)"admin", (String)"SpaceResource.discardComponent", (String)"root.EX_UNKNOWN_COMPONENT_ID");
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String getComponentId() {
        throw new UnsupportedOperationException("The SpaceResource doesn't belong to any component instance ids");
    }
}

