/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.admin.web.AbstractTypeEntity;
import org.silverpeas.admin.web.AdminResourceURIs;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class StructureElementEntity<T extends StructureElementEntity<T>>
extends AbstractTypeEntity {
    private static final long serialVersionUID = -2205892819135663318L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private URI parentURI;
    @XmlElement(defaultValue="")
    private URI usersAndGroupsRolesURI;
    @XmlElement(required=true)
    @NotNull
    @Pattern(regexp="^[0-9]+$")
    private final String id;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private final String label;
    @XmlElement(defaultValue="")
    private final String description;
    @XmlElement(defaultValue="")
    private final String status;
    @XmlElement
    private final int rank;
    @XmlElement
    private final boolean isInheritanceBlocked;
    @XmlTransient
    private final String parentId;

    public T withURI(URI uri) {
        this.uri = uri;
        this.parentURI = AdminResourceURIs.buildURI(StringUtil.isDefined((String)this.parentId) && !SpaceInstLight.isRoot((String)this.parentId) ? this.getStringParentBaseURI() : null, this.parentId);
        this.usersAndGroupsRolesURI = AdminResourceURIs.buildURI(uri.toString(), "usersAndGroupsRoles");
        return (T)this;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    protected URI getParentURI() {
        return this.parentURI;
    }

    public URI getUsersAndGroupsRolesURI() {
        return this.usersAndGroupsRolesURI;
    }

    protected String getId() {
        return this.id;
    }

    protected String getLabel() {
        return this.label;
    }

    protected String getDescription() {
        return this.description;
    }

    protected String getStatus() {
        return this.status;
    }

    protected int getRank() {
        return this.rank;
    }

    protected boolean isInheritanceBlocked() {
        return this.isInheritanceBlocked;
    }

    protected abstract String getStringBaseURI();

    protected abstract String getStringParentBaseURI();

    protected StructureElementEntity(String type, String id, String parentId, String label, String description, String status, int rank, boolean isInheritanceBlocked) {
        super(type);
        this.id = id == null ? "" : id;
        this.parentId = parentId == null ? "" : parentId.replaceFirst("WA", "");
        this.label = label == null ? "" : label;
        this.description = description == null ? "" : description;
        this.status = status == null ? "" : status;
        this.rank = rank;
        this.isInheritanceBlocked = isInheritanceBlocked;
    }

    protected StructureElementEntity() {
        this("", "", "", "", "", "", 0, false);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        StructureElementEntity other = (StructureElementEntity)obj;
        return new EqualsBuilder().append((Object)this.getType(), (Object)other.getType()).append((Object)this.id, (Object)other.getId()).isEquals();
    }
}

