/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.web.delegate;

import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.PersonalSpaceController;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.silverpeas.admin.web.tools.AbstractTool;
import org.silverpeas.admin.web.tools.ToolDelegate;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.look.web.delegate.LookWebDelegate;

public class AdminPersonalWebDelegate {
    private OrganisationController organizationController;
    private final UserDetail user;
    private final UserPreferences userPreference;
    private final LookWebDelegate lookDelegate;
    private ToolDelegate toolDelegate;
    private PersonalSpaceController psc = null;
    private Map<String, WAComponent> indexedNotUsedComponents = null;
    private Map<String, ComponentInst> indexedUsedComponents = null;
    private Map<String, AbstractTool> indexedUsedTools = null;

    public String getComponentLabel(WAComponent component) {
        String label = this.getLookDelegate().getHelper().getString("lookSilverpeasV5.personalSpace." + component.getName());
        if (!StringUtil.isDefined((String)label)) {
            label = component.getName();
        }
        return label;
    }

    public Collection<WAComponent> getNotUsedComponents() {
        return this.getCachedNotUsedComponents().values();
    }

    public Collection<ComponentInst> getUsedComponents() {
        return this.getCachedUsedComponents().values();
    }

    public Collection<AbstractTool> getUsedTools() {
        return this.getCachedUsedTools().values();
    }

    public ComponentInst useComponent(String componentName) throws Exception {
        WAComponent component = this.getCachedNotUsedComponents().get(componentName.toLowerCase());
        if (component == null) {
            throw new AdminException("AdminPersonalWebDelegate.useComponent", 4, "root.EX_UNKNOWN_COMPONENT_OR_COMPONENT_ALREADY_USED");
        }
        this.getPersonalSpaceController().addComponent(this.getUserId(), component.getName(), this.getComponentLabel(component));
        this.clearCache();
        return this.getCachedUsedComponents().get(componentName.toLowerCase());
    }

    public WAComponent discardComponent(String componentName) throws Exception {
        ComponentInst component = this.getCachedUsedComponents().get(componentName.toLowerCase());
        if (component == null) {
            throw new AdminException("AdminPersonalWebDelegate.discardComponent", 4, "root.EX_UNKNOWN_COMPONENT_ID");
        }
        this.getPersonalSpaceController().removeComponent(this.getUserId(), component.getName() + component.getId());
        this.clearCache();
        return this.getCachedNotUsedComponents().get(componentName.toLowerCase());
    }

    private Map<String, WAComponent> getCachedNotUsedComponents() {
        if (this.indexedNotUsedComponents == null) {
            this.indexedNotUsedComponents = new LinkedHashMap<String, WAComponent>();
            for (WAComponent component : this.getPersonalSpaceController().getVisibleComponents(this.getOrganisationController())) {
                if (this.isComponentUsed(component)) continue;
                this.indexedNotUsedComponents.put(component.getName().toLowerCase(), component);
            }
        }
        return this.indexedNotUsedComponents;
    }

    private Map<String, ComponentInst> getCachedUsedComponents() {
        if (this.indexedUsedComponents == null) {
            this.indexedUsedComponents = new LinkedHashMap<String, ComponentInst>();
            SpaceInst space = this.getPersonalSpaceController().getPersonalSpace(this.getUserId());
            if (space != null) {
                for (ComponentInst component : space.getAllComponentsInst()) {
                    this.indexedUsedComponents.put(component.getName().toLowerCase(), component);
                }
            }
        }
        return this.indexedUsedComponents;
    }

    private Map<String, AbstractTool> getCachedUsedTools() {
        if (this.indexedUsedTools == null) {
            this.indexedUsedTools = new LinkedHashMap<String, AbstractTool>();
            if (!this.getLookDelegate().getHelper().isAnonymousAccess() && this.getLookDelegate().getHelper().getSettings("personnalSpaceVisible", true)) {
                for (AbstractTool tool : this.getToolDelegate().getAllTools()) {
                    if (!tool.isVisible()) continue;
                    this.indexedUsedTools.put(tool.getId().toLowerCase(), tool);
                }
            }
        }
        return this.indexedUsedTools;
    }

    private boolean isComponentUsed(WAComponent component) {
        return this.getCachedUsedComponents().containsKey(component.getName().toLowerCase());
    }

    private void clearCache() {
        this.indexedNotUsedComponents = null;
        this.indexedUsedComponents = null;
        this.indexedUsedTools = null;
    }

    public static AdminPersonalWebDelegate getInstance(UserDetail user, UserPreferences userPreference, LookWebDelegate lookDelegate) {
        return new AdminPersonalWebDelegate(user, userPreference, lookDelegate);
    }

    private AdminPersonalWebDelegate(UserDetail user, UserPreferences userPreference, LookWebDelegate lookDelegate) {
        this.user = user;
        this.userPreference = userPreference;
        this.lookDelegate = lookDelegate;
    }

    private String getUserId() {
        return this.user.getId();
    }

    private OrganisationController getOrganisationController() {
        if (this.organizationController == null) {
            OrganisationControllerFactory.getFactory();
            this.organizationController = OrganisationControllerFactory.getOrganisationController();
        }
        return this.organizationController;
    }

    private LookWebDelegate getLookDelegate() {
        return this.lookDelegate;
    }

    private ToolDelegate getToolDelegate() {
        if (this.toolDelegate == null) {
            this.toolDelegate = ToolDelegate.getInstance(this.userPreference.getLanguage(), this.getLookDelegate().getHelper());
        }
        return this.toolDelegate;
    }

    private PersonalSpaceController getPersonalSpaceController() {
        if (this.psc == null) {
            this.psc = new PersonalSpaceController();
        }
        return this.psc;
    }
}

