/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.tag;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.StringEscapeUtils;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class SimpleDocumentContextualMenu
extends TagSupport {
    private SimpleDocument attachment;
    private boolean useXMLForm;
    private boolean useFileSharing;
    private boolean useWebDAV;
    private String contentLanguage;
    private boolean showMenuNotif;
    private boolean useContextualMenu;
    private static final String template = "oMenu%s.getItem(%s).cfg.setProperty(\"disabled\", %s);";
    private static final String menuItemTemplate = "<li class=\"yuimenuitem\"><a class=\"yuimenuitemlabel\" href=\"javascript:%1$s\">%2$s</a></li>%n";
    private static final long serialVersionUID = 1L;

    public void setAttachment(SimpleDocument attachment) {
        this.attachment = attachment;
    }

    public void setUseXMLForm(boolean useXMLForm) {
        this.useXMLForm = useXMLForm;
    }

    public void setUseFileSharing(boolean useFileSharing) {
        this.useFileSharing = useFileSharing;
    }

    public void setUseWebDAV(boolean useWebDAV) {
        this.useWebDAV = useWebDAV;
    }

    public void setContentLanguage(String lang) {
        this.contentLanguage = lang;
    }

    public void setShowMenuNotif(boolean showMenuNotif) {
        this.showMenuNotif = showMenuNotif;
    }

    public void setUseContextualMenu(boolean useContextualMenu) {
        this.useContextualMenu = useContextualMenu;
    }

    public int doStartTag() throws JspException {
        try {
            MainSessionController mainSessionController = (MainSessionController)this.pageContext.getSession().getAttribute("SilverSessionController");
            String favoriteLanguage = mainSessionController.getFavoriteLanguage();
            ResourceLocator messages = new ResourceLocator("org.silverpeas.util.attachment.multilang.attachment", favoriteLanguage);
            String httpServerBase = URLManager.getServerURL((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()));
            this.pageContext.getOut().print(this.prepareActions(this.attachment, this.useXMLForm, this.useFileSharing, this.useWebDAV, mainSessionController.getUserId(), this.contentLanguage, messages, httpServerBase, this.showMenuNotif, this.useContextualMenu));
            return 1;
        }
        catch (IOException ioex) {
            throw new JspException((Throwable)ioex);
        }
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    boolean isAdmin(String userId) {
        return OrganisationControllerFactory.getOrganisationController().getUserDetail(userId).isAccessAdmin();
    }

    boolean isWorker(String userId, SimpleDocument attachment) {
        return userId.equals(attachment.getEditedBy());
    }

    boolean isEditable(String userId, SimpleDocument attachment, boolean useWebDAV) {
        return useWebDAV && attachment.isOpenOfficeCompatible() && this.isWorker(userId, attachment);
    }

    String prepareActions(SimpleDocument attachment, boolean useXMLForm, boolean useFileSharing, boolean useWebDAV, String userId, String lang, ResourceLocator resources, String httpServerBase, boolean showMenuNotif, boolean useContextualMenu) throws UnsupportedEncodingException {
        String language = I18NHelper.checkLanguage((String)lang);
        String attachmentId = String.valueOf(attachment.getOldSilverpeasId());
        boolean webDavOK = useWebDAV && attachment.isOpenOfficeCompatible();
        StringBuilder builder = new StringBuilder(1024);
        builder.append("<div id=\"basicmenu").append(attachmentId).append("\" class=\"yuimenu\">").append(StringUtil.newline);
        builder.append("<div class=\"bd\">").append(StringUtil.newline);
        builder.append("<ul class=\"first-of-type\">").append(StringUtil.newline);
        this.prepareMenuItem(builder, "checkout('" + attachment.getId() + "'," + attachmentId + ',' + webDavOK + ");", resources.getString("checkOut"));
        this.prepareMenuItem(builder, "checkoutAndDownload('" + attachment.getId() + "'," + attachmentId + ',' + webDavOK + ");", resources.getString("attachment.checkOutAndDownload"));
        this.prepareMenuItem(builder, "checkoutAndEdit('" + attachment.getId() + "'," + attachmentId + ");", resources.getString("attachment.checkOutAndEditOnline"));
        this.prepareMenuItem(builder, "checkin('" + attachment.getId() + "'," + attachmentId + ',' + attachment.isOpenOfficeCompatible() + ", false ," + attachment.isVersioned() + ");", resources.getString("checkIn"));
        builder.append("</ul>").append(StringUtil.newline);
        builder.append("<ul>").append(StringUtil.newline);
        this.prepareMenuItem(builder, "updateAttachment('" + attachment.getId() + "','" + language + "');", resources.getString("GML.modify"));
        this.prepareMenuItem(builder, "EditXmlForm('" + attachment.getId() + "','" + language + "');", resources.getString("attachment.xmlForm.Edit"));
        String message = resources.getString("attachment.switchState.toVersioned");
        if (attachment.isVersioned()) {
            message = resources.getString("attachment.switchState.toSimple");
        }
        this.prepareMenuItem(builder, "switchState('" + attachment.getId() + "', " + attachment.isVersioned() + ");", message);
        this.prepareMenuItem(builder, "deleteAttachment('" + attachment.getId() + "','" + StringEscapeUtils.escapeEcmaScript((String)attachment.getFilename()) + "');", resources.getString("GML.delete"));
        builder.append("</ul>").append(StringUtil.newline);
        builder.append("<ul>").append(StringUtil.newline);
        this.prepareMenuItem(builder, "ShareAttachment('" + attachmentId + "');", resources.getString("attachment.share"));
        builder.append("</ul>").append(StringUtil.newline);
        builder.append("<ul>").append(StringUtil.newline);
        this.prepareMenuItem(builder, "notifyAttachment('" + attachmentId + "');", resources.getString("GML.notify"));
        builder.append("</ul>").append(StringUtil.newline);
        builder.append("</div>").append(StringUtil.newline);
        builder.append("</div>").append(StringUtil.newline);
        builder.append("<script type=\"text/javascript\">");
        String oMenuId = "oMenu" + attachmentId;
        builder.append("var ").append(oMenuId).append(";");
        builder.append("var webDav").append(attachmentId).append(" = \"");
        builder.append(URLEncoder.encode(httpServerBase + attachment.getWebdavUrl(), "UTF-8")).append("\";");
        builder.append("YAHOO.util.Event.onContentReady(\"basicmenu").append(attachmentId).append("\", function () {");
        if (useContextualMenu) {
            builder.append(oMenuId).append(" = new YAHOO.widget.ContextMenu(\"basicmenu").append(attachmentId).append("\"");
            builder.append(", { trigger: \"img_").append(attachmentId).append("\", ");
        } else {
            builder.append(oMenuId).append(" = new YAHOO.widget.Menu(\"basicmenu").append(attachmentId).append("\"").append(", {");
        }
        builder.append("hidedelay: 100, ");
        builder.append("effect: {effect: YAHOO.widget.ContainerEffect.FADE, duration: 0.30}});");
        builder.append(oMenuId).append(".render();");
        if (attachment.isReadOnly()) {
            this.configureCheckout(builder, attachmentId, true);
            builder.append(this.configureCheckoutAndDownload(attachmentId, !this.isWorker(userId, attachment)));
            builder.append(this.configureCheckoutAndEdit(attachmentId, !this.isEditable(userId, attachment, useWebDAV)));
            builder.append(this.configureCheckin(attachmentId, !this.isWorker(userId, attachment) && !this.isAdmin(userId)));
            builder.append(this.configureUpdate(attachmentId, !this.isWorker(userId, attachment)));
            builder.append(this.configureDelete(attachmentId, true));
            if (!userId.equals(attachment.getEditedBy())) {
                builder.append(this.configureXmlForm(attachmentId, true));
            }
        } else {
            builder.append(this.configureXmlForm(attachmentId, !useXMLForm));
            builder.append(this.configureCheckin(attachmentId, true));
            builder.append(this.configureCheckoutAndEdit(attachmentId, !useWebDAV || !attachment.isOpenOfficeCompatible()));
        }
        builder.append(this.configureFileSharing(attachmentId, !useFileSharing));
        builder.append(this.configureSwitchState(attachmentId, attachment.isReadOnly()));
        builder.append(this.configureNotify(attachmentId, !showMenuNotif));
        builder.append("YAHOO.util.Event.addListener(\"basicmenu").append(attachmentId);
        builder.append("\", \"mouseover\", oMenu").append(attachmentId).append(".show);");
        builder.append("YAHOO.util.Event.addListener(\"basicmenu").append(attachmentId);
        builder.append("\", \"mouseout\", oMenu").append(attachmentId).append(".hide);");
        if (!useContextualMenu) {
            builder.append("YAHOO.util.Event.on(\"edit_").append(attachmentId);
            builder.append("\", \"click\", function (event) {");
            builder.append("var xy = YAHOO.util.Event.getXY(event);");
            builder.append(oMenuId).append(".cfg.setProperty(\"x\", xy[0]);");
            builder.append(oMenuId).append(".cfg.setProperty(\"y\", xy[1]+10);");
            builder.append(oMenuId).append(".show();");
            builder.append("  })");
        }
        builder.append("});");
        builder.append("</script>");
        return builder.toString();
    }

    StringBuilder prepareMenuItem(StringBuilder buffer, String javascript, String label) {
        return buffer.append(String.format(menuItemTemplate, javascript, label));
    }

    StringBuilder configureCheckout(StringBuilder buffer, String attachmentId, boolean disable) {
        return buffer.append(String.format(template, attachmentId, "0", disable));
    }

    String configureCheckoutAndDownload(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "1", disable);
    }

    String configureCheckoutAndEdit(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "2", disable);
    }

    String configureCheckin(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "3", disable);
    }

    String configureUpdate(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "0, 1", disable);
    }

    String configureDelete(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "3, 1", disable);
    }

    String configureXmlForm(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "1, 1", disable);
    }

    String configureFileSharing(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "0, 2", disable);
    }

    String configureSwitchState(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "2, 1", disable);
    }

    String configureNotify(String attachmentId, boolean disable) {
        return String.format(template, attachmentId, "0, 3", disable);
    }
}

