/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.web;

import com.silverpeas.web.Exposable;
import com.stratelia.silverpeas.peasCore.URLManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.model.SimpleDocument;

public class SimpleDocumentEntity
implements Exposable {
    private static final long serialVersionUID = 6578990825699318566L;
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private String instanceId;
    @XmlElement(required=true)
    private String fileName;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private String contentType;
    @XmlElement(defaultValue="0")
    private long creationDate;
    @XmlElement(defaultValue="")
    private String createdBy;
    @XmlElement(defaultValue="0")
    private long updateDate;
    @XmlElement(defaultValue="")
    private String updatedBy;
    @XmlElement(defaultValue="0")
    private long size;
    @XmlElement(defaultValue="")
    private String title;
    @XmlElement(defaultValue="")
    private String lang;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement(required=true)
    private String icon;
    @XmlElement(required=true)
    private String permalink;
    @XmlElement(defaultValue="")
    private String downloadUrl;
    @XmlElement(defaultValue="")
    private String comment;
    @XmlElement(defaultValue="false")
    private String versioned;

    public static SimpleDocumentEntity fromAttachment(SimpleDocument document) {
        SimpleDocumentEntity entity = new SimpleDocumentEntity();
        try {
            entity.uri = new URI(URLManager.getSimpleURL((int)4, (String)document.getId()));
        }
        catch (URISyntaxException e) {
            throw new AttachmentException("AttachmentEntity.fromAttachment(", 4, "Couldn't build the URI to the attachment", (Exception)e);
        }
        entity.id = document.getId();
        entity.instanceId = document.getInstanceId();
        entity.fileName = document.getFilename();
        entity.description = document.getDescription();
        entity.size = document.getSize();
        entity.creationDate = document.getCreated().getTime();
        entity.createdBy = document.getCreatedBy();
        if (document.getUpdated() != null) {
            entity.updateDate = document.getUpdated().getTime();
        }
        entity.updatedBy = document.getUpdatedBy();
        entity.title = document.getTitle();
        entity.contentType = document.getContentType();
        entity.icon = document.getDisplayIcon();
        entity.permalink = URLManager.getSimpleURL((int)4, (String)document.getId());
        entity.downloadUrl = document.getAttachmentURL();
        entity.lang = document.getLanguage();
        entity.comment = document.getComment();
        entity.versioned = String.valueOf(document.isVersioned());
        return entity;
    }

    public SimpleDocumentEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public long getUpdateDate() {
        return this.updateDate;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public long getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLang() {
        return this.lang;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersioned() {
        return this.versioned;
    }
}

