/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.web.RESTWebService;
import com.silverpeas.web.UserPriviledgeValidation;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.WebdavServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.attachment.model.UnlockOption;
import org.silverpeas.attachment.web.SimpleDocumentEntity;
import org.silverpeas.web.util.IFrameAjaxTransportUtil;

@Service
@RequestScoped
@Path(value="documents/{componentId}/document/{id}")
@Authorized
public class SimpleDocumentResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="id")
    private String simpleDocumentId;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    public String getSimpleDocumentId() {
        return this.simpleDocumentId;
    }

    @GET
    @Path(value="{lang}")
    @Produces(value={"application/json"})
    public SimpleDocumentEntity getDocument(@PathParam(value="lang") String lang) {
        SimpleDocument attachment = this.getSimpleDocument(lang);
        if (attachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        URI attachmentUri = this.getUriInfo().getRequestUriBuilder().path("document").path(attachment.getLanguage()).build(new Object[0]);
        return SimpleDocumentEntity.fromAttachment(attachment).withURI(attachmentUri);
    }

    @DELETE
    @Produces(value={"application/json"})
    public void deleteDocument() {
        SimpleDocument document = this.getSimpleDocument(null);
        AttachmentServiceFactory.getAttachmentService().deleteAttachment(document);
    }

    @DELETE
    @Path(value="content/{lang}")
    @Produces(value={"application/json"})
    public void deleteContent(@PathParam(value="lang") String lang) {
        SimpleDocument document = this.getSimpleDocument(lang);
        AttachmentServiceFactory.getAttachmentService().removeContent(document, lang, false);
    }

    @POST
    @Path(value="{filename}")
    @Consumes(value={"multipart/form-data"})
    public Response updateDocument(@FormDataParam(value="file_upload") InputStream uploadedInputStream, @FormDataParam(value="file_upload") FormDataContentDisposition fileDetail, @FormDataParam(value="X-Requested-With") String xRequestedWith, @FormDataParam(value="fileLang") String lang, @FormDataParam(value="fileTitle") String title2, @FormDataParam(value="fileDescription") String description, @FormDataParam(value="versionType") String versionType, @FormDataParam(value="commentMessage") String comment, @PathParam(value="filename") String filename) throws IOException {
        SimpleDocumentEntity entity = this.updateSimpleDocument(uploadedInputStream, fileDetail, filename, lang, title2, description, versionType, comment);
        if ("IFrame".equals(xRequestedWith)) {
            return Response.ok().type(MediaType.TEXT_HTML_TYPE).entity((Object)IFrameAjaxTransportUtil.packObjectToJSonDataWithHtmlContainer(entity)).build();
        }
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
    }

    protected SimpleDocumentEntity updateSimpleDocument(InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String filename, String lang, String title2, String description, String versionType, String comment) throws IOException {
        SimpleDocument document = this.getSimpleDocument(lang);
        boolean isPublic = false;
        if (StringUtil.isDefined((String)versionType) && StringUtil.isInteger((String)versionType)) {
            isPublic = Integer.parseInt(versionType) == 0;
            document.setPublicDocument(isPublic);
        }
        document.setUpdatedBy(this.getUserDetail().getId());
        document.setLanguage(lang);
        document.setTitle(title2);
        document.setDescription(description);
        document.setComment(comment);
        String uploadedFilename = filename;
        if (StringUtil.isNotDefined((String)filename)) {
            uploadedFilename = fileDetail.getFileName();
        }
        boolean isWebdav = false;
        if (uploadedInputStream != null && fileDetail != null && StringUtil.isDefined((String)uploadedFilename) && !"no_file".equalsIgnoreCase(uploadedFilename)) {
            document.setFilename(uploadedFilename);
            document.setContentType(FileUtil.getMimeType((String)uploadedFilename));
            File tempFile = File.createTempFile("silverpeas_", uploadedFilename);
            FileUtils.copyInputStreamToFile((InputStream)uploadedInputStream, (File)tempFile);
            ResourceLocator uploadSettings = new ResourceLocator("org.silverpeas.util.uploads.uploadSettings", "");
            long maximumFileSize = uploadSettings.getLong("MaximumFileSize", 0xA00000L);
            long fileSize = tempFile.length();
            if (fileSize > maximumFileSize) {
                FileUtils.deleteQuietly((File)tempFile);
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
            document.setSize(fileSize);
            BufferedInputStream content = new BufferedInputStream(new FileInputStream(tempFile));
            if (!StringUtil.isDefined((String)document.getEditedBy())) {
                document.edit(this.getUserDetail().getId());
            }
            AttachmentServiceFactory.getAttachmentService().updateAttachment(document, (InputStream)content, true, true);
            ((InputStream)content).close();
            FileUtils.deleteQuietly((File)tempFile);
        } else {
            boolean bl = isWebdav = document.isOpenOfficeCompatible() && document.isReadOnly();
            if (document.isVersioned()) {
                isWebdav = document.isOpenOfficeCompatible() && document.isReadOnly();
                File content = new File(document.getAttachmentPath());
                AttachmentServiceFactory.getAttachmentService().lock(document.getId(), this.getUserDetail().getId(), document.getLanguage());
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, content, true, true);
            } else {
                if (isWebdav) {
                    WebdavServiceFactory.getWebdavService().getUpdatedDocument(document);
                }
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, true, true);
            }
        }
        UnlockContext unlockContext = new UnlockContext(document.getId(), this.getUserDetail().getId(), lang, comment);
        if (isWebdav) {
            unlockContext.addOption(UnlockOption.WEBDAV);
        } else {
            unlockContext.addOption(UnlockOption.UPLOAD);
        }
        if (!isPublic) {
            unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
        }
        AttachmentServiceFactory.getAttachmentService().unlock(unlockContext);
        document = this.getSimpleDocument(lang);
        URI attachmentUri = this.getUriInfo().getRequestUriBuilder().path("document").path(document.getLanguage()).build(new Object[0]);
        return SimpleDocumentEntity.fromAttachment(document).withURI(attachmentUri);
    }

    @GET
    @Path(value="translations")
    @Produces(value={"application/json"})
    public SimpleDocumentEntity[] getDocumentTanslations() {
        ArrayList<SimpleDocumentEntity> result = new ArrayList<SimpleDocumentEntity>(I18NHelper.getNumberOfLanguages());
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocument attachment = this.getSimpleDocument(lang);
            if (attachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!lang.equals(attachment.getLanguage())) continue;
            URI attachmentUri = this.getUriInfo().getRequestUriBuilder().path("document").path(lang).build(new Object[0]);
            result.add(SimpleDocumentEntity.fromAttachment(attachment).withURI(attachmentUri));
        }
        return result.toArray(new SimpleDocumentEntity[result.size()]);
    }

    @Override
    public void validateUserAuthorization(UserPriviledgeValidation validation) throws WebApplicationException {
        super.validateUserAuthorization(validation);
        validation.validateUserAuthorizationOnAttachment(this.getUserDetail(), this.getSimpleDocument(null));
    }

    @GET
    @Path(value="content/{lang}")
    @Produces(value={"application/octet-stream"})
    public Response getFileContent(final @PathParam(value="lang") String language) {
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), language);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws WebApplicationException {
                try {
                    AttachmentServiceFactory.getAttachmentService().getBinaryContent(output, new SimpleDocumentPK(SimpleDocumentResource.this.getSimpleDocumentId()), language);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
        };
        return Response.ok((Object)stream).type(document.getContentType()).header("Content-Length", (Object)document.getSize()).header("content-disposition", (Object)("attachment;filename=" + document.getFilename())).build();
    }

    @PUT
    @Path(value="lock")
    @Produces(value={"application/json"})
    public String lock() {
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), I18NHelper.defaultLanguage);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        boolean result = AttachmentServiceFactory.getAttachmentService().lock(this.getSimpleDocumentId(), this.getUserDetail().getId(), I18NHelper.defaultLanguage);
        return MessageFormat.format("'{'\"status\":{0}}", result);
    }

    @PUT
    @Path(value="moveUp")
    @Produces(value={"application/json"})
    public String moveSimpleDocumentUp() {
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), I18NHelper.defaultLanguage);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        List docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey((WAPrimaryKey)new ForeignPK(document.getForeignId(), this.componentId), I18NHelper.defaultLanguage);
        int position = docs.indexOf(document);
        Collections.swap(docs, position, position - 1);
        AttachmentServiceFactory.getAttachmentService().reorderDocuments(docs);
        return MessageFormat.format("'{'\"status\":{0}}", true);
    }

    @PUT
    @Path(value="moveDown")
    @Produces(value={"application/json"})
    public String moveSimpleDocumentDown() {
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), I18NHelper.defaultLanguage);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        List docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey((WAPrimaryKey)new ForeignPK(document.getForeignId(), this.componentId), I18NHelper.defaultLanguage);
        int position = docs.indexOf(document);
        Collections.swap(docs, position, position + 1);
        AttachmentServiceFactory.getAttachmentService().reorderDocuments(docs);
        return MessageFormat.format("'{'\"status\":{0}}", true);
    }

    @POST
    @Path(value="unlock")
    @Produces(value={"application/json"})
    public String unlockDocument(@FormParam(value="force") boolean force, @FormParam(value="webdav") boolean webdav, @FormParam(value="private") boolean privateVersion, @FormParam(value="comment") String comment) {
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), I18NHelper.defaultLanguage);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        UnlockContext unlockContext = new UnlockContext(this.getSimpleDocumentId(), this.getUserDetail().getId(), I18NHelper.defaultLanguage, comment);
        if (force) {
            unlockContext.addOption(UnlockOption.FORCE);
        }
        if (webdav) {
            unlockContext.addOption(UnlockOption.WEBDAV);
        }
        if (privateVersion) {
            unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
        }
        boolean result = AttachmentServiceFactory.getAttachmentService().unlock(unlockContext);
        return MessageFormat.format("'{'\"status\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", result, document.getOldSilverpeasId(), document.getId());
    }

    @PUT
    @Path(value="switchState")
    @Produces(value={"application/json"})
    public String switchDocumentVersionState(@FormParam(value="switch-version-comment") String comment, @FormParam(value="switch-version") String version) {
        boolean useMajor = "lastMajor".equalsIgnoreCase(version);
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), I18NHelper.defaultLanguage);
        if (document == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        SimpleDocumentPK pk = new SimpleDocumentPK(this.getSimpleDocumentId());
        if (document.isVersioned() && useMajor) {
            pk = document.getLastPublicVersion().getPk();
        }
        pk = AttachmentServiceFactory.getAttachmentService().changeVersionState(pk, comment);
        document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, I18NHelper.defaultLanguage);
        return MessageFormat.format("'{'\"status\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", true, document.getOldSilverpeasId(), document.getId());
    }

    SimpleDocument getSimpleDocument(String lang) {
        return AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), lang);
    }
}

