/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.ResourceLocator;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.attachment.model.UnlockOption;
import org.silverpeas.attachment.web.SimpleDocumentEntity;
import org.silverpeas.web.util.IFrameAjaxTransportUtil;

@Service
@RequestScoped
@Path(value="documents/{componentId}/document/create")
@Authorized
public class SimpleDocumentResourceCreator
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @POST
    @Path(value="{filename}")
    @Consumes(value={"multipart/form-data"})
    public Response createDocument(@FormDataParam(value="file_upload") InputStream uploadedInputStream, @FormDataParam(value="file_upload") FormDataContentDisposition fileDetail, @FormDataParam(value="X-Requested-With") String xRequestedWith, @FormDataParam(value="fileLang") String language, @FormDataParam(value="fileTitle") String fileTitle, @FormDataParam(value="fileDescription") String description, @FormDataParam(value="foreignId") String foreignId, @FormDataParam(value="indexIt") String indexIt, @FormDataParam(value="versionType") String type, @FormDataParam(value="commentMessage") String comment, @FormDataParam(value="context") String context, @PathParam(value="filename") String filename) throws IOException {
        SimpleDocumentEntity entity = this.createSimpleDocument(uploadedInputStream, fileDetail, filename, language, fileTitle, description, foreignId, indexIt, type, comment, context);
        if ("IFrame".equals(xRequestedWith)) {
            return Response.ok().type(MediaType.TEXT_HTML_TYPE).entity((Object)IFrameAjaxTransportUtil.packObjectToJSonDataWithHtmlContainer(entity)).build();
        }
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
    }

    protected SimpleDocumentEntity createSimpleDocument(InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String filename, String language, String fileTitle, String fileDescription, String foreignId, String indexIt, String type, String comment, String context) throws IOException {
        String uploadedFilename = filename;
        if (StringUtil.isNotDefined((String)filename)) {
            uploadedFilename = fileDetail.getFileName();
        }
        if (uploadedInputStream != null && fileDetail != null && StringUtil.isDefined((String)uploadedFilename)) {
            SimpleDocument document;
            File tempFile = File.createTempFile("silverpeas_", uploadedFilename);
            FileUtils.copyInputStreamToFile((InputStream)uploadedInputStream, (File)tempFile);
            ResourceLocator uploadSettings = new ResourceLocator("org.silverpeas.util.uploads.uploadSettings", "");
            long maximumFileSize = uploadSettings.getLong("MaximumFileSize", 0xA00000L);
            long fileSize = tempFile.length();
            if (fileSize > maximumFileSize) {
                FileUtils.deleteQuietly((File)tempFile);
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
            String lang = I18NHelper.checkLanguage((String)language);
            String title2 = fileTitle;
            String description = fileDescription;
            if (!StringUtil.isDefined((String)fileTitle)) {
                MetadataExtractor extractor = new MetadataExtractor();
                MetaData metadata = extractor.extractMetadata(tempFile);
                title2 = StringUtil.isDefined((String)metadata.getTitle()) ? metadata.getTitle() : "";
                if (!StringUtil.isDefined((String)description) && StringUtil.isDefined((String)metadata.getSubject())) {
                    description = metadata.getSubject();
                }
            }
            if (!StringUtil.isDefined((String)description)) {
                description = "";
            }
            DocumentType attachmentContext = !StringUtil.isDefined((String)context) ? DocumentType.attachment : DocumentType.valueOf((String)context);
            SimpleDocumentPK pk = new SimpleDocumentPK(null, this.componentId);
            String userId = this.getUserDetail().getId();
            boolean needCreation = true;
            boolean publicDocument = true;
            if (StringUtil.isDefined((String)type) && StringUtil.isInteger((String)type)) {
                document = AttachmentServiceFactory.getAttachmentService().findExistingDocument(pk, uploadedFilename, new ForeignPK(foreignId, this.componentId), lang);
                publicDocument = Integer.parseInt(type) == 0;
                boolean bl = needCreation = document == null;
                if (document == null) {
                    document = new HistorisedDocument(pk, foreignId, 0, userId, new SimpleAttachment(uploadedFilename, lang, title2, description, fileDetail.getSize(), FileUtil.getMimeType((String)uploadedFilename), userId, new Date(), null));
                    document.setDocumentType(attachmentContext);
                }
                document.setPublicDocument(publicDocument);
                document.setComment(comment);
            } else {
                document = new SimpleDocument(pk, foreignId, 0, false, null, new SimpleAttachment(uploadedFilename, lang, title2, description, fileDetail.getSize(), FileUtil.getMimeType((String)uploadedFilename), userId, new Date(), null));
                document.setDocumentType(attachmentContext);
            }
            document.setLanguage(lang);
            document.setTitle(title2);
            document.setDescription(description);
            document.setSize(fileSize);
            BufferedInputStream content = new BufferedInputStream(new FileInputStream(tempFile));
            if (needCreation) {
                document = AttachmentServiceFactory.getAttachmentService().createAttachment(document, (InputStream)content, StringUtil.getBooleanValue((String)indexIt), publicDocument);
            } else {
                document.edit(userId);
                AttachmentServiceFactory.getAttachmentService().lock(document.getId(), userId, lang);
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, (InputStream)content, StringUtil.getBooleanValue((String)indexIt), true);
                UnlockContext unlockContext = new UnlockContext(document.getId(), userId, lang);
                unlockContext.addOption(UnlockOption.UPLOAD);
                if (!publicDocument) {
                    unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
                }
                AttachmentServiceFactory.getAttachmentService().unlock(unlockContext);
            }
            ((InputStream)content).close();
            FileUtils.deleteQuietly((File)tempFile);
            URI attachmentUri = this.getUriInfo().getRequestUriBuilder().path("document").path(document.getLanguage()).build(new Object[0]);
            return SimpleDocumentEntity.fromAttachment(document).withURI(attachmentUri);
        }
        return null;
    }
}

