/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar;

import java.util.Date;
import org.silverpeas.calendar.CalendarDateTime;
import org.silverpeas.date.Period;
import org.silverpeas.date.PeriodType;

public class CalendarPeriod {
    private Period period;
    private CalendarDateTime beginDate;
    private CalendarDateTime endDate;

    public static CalendarPeriod from(Date referenceDate, PeriodType periodType, String locale) {
        return CalendarPeriod.from(Period.from((Date)referenceDate, (PeriodType)periodType, (String)locale), locale);
    }

    public static CalendarPeriod from(Period period, String locale) {
        return new CalendarPeriod(period, locale);
    }

    private CalendarPeriod(Period period, String locale) {
        this.period = period;
        this.beginDate = new CalendarDateTime(period.getBeginDate(), locale);
        this.endDate = new CalendarDateTime(period.getEndDate(), locale);
    }

    public PeriodType getPeriodType() {
        return this.period.getPeriodType();
    }

    public CalendarDateTime getBeginDate() {
        return this.beginDate;
    }

    public CalendarDateTime getEndDate() {
        return this.endDate;
    }
}

