/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar;

import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.silverpeas.calendar.CalendarDay;
import org.silverpeas.calendar.CalendarPeriod;
import org.silverpeas.calendar.CalendarViewType;
import org.silverpeas.date.Period;
import org.silverpeas.date.PeriodType;

public class CalendarViewContext {
    private static final Map<String, ResourceLocator> bundles = new HashMap<String, ResourceLocator>();
    private static final EnumSet<PeriodType> DISPLAY_WEEK_PERIODS = EnumSet.of(PeriodType.week, PeriodType.day);
    private String locale = null;
    private final String componentInstanceId;
    private CalendarViewType viewType = CalendarViewType.MONTHLY;
    private CalendarDay referenceDay;
    private CalendarPeriod referencePeriod;
    private boolean withWeekend = true;

    public CalendarViewContext(String componentInstanceId, String locale) {
        this.componentInstanceId = componentInstanceId;
        this.locale = locale;
        this.setReferenceDay(DateUtil.getDate());
    }

    public CalendarViewContext resetFilters() {
        this.setViewType(CalendarViewType.MONTHLY);
        this.today();
        return this;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public CalendarViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(CalendarViewType viewType) {
        this.viewType = viewType;
        this.setReferenceDay(this.referenceDay.getDate());
    }

    public CalendarPeriod getReferencePeriod() {
        return this.referencePeriod;
    }

    public String getReferencePeriodLabel() {
        return CalendarViewContext.getPeriodLabel(this.getReferencePeriod(), this.locale);
    }

    public CalendarDay getReferenceDay() {
        return this.referenceDay;
    }

    public String getFormattedReferenceDay() {
        return DateUtil.getOutputDate((Date)this.getReferenceDay().getDate(), (String)this.locale);
    }

    public void setReferenceDay(Date date) {
        this.setReferenceDay(date, 0);
    }

    private void setReferenceDay(Date date, int offset) {
        Date referenceDate;
        Calendar cal = DateUtil.convert((Date)date, (String)this.locale);
        if (!this.withWeekend && (this.viewType.equals((Object)CalendarViewType.WEEKLY) || this.viewType.equals((Object)CalendarViewType.DAILY))) {
            switch (cal.get(7)) {
                case 7: {
                    if (7 == DateUtil.getFirstDayOfWeek((String)this.locale)) {
                        referenceDate = DateUtils.addDays((Date)date, (int)(offset >= 0 ? 2 : -1));
                        break;
                    }
                    referenceDate = DateUtils.addDays((Date)date, (int)(offset > 0 ? 2 : -1));
                    break;
                }
                case 1: {
                    if (1 == DateUtil.getFirstDayOfWeek((String)this.locale)) {
                        referenceDate = DateUtils.addDays((Date)date, (int)(offset >= 0 ? 1 : -2));
                        break;
                    }
                    referenceDate = DateUtils.addDays((Date)date, (int)(offset > 0 ? 1 : -2));
                    break;
                }
                default: {
                    referenceDate = date;
                    break;
                }
            }
        } else {
            referenceDate = date;
        }
        this.referenceDay = new CalendarDay(referenceDate, this.locale);
        this.referencePeriod = CalendarPeriod.from(Period.from((Date)referenceDate, (PeriodType)this.viewType.getPeriodeType(), (String)this.locale), this.locale);
    }

    public void previous() {
        this.moveReferenceDate(-1);
    }

    public void next() {
        this.moveReferenceDate(1);
    }

    private void moveReferenceDate(int offset) {
        switch (this.viewType) {
            case YEARLY: {
                this.setReferenceDay(DateUtils.addYears((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case MONTHLY: {
                this.setReferenceDay(DateUtils.addMonths((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case WEEKLY: {
                this.setReferenceDay(DateUtils.addWeeks((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case DAILY: {
                this.setReferenceDay(DateUtils.addDays((Date)this.referenceDay.getDate(), (int)offset), offset);
            }
        }
    }

    public void today() {
        this.setReferenceDay(DateUtil.getDate());
    }

    public boolean isWithWeekend() {
        return this.withWeekend;
    }

    public void setWithWeekend(boolean withWeekend) {
        this.withWeekend = withWeekend;
    }

    public int getFirstDayOfWeek() {
        return DateUtil.getFirstDayOfWeek((String)this.locale);
    }

    protected static ResourceLocator getBundle(String language) {
        ResourceLocator bundle = bundles.get(language);
        if (bundle == null) {
            bundle = GeneralPropertiesManager.getGeneralMultilang((String)language);
            bundles.put(language, bundle);
        }
        return bundle;
    }

    public static String getPeriodLabel(CalendarPeriod period, String language) {
        ResourceLocator bundle = CalendarViewContext.getBundle(language);
        StringBuilder periodLabel = new StringBuilder();
        boolean displayWeek = DISPLAY_WEEK_PERIODS.contains(period.getPeriodType());
        periodLabel.append(bundle.getString("GML.mois" + period.getBeginDate().getMonth()));
        if (period.getBeginDate().getMonth() != period.getEndDate().getMonth()) {
            displayWeek = true;
            if (period.getBeginDate().getYear() != period.getEndDate().getYear()) {
                periodLabel.append(" ").append(period.getBeginDate().getYear());
            }
            periodLabel.append(" / ").append(bundle.getString("GML.mois" + period.getEndDate().getMonth()));
        }
        periodLabel.append(" ").append(period.getEndDate().getYear());
        if (displayWeek) {
            periodLabel.append(" - ").append(bundle.getString("GML.week")).append(' ').append(period.getBeginDate().getWeekOfYear());
        }
        return periodLabel.toString();
    }
}

