/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.silverpeas.date.PeriodType;

public enum CalendarViewType {
    YEARLY(PeriodType.year, "year"),
    MONTHLY(PeriodType.month, "month"),
    WEEKLY(PeriodType.week, "agendaWeek"),
    DAILY(PeriodType.day, "agendaDay"),
    NEXT_EVENTS(PeriodType.unknown, "nextevents");

    private PeriodType periodeType;
    private String calendarView;

    public String toString() {
        return this.calendarView;
    }

    public boolean isYearlyView() {
        return this == YEARLY;
    }

    public boolean isMonthlyView() {
        return this == MONTHLY;
    }

    public boolean isWeeklyView() {
        return this == WEEKLY;
    }

    public boolean isDailyView() {
        return this == DAILY;
    }

    public boolean isNextEventsView() {
        return this == NEXT_EVENTS;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public PeriodType getPeriodeType() {
        return this.periodeType;
    }

    private CalendarViewType(PeriodType periodeType, String viewMode) {
        this.periodeType = periodeType;
        this.calendarView = viewMode;
    }

    @JsonCreator
    public static CalendarViewType from(String name) {
        if (name != null) {
            for (CalendarViewType viewType : CalendarViewType.values()) {
                if (!name.equalsIgnoreCase(viewType.name())) continue;
                return viewType;
            }
        }
        return null;
    }
}

