/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar.web;

import com.silverpeas.calendar.Datable;
import com.silverpeas.web.Exposable;
import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractEventEntity<T extends AbstractEventEntity<T>>
implements Exposable {
    private static final long serialVersionUID = -7592985250664860865L;
    @XmlElement(required=true, defaultValue="")
    private final String type;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private final String id;
    @XmlElement(defaultValue="")
    private final String instanceId;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private final String title;
    @XmlElement(defaultValue="")
    private final String description;
    @XmlElement
    private boolean allDay = false;
    @XmlElement(defaultValue="")
    @NotNull
    @Size(min=1)
    private final String start;
    @XmlElement(defaultValue="")
    private final String end;
    @XmlElement(defaultValue="")
    private final String url;

    protected AbstractEventEntity(String type, String instanceId, String id, String title2, String description, Datable start, Datable end, String url) {
        this.type = type;
        this.instanceId = instanceId;
        this.id = id;
        this.title = title2;
        this.description = description;
        this.start = start != null ? start.toShortISO8601() : null;
        this.end = end != null ? end.toShortISO8601() : null;
        this.allDay = start == null && end == null;
        this.url = url;
    }

    protected AbstractEventEntity() {
        this("", "", "", "", "", null, null, "");
    }

    public T withURI(URI uri) {
        this.uri = uri;
        return (T)this;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.id).append((Object)this.title).append((Object)this.start).append((Object)this.end).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractEventEntity other = (AbstractEventEntity)obj;
        return new EqualsBuilder().append((Object)this.getType(), (Object)other.getType()).append((Object)this.id, (Object)other.getId()).append((Object)this.title, (Object)other.title).append((Object)this.start, (Object)other.start).append((Object)this.end, (Object)other.end).isEquals();
    }
}

