/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.contribution.web;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.displayers.WysiwygFCKFieldDisplayer;
import com.silverpeas.form.fieldType.UserField;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.stratelia.silverpeas.peasCore.URLManager;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.contribution.web.FormFieldValueEntity;

public abstract class AbstractContributionResource
extends RESTWebService {
    public abstract String getContributionId();

    protected String getDefaultFormId() {
        String xmlFormName = this.getOrganisationController().getComponentParameterValue(this.getComponentId(), "XMLFormName");
        if (StringUtil.isDefined((String)xmlFormName)) {
            return xmlFormName.substring(xmlFormName.indexOf("/") + 1, xmlFormName.indexOf("."));
        }
        return null;
    }

    protected String getDefaultPublicationTemplateLanguage() {
        return this.getUserPreferences().getLanguage();
    }

    private String createExternalId(String formId) {
        return this.getComponentId() + ":" + formId;
    }

    protected FormFieldValueEntity getFormFieldValue(FieldTemplate fieldTemplate, DataRecord data, String lang) throws Exception {
        FormFieldValueEntity entity;
        Field field = data.getField(fieldTemplate.getFieldName());
        if ("file".equals(field.getTypeName())) {
            String fieldValue = field.getValue(lang);
            String attachmentId = null;
            String attachmentUrl = null;
            URI attachmentUri = null;
            if (StringUtil.isDefined((String)fieldValue)) {
                String serverApplicationURL = URLManager.getServerURL((HttpServletRequest)this.getHttpServletRequest()) + URLManager.getApplicationURL();
                if (fieldValue.startsWith("/")) {
                    attachmentUrl = fieldValue;
                    fieldValue = null;
                } else {
                    SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(fieldValue, this.getComponentId()), lang);
                    if (attachment != null) {
                        attachmentId = fieldValue;
                        fieldValue = attachment.getTitle();
                        attachmentUrl = serverApplicationURL + attachment.getAttachmentURL();
                        attachmentUri = new URI(URLManager.getServerURL((HttpServletRequest)this.getHttpServletRequest()) + URLManager.getSimpleURL((int)4, (String)attachmentId));
                    }
                }
            }
            if (fieldValue == null) {
                fieldValue = "";
            }
            entity = FormFieldValueEntity.createFrom(attachmentId, fieldValue).withLink(attachmentUrl).withAttachmentURI(attachmentUri);
        } else if ("user".equals(field.getTypeName())) {
            UserField userField = (UserField)field;
            entity = FormFieldValueEntity.createFrom(userField.getUserId(), userField.getValue());
        } else {
            Map keyValuePairs;
            String fieldValue = field.getValue(lang);
            entity = StringUtil.isDefined((String)fieldValue) ? (fieldValue.startsWith("xmlWysiwygField_") ? FormFieldValueEntity.createFrom(null, WysiwygFCKFieldDisplayer.getContentFromFile((String)this.getComponentId(), (String)this.getContributionId(), (String)fieldTemplate.getFieldName(), (String)lang)) : ((keyValuePairs = ((GenericFieldTemplate)fieldTemplate).getKeyValuePairs(lang)).isEmpty() ? FormFieldValueEntity.createFrom(null, fieldValue) : FormFieldValueEntity.createFrom(!fieldValue.contains("##") ? fieldValue : null, (String)keyValuePairs.get(fieldValue)))) : FormFieldValueEntity.createFrom(null, "");
        }
        return entity;
    }

    protected PublicationTemplate getPublicationTemplate(String formId) throws PublicationTemplateException {
        try {
            return PublicationTemplateManager.getInstance().getPublicationTemplate(this.createExternalId(formId));
        }
        catch (PublicationTemplateException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }
}

