/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.contribution.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.util.StringUtil;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.contribution.web.AbstractContributionResource;
import org.silverpeas.contribution.web.ContributionResourceURIs;
import org.silverpeas.contribution.web.FormEntity;
import org.silverpeas.contribution.web.FormFieldEntity;
import org.silverpeas.contribution.web.FormFieldValueEntity;

@Service
@RequestScoped
@Path(value="contribution/{componentInstanceId}/{contributionId}/content")
@Authorized
public class ContributionContentResource
extends AbstractContributionResource {
    @PathParam(value="componentInstanceId")
    private String componentInstanceId;
    @PathParam(value="contributionId")
    private String contributionId;

    @Override
    public String getComponentId() {
        return this.componentInstanceId;
    }

    @Override
    public String getContributionId() {
        return this.contributionId;
    }

    @GET
    @Path(value="form")
    @Produces(value={"application/json"})
    public FormEntity getFormContent(@QueryParam(value="lang") String lang) {
        return this.getFormContent(this.getDefaultFormId(), lang);
    }

    @GET
    @Path(value="form/{formId}")
    @Produces(value={"application/json"})
    public FormEntity getFormContent(@PathParam(value="formId") String formId, @QueryParam(value="lang") String lang) {
        try {
            PublicationTemplate publicationTemplate;
            String language = StringUtil.isDefined((String)lang) ? lang : this.getDefaultPublicationTemplateLanguage();
            RecordTemplate recordTemplate = null;
            DataRecord data = null;
            if (StringUtil.isDefined((String)formId) && (publicationTemplate = this.getPublicationTemplate(formId)) != null) {
                recordTemplate = publicationTemplate.getRecordTemplate();
                data = publicationTemplate.getRecordSet().getRecord(this.contributionId, language);
            }
            if (data == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            FormEntity form = FormEntity.createFrom(formId);
            for (FieldTemplate fieldTemplate : recordTemplate.getFieldTemplates()) {
                FormFieldValueEntity fieldValueEntity = this.getFormFieldValue(fieldTemplate, data, language);
                FormFieldEntity fieldEntity = FormFieldEntity.createFrom(fieldTemplate.getTypeName(), fieldTemplate.getFieldName(), fieldTemplate.getLabel(language), fieldValueEntity);
                form.addFormField(fieldEntity);
            }
            return (FormEntity)form.withURI(ContributionResourceURIs.buildURIOfContributionFormContent(this, formId));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }
}

